/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.util.Vector;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlAdapter
implements GainControl {
    private Vector listeners = null;
    private boolean muteState;
    private Component component;
    private float DefLevel = 0.4f;
    private float dB = 0.0f;
    private float level = this.DefLevel;

    public GainControlAdapter() {
    }

    public GainControlAdapter(float f2) {
        this.DefLevel = f2;
        this.level = f2;
    }

    public GainControlAdapter(boolean bl) {
        this.muteState = bl;
        this.setLevel(this.DefLevel);
    }

    public synchronized void addGainChangeListener(GainChangeListener gainChangeListener) {
        if (gainChangeListener != null) {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(gainChangeListener);
        }
    }

    public Component getControlComponent() {
        return null;
    }

    public float getDB() {
        return this.dB;
    }

    public float getLevel() {
        return this.level;
    }

    public boolean getMute() {
        return this.muteState;
    }

    protected synchronized void informListeners() {
        if (this.listeners != null) {
            GainChangeEvent gainChangeEvent = new GainChangeEvent(this, this.muteState, this.dB, this.level);
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                GainChangeListener gainChangeListener = (GainChangeListener)this.listeners.elementAt(n2);
                gainChangeListener.gainChange(gainChangeEvent);
                ++n2;
            }
        }
    }

    public synchronized void removeGainChangeListener(GainChangeListener gainChangeListener) {
        if (gainChangeListener != null && this.listeners != null) {
            this.listeners.removeElement(gainChangeListener);
        }
    }

    public float setDB(float f2) {
        if (this.dB != f2) {
            this.dB = f2;
            float f3 = (float)Math.pow(10.0, (double)this.dB / 20.0);
            this.level = f3 * this.DefLevel;
            if ((double)this.level < 0.0) {
                this.setLevel(0.0f);
            } else if ((double)this.level > 1.0) {
                this.setLevel(1.0f);
            } else {
                this.setLevel(this.level);
                this.informListeners();
            }
        }
        return this.dB;
    }

    public float setLevel(float f2) {
        if ((double)f2 < 0.0) {
            f2 = 0.0f;
        }
        if ((double)f2 > 1.0) {
            f2 = 1.0f;
        }
        if (this.level != f2) {
            this.level = f2;
            float f3 = f2 / this.DefLevel;
            this.dB = (float)(Math.log((double)f3 == 0.0 ? 1.0E-4 : (double)f3) / Math.log(10.0) * 20.0);
            this.informListeners();
        }
        return this.level;
    }

    public void setMute(boolean bl) {
        if (this.muteState != bl) {
            this.muteState = bl;
            this.informListeners();
        }
    }
}

