/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;

class SParser {
    byte[] script;
    int pos;
    int end;
    int bitBuf;
    int bitPos;

    SParser() {
    }

    final void Attach(byte[] byArray, int n2) {
        this.script = byArray;
        this.pos = n2;
    }

    final void CopyByteArray(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.script, this.pos, byArray, n2, n3);
        this.pos += n3;
    }

    final int GetBits(int n2) {
        int n3;
        int n4 = 0;
        while ((n3 = n2 - this.bitPos) > 0) {
            n4 |= this.bitBuf << n3;
            n2 -= this.bitPos;
            this.bitBuf = this.GetByte();
            this.bitPos = 8;
        }
        this.bitPos -= n2;
        this.bitBuf &= 255 >>> 8 - this.bitPos;
        return n4 |= this.bitBuf >>> -n3;
    }

    final int GetByte() {
        return this.script[this.pos++] & 0xFF;
    }

    final byte[] GetByteArray(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.script, this.pos, byArray, 0, n2);
        this.pos += n2;
        return byArray;
    }

    final int GetColor() {
        int n2 = -16777216;
        n2 |= this.GetByte() << 16;
        n2 |= this.GetByte() << 8;
        return n2 |= this.GetByte();
    }

    void GetColorTransform(ColorTransform colorTransform) {
        this.InitBits();
        colorTransform.flags = this.GetBits(2);
        int n2 = this.GetBits(4);
        if ((colorTransform.flags & 1) != 0) {
            colorTransform.ra = this.GetSBits(n2);
            colorTransform.ga = this.GetSBits(n2);
            colorTransform.ba = this.GetSBits(n2);
        } else {
            colorTransform.ba = 256;
            colorTransform.ga = 256;
            colorTransform.ra = 256;
        }
        if ((colorTransform.flags & 2) != 0) {
            colorTransform.rb = this.GetSBits(n2);
            colorTransform.gb = this.GetSBits(n2);
            colorTransform.bb = this.GetSBits(n2);
        } else {
            colorTransform.bb = 0;
            colorTransform.gb = 0;
            colorTransform.rb = 0;
        }
    }

    final int GetDWord() {
        int n2 = this.script[this.pos] & 0xFF | (this.script[this.pos + 1] & 0xFF) << 8 | (this.script[this.pos + 2] & 0xFF) << 16 | (this.script[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return n2;
    }

    final Matrix GetMatrix() {
        int n2;
        this.InitBits();
        Matrix matrix = new Matrix();
        if (this.GetBits(1) != 0) {
            n2 = this.GetBits(5);
            matrix.a = this.GetSBits(n2);
            matrix.d = this.GetSBits(n2);
        } else {
            matrix.d = 65536;
            matrix.a = 65536;
        }
        if (this.GetBits(1) != 0) {
            n2 = this.GetBits(5);
            matrix.b = this.GetSBits(n2);
            matrix.c = this.GetSBits(n2);
        } else {
            matrix.c = 0;
            matrix.b = 0;
        }
        n2 = this.GetBits(5);
        matrix.tx = this.GetSBits(n2);
        matrix.ty = this.GetSBits(n2);
        return matrix;
    }

    final Rect GetRect() {
        this.InitBits();
        int n2 = this.GetBits(5);
        Rect rect = new Rect();
        rect.xmin = this.GetSBits(n2);
        rect.xmax = this.GetSBits(n2);
        rect.ymin = this.GetSBits(n2);
        rect.ymax = this.GetSBits(n2);
        return rect;
    }

    final int GetSBits(int n2) {
        int n3 = this.GetBits(n2);
        if ((n3 & 1 << n2 - 1) != 0) {
            n3 |= -1 << n2;
        }
        return n3;
    }

    final int GetSWord() {
        int n2 = this.GetWord();
        if ((n2 & 0x8000) != 0) {
            n2 |= 0xFFFF0000;
        }
        return n2;
    }

    final void GetSoundInfo(int[] nArray, int[] nArray2, boolean bl) {
        block9: {
            int n2;
            block8: {
                n2 = this.GetByte();
                if (!bl) break block8;
                if ((n2 & 1) != 0) {
                    this.GetDWord();
                }
                if ((n2 & 2) != 0) {
                    this.GetDWord();
                }
                if ((n2 & 4) != 0) {
                    this.GetWord();
                }
                if ((n2 & 8) == 0) break block9;
                int n3 = this.GetByte();
                int n4 = 0;
                while (n4 < n3) {
                    this.GetDWord();
                    this.GetWord();
                    this.GetWord();
                    ++n4;
                }
                break block9;
            }
            nArray2[0] = n2 >> 4;
            if ((n2 & 1) != 0) {
                this.GetDWord();
            }
            if ((n2 & 2) != 0) {
                this.GetDWord();
            }
            nArray[0] = (n2 & 4) != 0 ? this.GetWord() : 1;
            if ((n2 & 8) != 0) {
                int n5 = this.GetByte();
                int n6 = 0;
                while (n6 < n5) {
                    this.GetDWord();
                    this.GetWord();
                    this.GetWord();
                    ++n6;
                }
            }
        }
    }

    final String GetString() {
        char c2;
        int n2 = 0;
        int n3 = this.pos;
        while ((c2 = (char)this.GetByte()) != '\u0000') {
            ++n2;
        }
        this.pos = n3;
        char[] cArray = new char[n2];
        int n4 = 0;
        while (true) {
            char c3 = (char)this.GetByte();
            if (n4 == n2) break;
            cArray[n4++] = c3;
        }
        return new String(cArray);
    }

    final int GetWord() {
        int n2 = this.script[this.pos] & 0xFF | (this.script[this.pos + 1] & 0xFF) << 8;
        this.pos += 2;
        return n2;
    }

    final void InitBits() {
        this.bitPos = 0;
        this.bitBuf = 0;
    }
}

