/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicProcessor;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphNode;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.SlowPlugIn;
import com.sun.media.codec.video.colorspace.RGBScaler;
import com.sun.media.controls.ProgressControl;
import com.sun.media.util.Resource;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessEngine
extends PlaybackEngine {
    protected BasicMuxModule muxModule;
    protected ContentDescriptor outputContentDes = null;
    String prefetchError = "Failed to prefetch: " + this;
    protected Vector targetMuxNames = null;
    protected GraphNode[] targetMuxes = null;
    protected GraphNode targetMux = null;
    protected Format[] targetMuxFormats = null;

    public ProcessEngine(BasicProcessor basicProcessor) {
        super(basicProcessor);
    }

    boolean connectMux() {
        BasicTrackControl[] basicTrackControlArray = new BasicTrackControl[this.trackControls.length];
        int n2 = 0;
        Multiplexer multiplexer = (Multiplexer)this.targetMux.plugin;
        int n3 = 0;
        while (n3 < this.trackControls.length) {
            if (this.trackControls[n3].isEnabled()) {
                basicTrackControlArray[n2++] = this.trackControls[n3];
            }
            ++n3;
        }
        try {
            multiplexer.setContentDescriptor(this.outputContentDes);
        }
        catch (Exception exception) {
            Log.comment("Failed to set the output content descriptor on the multiplexer.");
            return false;
        }
        boolean bl = false;
        if (multiplexer.setNumTracks(this.targetMuxFormats.length) != this.targetMuxFormats.length) {
            Log.comment("Failed  to set number of tracks on the multiplexer.");
            return false;
        }
        int n4 = 0;
        while (n4 < this.targetMuxFormats.length) {
            if (this.targetMuxFormats[n4] == null || multiplexer.setInputFormat(this.targetMuxFormats[n4], n4) == null) {
                Log.comment("Failed to set input format on the multiplexer.");
                bl = true;
                break;
            }
            ++n4;
        }
        if (bl) {
            return false;
        }
        if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify(multiplexer, this.targetMuxFormats)) {
            return false;
        }
        BasicMuxModule basicMuxModule = new BasicMuxModule(multiplexer, this.targetMuxFormats);
        if (PlaybackEngine.DEBUG) {
            basicMuxModule.setJMD(this.jmd);
        }
        int n5 = 0;
        while (n5 < this.targetMuxFormats.length) {
            InputConnector inputConnector = basicMuxModule.getInputConnector(String.valueOf(BasicMuxModule.ConnectorNamePrefix) + n5);
            if (inputConnector == null) {
                Log.comment("BasicMuxModule: connector mismatched.");
                return false;
            }
            inputConnector.setFormat(this.targetMuxFormats[n5]);
            basicTrackControlArray[n5].lastOC.setProtocol(inputConnector.getProtocol());
            basicTrackControlArray[n5].lastOC.connectTo(inputConnector, this.targetMuxFormats[n5]);
            ++n5;
        }
        if (!basicMuxModule.doRealize()) {
            return false;
        }
        basicMuxModule.setModuleListener(this);
        basicMuxModule.setController(this);
        this.modules.addElement(basicMuxModule);
        this.sinks.addElement(basicMuxModule);
        this.muxModule = basicMuxModule;
        return true;
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] stringArray = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        int n2 = 0;
        while (n2 < this.tracks.length) {
            this.trackControls[n2] = new ProcTControl(this, this.tracks[n2], this.source.getOutputConnector(stringArray[n2]));
            ++n2;
        }
        if (!this.doConfigure2()) {
            return false;
        }
        this.outputContentDes = new ContentDescriptor("raw");
        this.reenableHintTracks();
        return true;
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        if (!this.doPrefetch1()) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            Log.error(this.prefetchError);
            Log.error("  Cannot prefetch the multiplexer: " + this.muxModule.getMultiplexer() + "\n");
            return false;
        }
        return this.doPrefetch2();
    }

    protected synchronized boolean doRealize() {
        this.targetMuxes = null;
        if (!super.doRealize1()) {
            return false;
        }
        if (this.targetMux != null && !this.connectMux()) {
            Log.error(this.realizeError);
            Log.error("  Cannot connect the multiplexer\n");
            this.player.processError = this.genericProcessorError;
            return false;
        }
        return super.doRealize2();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.doStart2();
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.doStop2();
    }

    protected BasicSinkModule findMasterSink() {
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            return this.muxModule;
        }
        return super.findMasterSink();
    }

    protected long getBitRate() {
        if (this.muxModule != null) {
            return this.muxModule.getBitsWritten();
        }
        return this.source.getBitsRead();
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getContentDescriptor " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("getDataOutput " + PlaybackEngine.NOT_REALIZED_ERROR));
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    BasicMuxModule getMuxModule() {
        return this.muxModule;
    }

    protected PlugIn getPlugIn(BasicModule basicModule) {
        if (basicModule instanceof BasicMuxModule) {
            return ((BasicMuxModule)basicModule).getMultiplexer();
        }
        return super.getPlugIn(basicModule);
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getSupportedContentDescriptors " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        Vector vector = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> vector2 = new Vector<Format>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Format[] formatArray = PlugInManager.getSupportedOutputFormats((String)vector.elementAt(n2), 5);
            if (formatArray != null) {
                int n3 = 0;
                while (n3 < formatArray.length) {
                    if (formatArray[n3] instanceof ContentDescriptor) {
                        boolean bl = false;
                        int n4 = 0;
                        while (n4 < vector2.size()) {
                            if (vector2.elementAt(n4).equals(formatArray[n3])) {
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bl) {
                            vector2.addElement(formatArray[n3]);
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        ContentDescriptor[] contentDescriptorArray = new ContentDescriptor[vector2.size()];
        n2 = 0;
        while (n2 < vector2.size()) {
            contentDescriptorArray[n2] = (ContentDescriptor)vector2.elementAt(n2);
            ++n2;
        }
        return contentDescriptorArray;
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getTrackControls " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        return this.trackControls;
    }

    boolean isRTPFormat(Format format) {
        return format != null && format.getEncoding() != null && format.getEncoding().endsWith("rtp") || format.getEncoding().endsWith("RTP");
    }

    void reenableHintTracks() {
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.isRTPFormat(this.trackControls[n2].getOriginalFormat())) {
                this.trackControls[n2].setEnabled(true);
                break;
            }
            ++n2;
        }
    }

    protected void resetBitRate() {
        if (this.muxModule != null) {
            this.muxModule.resetBitsWritten();
        } else {
            this.source.resetBitsRead();
        }
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) throws NotConfiguredError {
        Vector vector;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("setContentDescriptor " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        if (this.getState() > 180) {
            return null;
        }
        if (contentDescriptor != null && ((vector = PlugInManager.getPlugInList(null, contentDescriptor, 5)) == null || vector.size() == 0)) {
            return null;
        }
        this.outputContentDes = contentDescriptor;
        return this.outputContentDes;
    }

    class ProcTControl
    extends BasicTrackControl
    implements Owned {
        protected Format formatWanted = null;
        protected Codec[] codecChainWanted = null;
        protected Renderer rendererWanted = null;
        protected ProcGraphBuilder gb;
        protected Format[] supportedFormats = null;

        public ProcTControl(ProcessEngine processEngine2, Track track, OutputConnector outputConnector) {
            super(processEngine2, track, outputConnector);
        }

        public boolean buildTrack(int n2, int n3) {
            if (this.gb == null) {
                this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
            } else {
                this.gb.reset();
            }
            boolean bl = this.gb.buildGraph(this, n2, n3);
            this.gb = null;
            return bl;
        }

        private Format checkSize(Format format) {
            Format format2;
            if (!(format instanceof VideoFormat)) {
                return format;
            }
            VideoFormat videoFormat = (VideoFormat)format;
            Dimension dimension = ((VideoFormat)format).getSize();
            if (dimension == null && ((format2 = this.getOriginalFormat()) == null || (dimension = ((VideoFormat)format2).getSize()) == null)) {
                return format;
            }
            int n2 = dimension.width;
            int n3 = dimension.height;
            if (format.matches(new VideoFormat("jpeg/rtp")) || format.matches(new VideoFormat("jpeg"))) {
                if (dimension.width % 8 != 0) {
                    n2 = dimension.width / 8 * 8;
                }
                if (dimension.height % 8 != 0) {
                    n3 = dimension.height / 8 * 8;
                }
                if (n2 == 0 || n3 == 0) {
                    n2 = dimension.width;
                    n3 = dimension.height;
                }
            } else if (format.matches(new VideoFormat("h263/rtp")) || format.matches(new VideoFormat("h263-1998/rtp")) || format.matches(new VideoFormat("h263"))) {
                if (dimension.width >= 352) {
                    n2 = 352;
                    n3 = 288;
                } else if (dimension.width >= 160) {
                    n2 = 176;
                    n3 = 144;
                } else {
                    n2 = 128;
                    n3 = 96;
                }
            }
            if (n2 != dimension.width || n3 != dimension.height) {
                Log.comment("setFormat: " + format.getEncoding() + ": video aspect ratio mismatched.");
                Log.comment("  Scaled from " + dimension.width + "x" + dimension.height + " to " + n2 + "x" + n3 + ".\n");
                format = new VideoFormat(null, new Dimension(n2, n3), -1, null, -1.0f).intersects(format);
            }
            return format;
        }

        protected FrameRateControl frameRateControl() {
            this.muxModule = ProcessEngine.this.getMuxModule();
            return ProcessEngine.this.frameRateControl;
        }

        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        public Object getOwner() {
            return ProcessEngine.this.player;
        }

        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null && (this.supportedFormats = Resource.getDB(this.track.getFormat())) == null) {
                if (this.gb == null) {
                    this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
                this.supportedFormats = Resource.putDB(this.track.getFormat(), this.supportedFormats);
                PlaybackEngine.needSavingDB = true;
            }
            if (ProcessEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(ProcessEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        public boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        public boolean isTimeBase() {
            int n2 = 0;
            while (n2 < this.modules.size()) {
                if (this.modules.elementAt(n2) == ProcessEngine.this.masterSink) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void prError() {
            if (!this.isCustomized()) {
                super.prError();
                return;
            }
            Log.error("  Cannot build a flow graph with the customized options:");
            if (this.formatWanted != null) {
                Log.error("    Unable to transcode format: " + this.getOriginalFormat());
                Log.error("      to: " + this.getFormat());
                if (ProcessEngine.this.outputContentDes != null) {
                    Log.error("      outputting to: " + ProcessEngine.this.outputContentDes);
                }
            }
            if (this.codecChainWanted != null) {
                Log.error("    Unable to add customed codecs: ");
                int n2 = 0;
                while (n2 < this.codecChainWanted.length) {
                    Log.error("      " + this.codecChainWanted[n2]);
                    ++n2;
                }
            }
            if (this.rendererWanted != null) {
                Log.error("    Unable to add customed renderer: " + this.rendererWanted);
            }
            Log.write("\n");
        }

        protected ProgressControl progressControl() {
            return ProcessEngine.this.progressControl;
        }

        public void setCodecChain(Codec[] codecArray) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            if (codecArray.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codecArray.length];
            int n2 = 0;
            while (n2 < codecArray.length) {
                this.codecChainWanted[n2] = codecArray[n2];
                ++n2;
            }
        }

        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format == null || format.matches(this.track.getFormat())) {
                return format;
            }
            this.formatWanted = this.checkSize(format);
            return this.formatWanted;
        }

        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            this.rendererWanted = renderer;
            if (renderer instanceof SlowPlugIn) {
                ((SlowPlugIn)((Object)renderer)).forceToUse();
            }
        }

        Format[] verifyMuxInputs(ContentDescriptor contentDescriptor, Format[] formatArray) {
            if (contentDescriptor == null || contentDescriptor.getEncoding() == "raw") {
                return formatArray;
            }
            Vector vector = PlugInManager.getPlugInList(null, contentDescriptor, 5);
            if (vector == null || vector.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] multiplexerArray = new Multiplexer[vector.size()];
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                block13: {
                    Multiplexer multiplexer = (Multiplexer)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(n3), 5);
                    if (multiplexer != null) {
                        try {
                            multiplexer.setContentDescriptor(ProcessEngine.this.outputContentDes);
                        }
                        catch (Exception exception) {
                            break block13;
                        }
                        if (multiplexer.setNumTracks(1) >= 1) {
                            multiplexerArray[n2++] = multiplexer;
                        }
                    }
                }
                ++n3;
            }
            Format[] formatArray2 = new Format[formatArray.length];
            int n4 = 0;
            int n5 = 0;
            while (n5 < formatArray.length) {
                Format format;
                if (n2 == 1) {
                    format = multiplexerArray[0].setInputFormat(formatArray[n5], 0);
                    if (format != null) {
                        formatArray2[n4++] = format;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        format = multiplexerArray[n6].setInputFormat(formatArray[n5], 0);
                        if (format != null) {
                            formatArray2[n4++] = format;
                            break;
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            Format[] formatArray3 = new Format[n4];
            System.arraycopy(formatArray2, 0, formatArray3, 0, n4);
            return formatArray3;
        }
    }

    class ProcGraphBuilder
    extends SimpleGraphBuilder {
        protected ProcessEngine engine;
        protected Format targetFormat;
        protected int trackID = 0;
        protected int numTracks = 1;
        protected int nodesVisited = 0;
        Codec[] codecs = null;
        Renderer rend = null;
        Format format = null;

        ProcGraphBuilder(ProcessEngine processEngine2) {
            this.engine = processEngine2;
        }

        boolean buildCustomGraph(ProcTControl procTControl) {
            Object object;
            Object object2;
            this.codecs = procTControl.codecChainWanted;
            this.rend = procTControl.rendererWanted;
            this.format = procTControl.formatWanted;
            if (this.format instanceof VideoFormat && procTControl.getOriginalFormat() instanceof VideoFormat) {
                object2 = ((VideoFormat)procTControl.getOriginalFormat()).getSize();
                object = ((VideoFormat)this.format).getSize();
                if (object2 != null && object != null && !((Dimension)object2).equals(object)) {
                    RGBScaler rGBScaler = new RGBScaler((Dimension)object);
                    if (this.codecs == null || this.codecs.length == 0) {
                        this.codecs = new Codec[1];
                        this.codecs[0] = rGBScaler;
                    } else {
                        int n2;
                        this.codecs = new Codec[procTControl.codecChainWanted.length + 1];
                        if (!PlaybackEngine.isRawVideo(this.format)) {
                            this.codecs[0] = rGBScaler;
                            n2 = 1;
                        } else {
                            this.codecs[procTControl.codecChainWanted.length] = rGBScaler;
                            n2 = 0;
                        }
                        int n3 = 0;
                        while (n3 < procTControl.codecChainWanted.length) {
                            this.codecs[n2++] = procTControl.codecChainWanted[n3];
                            ++n3;
                        }
                    }
                }
            }
            return (object2 = this.buildCustomGraph(procTControl.getOriginalFormat())) != null && (object = this.buildTrackFromGraph(procTControl, (GraphNode)object2)) == null;
        }

        GraphNode buildCustomGraph(Format format) {
            Vector<GraphNode> vector = new Vector<GraphNode>();
            Object var4_3 = null;
            GraphNode graphNode = new GraphNode(null, null, format, null, 0);
            vector.addElement(graphNode);
            Log.comment("Custom options specified.");
            this.indent = 1;
            Log.setIndent(this.indent);
            if (this.codecs != null) {
                this.resetTargets();
                int n2 = 0;
                while (n2 < this.codecs.length) {
                    if (this.codecs[n2] != null) {
                        Log.comment("A custom codec is specified: " + this.codecs[n2]);
                        this.setTargetPlugin(this.codecs[n2], 2);
                        graphNode = this.buildGraph(vector);
                        if (graphNode == null) {
                            Log.error("The input format is not compatible with the given codec plugin: " + this.codecs[n2]);
                            this.indent = 0;
                            Log.setIndent(this.indent);
                            return null;
                        }
                        graphNode.level = 0;
                        vector = new Vector();
                        vector.addElement(graphNode);
                    }
                    ++n2;
                }
            }
            if (ProcessEngine.this.outputContentDes != null) {
                this.resetTargets();
                if (this.format != null) {
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                }
                if (!this.setDefaultTargetMux()) {
                    return null;
                }
                graphNode = this.buildGraph(vector);
                if (graphNode == null) {
                    Log.error("Failed to build a graph for the given custom options.");
                    this.indent = 0;
                    Log.setIndent(this.indent);
                    return null;
                }
            } else {
                if (this.format != null) {
                    this.resetTargets();
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        Log.error("The input format cannot be transcoded to the specified target format.");
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    graphNode.level = 0;
                    vector = new Vector();
                    vector.addElement(graphNode);
                    this.targetFormat = null;
                }
                if (this.rend != null) {
                    Log.comment("A custom renderer is specified: " + this.rend);
                    this.setTargetPlugin(this.rend, 4);
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        if (this.format != null) {
                            Log.error("The customed transocoded format is not compatible with the given renderer plugin: " + this.rend);
                        } else {
                            Log.error("The input format is not compatible with the given renderer plugin: " + this.rend);
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                } else {
                    if (!this.setDefaultTargetRenderer(this.format == null ? format : this.format)) {
                        return null;
                    }
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        if (this.format != null) {
                            Log.error("Failed to find a renderer that supports the customed transcoded format.");
                        } else {
                            Log.error("Failed to build a graph to render the input format with the given custom options.");
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                }
            }
            this.indent = 0;
            Log.setIndent(this.indent);
            return graphNode;
        }

        boolean buildGraph(BasicTrackControl basicTrackControl, int n2, int n3) {
            this.trackID = n2;
            this.numTracks = n3;
            if (basicTrackControl.isCustomized()) {
                Log.comment("Input: " + basicTrackControl.getOriginalFormat());
                return this.buildCustomGraph((ProcTControl)basicTrackControl);
            }
            return super.buildGraph(basicTrackControl);
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
            return this.engine.buildTrackFromGraph((ProcTControl)basicTrackControl, graphNode);
        }

        void doGetSupportedOutputFormats(Vector vector, Vector vector2) {
            Format format;
            Format[] formatArray;
            GraphNode graphNode = (GraphNode)vector.firstElement();
            vector.removeElementAt(0);
            if (!(graphNode.input != null || graphNode.plugin != null && graphNode.plugin instanceof Codec)) {
                Log.error("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (graphNode.plugin != null && SimpleGraphBuilder.verifyInput(graphNode.plugin, graphNode.input) == null) {
                return;
            }
            if (graphNode.plugin != null) {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    return;
                }
                int n2 = 0;
                while (n2 < formatArray.length) {
                    int n3 = vector2.size();
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < n3) {
                        Format format2 = (Format)vector2.elementAt(n4);
                        if (format2 == formatArray[n2] || format2.equals(formatArray[n2])) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        vector2.addElement(formatArray[n2]);
                    }
                    ++n2;
                }
                format = graphNode.input;
            } else {
                formatArray = new Format[]{graphNode.input};
                format = null;
            }
            if (graphNode.level >= this.STAGES) {
                return;
            }
            int n5 = 0;
            while (n5 < formatArray.length) {
                Vector vector3;
                if (!(format != null && format.equals(formatArray[n5]) || graphNode.plugin != null && SimpleGraphBuilder.verifyOutput(graphNode.plugin, formatArray[n5]) == null || (vector3 = PlugInManager.getPlugInList(formatArray[n5], null, 2)) == null || vector3.size() == 0)) {
                    int n6 = 0;
                    while (n6 < vector3.size()) {
                        Format[] formatArray2;
                        Format format3;
                        GraphNode graphNode2 = SimpleGraphBuilder.getPlugInNode((String)vector3.elementAt(n6), 2, this.plugIns);
                        if (graphNode2 != null && !graphNode2.checkAttempted(formatArray[n5]) && (format3 = SimpleGraphBuilder.matches(formatArray[n5], formatArray2 = graphNode2.getSupportedInputs(), null, graphNode2.plugin)) != null) {
                            GraphNode graphNode3 = new GraphNode(graphNode2, format3, graphNode, graphNode.level + 1);
                            vector.addElement(graphNode3);
                            ++this.nodesVisited;
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
        }

        GraphNode findTarget(GraphNode graphNode) {
            Object object;
            Format[] formatArray;
            if (graphNode.plugin == null) {
                formatArray = new Format[]{graphNode.input};
            } else if (graphNode.output != null) {
                formatArray = new Format[]{graphNode.output};
            } else {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    return null;
                }
            }
            if (this.targetFormat != null) {
                object = null;
                object = SimpleGraphBuilder.matches(formatArray, this.targetFormat, graphNode.plugin, null);
                if (object == null) {
                    return null;
                }
                if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify((Codec)graphNode.plugin, graphNode.input, (Format)object)) {
                    return null;
                }
                if (this.targetPlugins == null && ProcessEngine.this.targetMuxes == null) {
                    graphNode.output = object;
                    return graphNode;
                }
                formatArray = new Format[]{object};
            }
            if (this.targetPlugins != null) {
                object = this.verifyTargetPlugins(graphNode, formatArray);
                if (object != null) {
                    return object;
                }
                return null;
            }
            if (ProcessEngine.this.targetMuxes != null && (object = this.verifyTargetMuxes(graphNode, formatArray)) != null) {
                return object;
            }
            return null;
        }

        public Format[] getSupportedOutputFormats(Format format) {
            long l2 = System.currentTimeMillis();
            Vector<Format> vector = new Vector<Format>();
            Vector<GraphNode> vector2 = new Vector<GraphNode>();
            GraphNode graphNode = new GraphNode(null, null, format, null, 0);
            vector2.addElement(graphNode);
            vector.addElement(format);
            ++this.nodesVisited;
            while (!vector2.isEmpty()) {
                this.doGetSupportedOutputFormats(vector2, vector);
            }
            Format[] formatArray = new Format[vector.size()];
            int n2 = 0;
            int n3 = formatArray.length - 1;
            AudioFormat audioFormat = new AudioFormat("mpegaudio/rtp");
            boolean bl = new AudioFormat("mpegaudio").matches(format) || new AudioFormat("mpeglayer3").matches(format) || new VideoFormat("mpeg").matches(format);
            int n4 = 0;
            while (n4 < formatArray.length) {
                Object e2 = vector.elementAt(n4);
                if (!bl && ((Format)audioFormat).matches((Format)e2)) {
                    formatArray[n3--] = (Format)e2;
                } else {
                    formatArray[n2++] = (Format)e2;
                }
                ++n4;
            }
            Log.comment("Getting the supported output formats for:");
            Log.comment("  " + format);
            Log.comment("  # of nodes visited: " + this.nodesVisited);
            Log.comment("  # of formats supported: " + formatArray.length + "\n");
            PlaybackEngine.profile("getSupportedOutputFormats", l2);
            return formatArray;
        }

        public void reset() {
            super.reset();
            this.resetTargets();
        }

        void resetTargets() {
            this.targetFormat = null;
            this.targetPlugins = null;
        }

        boolean setDefaultTargetMux() {
            if (ProcessEngine.this.targetMuxes != null) {
                return true;
            }
            Log.comment("An output content type is specified: " + ProcessEngine.this.outputContentDes);
            ProcessEngine.this.targetMuxNames = PlugInManager.getPlugInList(null, ProcessEngine.this.outputContentDes, 5);
            if (ProcessEngine.this.targetMuxNames == null || ProcessEngine.this.targetMuxNames.size() == 0) {
                Log.error("No multiplexer is found for that content type: " + ProcessEngine.this.outputContentDes);
                return false;
            }
            ProcessEngine.this.targetMuxes = new GraphNode[ProcessEngine.this.targetMuxNames.size()];
            ProcessEngine.this.targetMux = null;
            ProcessEngine.this.targetMuxFormats = new Format[this.numTracks];
            this.targetPluginNames = null;
            this.targetPlugins = null;
            return true;
        }

        boolean setDefaultTargetRenderer(Format format) {
            if (!super.setDefaultTargetRenderer(format)) {
                return false;
            }
            ProcessEngine.this.targetMuxes = null;
            return true;
        }

        boolean setDefaultTargets(Format format) {
            if (ProcessEngine.this.outputContentDes != null) {
                return this.setDefaultTargetMux();
            }
            return this.setDefaultTargetRenderer(format);
        }

        void setTargetPlugin(PlugIn plugIn, int n2) {
            this.targetPlugins = new GraphNode[1];
            this.targetPlugins[0] = new GraphNode(plugIn, null, null, 0);
            this.targetPlugins[0].custom = true;
            this.targetPlugins[0].type = n2;
        }

        /*
         * Unable to fully structure code
         */
        GraphNode verifyTargetMuxes(GraphNode var1_1, Format[] var2_2) {
            var6_3 = 0;
            while (var6_3 < ProcessEngine.this.targetMuxes.length) {
                block13: {
                    var4_5 = ProcessEngine.this.targetMuxes[var6_3];
                    if (var4_5 != null) ** GOTO lbl19
                    var7_7 = (String)ProcessEngine.this.targetMuxNames.elementAt(var6_3);
                    if (var7_7 == null) break block13;
                    var4_5 = SimpleGraphBuilder.getPlugInNode(var7_7, 5, this.plugIns);
                    if (var4_5 == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, var6_3);
                    } else {
                        var3_4 = (Multiplexer)var4_5.plugin;
                        if (var3_4.setContentDescriptor(ProcessEngine.this.outputContentDes) == null) {
                            ProcessEngine.this.targetMuxNames.setElementAt(null, var6_3);
                        } else if (var3_4.setNumTracks(this.numTracks) != this.numTracks) {
                            ProcessEngine.this.targetMuxNames.setElementAt(null, var6_3);
                        } else {
                            ProcessEngine.this.targetMuxes[var6_3] = var4_5;
lbl19:
                            // 2 sources

                            if (ProcessEngine.this.targetMux == null || var4_5 == ProcessEngine.this.targetMux) {
                                var7_8 = 0;
                                while (var7_8 < var2_2.length) {
                                    var5_6 = ((Multiplexer)var4_5.plugin).setInputFormat(var2_2[var7_8], this.trackID);
                                    if (var5_6 != null && (SimpleGraphBuilder.inspector == null || var1_1.plugin == null || SimpleGraphBuilder.inspector.verify((Codec)var1_1.plugin, var1_1.input, var5_6))) {
                                        ProcessEngine.this.targetMux = var4_5;
                                        ProcessEngine.this.targetMuxFormats[this.trackID] = var5_6;
                                        var1_1.output = var5_6;
                                        return var1_1;
                                    }
                                    ++var7_8;
                                }
                            }
                        }
                    }
                }
                ++var6_3;
            }
            return null;
        }
    }
}

