/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import javax.media.Clock;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Time;
import javax.media.TimeBase;

public abstract class BasicSinkModule
extends BasicModule {
    private Clock clock;
    protected boolean prerolling = false;
    protected float rate = 1.0f;
    protected long stopTime = -1L;

    public void doSetMediaTime(Time time) {
        if (this.clock != null) {
            this.clock.setMediaTime(time);
        }
    }

    public float doSetRate(float f2) {
        this.rate = this.clock != null ? this.clock.setRate(f2) : f2;
        return this.rate;
    }

    public void doStart() {
        super.doStart();
        if (this.clock != null) {
            this.clock.syncStart(this.clock.getTimeBase().getTime());
        }
    }

    public void doStop() {
        if (this.clock != null) {
            this.clock.stop();
        }
    }

    public void doneReset() {
    }

    public Clock getClock() {
        return this.clock;
    }

    public long getMediaNanoseconds() {
        if (this.clock != null) {
            return this.clock.getMediaNanoseconds();
        }
        return this.controller.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        if (this.clock != null) {
            return this.clock.getMediaTime();
        }
        return this.controller.getMediaTime();
    }

    public TimeBase getTimeBase() {
        if (this.clock != null) {
            return this.clock.getTimeBase();
        }
        return this.controller.getTimeBase();
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setPreroll(long l2, long l3) {
        if (l3 < l2) {
            this.prerolling = true;
        }
    }

    public void setStopTime(Time time) {
        this.stopTime = time == Clock.RESET ? -1L : time.getNanoseconds();
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.clock != null) {
            this.clock.setTimeBase(timeBase);
        }
    }

    public void triggerReset() {
    }
}

