/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicController;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.PlayThread;
import com.sun.media.SeekFailedEvent;
import com.sun.media.StatsThread;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.controls.SliderRegionControlAdapter;
import com.sun.media.ui.DefaultControlPanel;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DownloadProgressListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.ExtendedCachingControl;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;

public abstract class BasicPlayer
extends BasicController
implements Player,
ControllerListener,
DownloadProgressListener {
    public static String VERSION = JMFI18N.getResource("mediaplayer.version");
    protected DataSource source = null;
    protected Vector controllerList = new Vector();
    private Vector optionalControllerList = new Vector();
    private Vector removedControllerList = new Vector();
    private Vector currentControllerList = new Vector();
    private Vector potentialEventsList = null;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector configureEventList = new Vector();
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private ControllerEvent CachingControlEvent = null;
    private Controller restartFrom = null;
    private Vector eomEventsReceivedFrom = new Vector();
    private Vector stopAtTimeReceivedFrom = new Vector();
    private PlayThread playThread = null;
    private StatsThread statsThread = null;
    private Time duration = Duration.DURATION_UNKNOWN;
    private Time startTime;
    private Time mediaTimeAtStart;
    private boolean aboutToRestart = false;
    private boolean closing = false;
    private boolean prefetchFailed = false;
    protected boolean framePositioning = true;
    protected Control[] controls = null;
    protected Component controlComp = null;
    public SliderRegionControl regionControl = null;
    protected CachingControl cachingControl = null;
    protected ExtendedCachingControl extendedCachingControl = null;
    protected BufferControl bufferControl = null;
    private Object startSync = new Object();
    private Object mediaTimeSync = new Object();
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    long lastTime = 0L;
    static final int LOCAL_STOP = 0;
    static final int STOP_BY_REQUEST = 1;
    static final int RESTARTING = 2;
    static /* synthetic */ Class class$com$sun$media$PlayThread;
    static /* synthetic */ Class class$com$sun$media$BasicPlayer;
    static /* synthetic */ Class class$com$sun$media$StatsThread;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public BasicPlayer() {
        this.configureEventList.addElement("javax.media.ConfigureCompleteEvent");
        this.configureEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
        this.stopThreadEnabled = false;
    }

    protected final void abortPrefetch() {
        if (this.controllerList != null) {
            int n2 = this.controllerList.size();
            while (--n2 >= 0) {
                Controller controller = (Controller)this.controllerList.elementAt(n2);
                controller.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected final void abortRealize() {
        if (this.controllerList != null) {
            int n2 = this.controllerList.size();
            while (--n2 >= 0) {
                Controller controller = (Controller)this.controllerList.elementAt(n2);
                controller.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    public synchronized void addController(Controller controller) throws IncompatibleTimeBaseException {
        int n2 = this.getState();
        if (n2 == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (n2 == 100 || n2 == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        if (controller == null || controller == this) {
            return;
        }
        int n3 = controller.getState();
        if (n3 == 100 || n3 == 200) {
            this.throwError(new NotRealizedError("An Unrealized Controller cannot be added to a Player"));
        }
        if (this.controllerList.contains(controller)) {
            return;
        }
        if (n2 == 500 && (n3 == 300 || n3 == 400)) {
            this.deallocate();
        }
        this.manageController(controller);
        controller.setTimeBase(this.getTimeBase());
        controller.setMediaTime(this.getMediaTime());
        controller.setStopTime(this.getStopTime());
        if (controller.setRate(this.getRate()) != this.getRate()) {
            this.setRate(1.0f);
        }
    }

    protected abstract boolean audioEnabled();

    float checkRateConfig(RateConfigureable rateConfigureable, float f2) {
        RateConfiguration[] rateConfigurationArray = rateConfigureable.getRateConfigurations();
        if (rateConfigurationArray == null) {
            return 1.0f;
        }
        float f3 = 1.0f;
        int n2 = 0;
        while (n2 < rateConfigurationArray.length) {
            RateRange rateRange = rateConfigurationArray[n2].getRate();
            if (rateRange != null && rateRange.inRange(f2)) {
                rateRange.setCurrentRate(f2);
                f3 = f2;
                RateConfiguration rateConfiguration = rateConfigureable.setRateConfiguration(rateConfigurationArray[n2]);
                if (rateConfiguration == null || (rateRange = rateConfiguration.getRate()) == null) break;
                f3 = rateRange.getCurrentRate();
                break;
            }
            ++n2;
        }
        return f3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void completeConfigure() {
        super.completeConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void completePrefetch() {
        super.completePrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void completeRealize() {
        this.state = 300;
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            Log.error(incompatibleTimeBaseException);
        }
        super.completeRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void controllerSetStopTime(Time time) {
        super.setStopTime(time);
    }

    protected void controllerStopAtTime() {
        super.stopAtTime();
    }

    public final void controllerUpdate(ControllerEvent controllerEvent) {
        this.processEvent(controllerEvent);
    }

    protected boolean deviceBusy(BasicController basicController) {
        return true;
    }

    protected void doClose() {
        Controller controller = this;
        synchronized (controller) {
            this.closing = true;
            this.notifyAll();
        }
        if (this.getState() == 600) {
            this.stop(0);
        }
        if (this.controllerList != null) {
            while (!this.controllerList.isEmpty()) {
                controller = (Controller)this.controllerList.firstElement();
                controller.close();
                this.controllerList.removeElement(controller);
            }
        }
        if (this.controlComp != null) {
            ((DefaultControlPanel)this.controlComp).dispose();
        }
        this.controlComp = null;
        if (this.statsThread != null) {
            this.statsThread.kill();
        }
        this.sendEvent(new ControllerClosedEvent(this));
    }

    protected synchronized boolean doConfigure() {
        Controller controller;
        this.potentialEventsList = this.configureEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int n2 = this.controllerList.size();
        while (--n2 >= 0) {
            controller = (Controller)this.controllerList.elementAt(n2);
            if (controller.getState() != 100 || !(controller instanceof Processor) && !(controller instanceof BasicController)) continue;
            this.currentControllerList.addElement(controller);
        }
        n2 = this.currentControllerList.size();
        while (--n2 >= 0) {
            controller = (Controller)this.currentControllerList.elementAt(n2);
            if (controller instanceof Processor) {
                ((Processor)controller).configure();
                continue;
            }
            if (!(controller instanceof BasicController)) continue;
            ((BasicController)controller).configure();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.currentControllerList.removeAllElements();
        }
        n2 = this.controllerList.size();
        while (--n2 >= 0) {
            controller = (Controller)this.controllerList.elementAt(n2);
            if (!(controller instanceof Processor) && !(controller instanceof BasicController) || controller.getState() >= 180) continue;
            Log.error("Error: Unable to configure " + controller);
            this.source.disconnect();
            return false;
        }
        return true;
    }

    protected void doFailedConfigure() {
        super.doFailedConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    protected void doFailedPrefetch() {
        super.doFailedPrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedRealize() {
        super.doFailedRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    protected boolean doPrefetch() {
        Controller controller;
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        Vector vector = this.controllerList;
        if (vector == null) {
            return false;
        }
        int n2 = vector.size();
        while (--n2 >= 0) {
            controller = (Controller)vector.elementAt(n2);
            if (controller.getState() != 300) continue;
            this.currentControllerList.addElement(controller);
            controller.prefetch();
        }
        if (!this.currentControllerList.isEmpty()) {
            controller = this;
            synchronized (controller) {
                try {
                    while (!this.closing && !this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                this.currentControllerList.removeAllElements();
            }
        }
        n2 = vector.size();
        while (--n2 >= 0) {
            controller = (Controller)vector.elementAt(n2);
            if (controller.getState() >= 500) continue;
            Log.error("Error: Unable to prefetch " + controller + "\n");
            if (this.optionalControllerList.contains(controller)) {
                this.removedControllerList.addElement(controller);
                continue;
            }
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.prefetchFailed = true;
                this.notifyAll();
            }
            return false;
        }
        if (this.removedControllerList != null) {
            n2 = this.removedControllerList.size();
            while (--n2 >= 0) {
                controller = this.removedControllerList.elementAt(n2);
                this.controllerList.removeElement(controller);
                ((BasicController)controller).close();
                if (this.deviceBusy((BasicController)controller)) continue;
                BasicPlayer basicPlayer = this;
                synchronized (basicPlayer) {
                    this.prefetchFailed = true;
                    this.notifyAll();
                }
                return false;
            }
            this.removedControllerList.removeAllElements();
        }
        return true;
    }

    protected synchronized boolean doRealize() {
        Object object;
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int n2 = this.controllerList.size();
        while (--n2 >= 0) {
            object = (Controller)this.controllerList.elementAt(n2);
            if (object.getState() != 100 && object.getState() != 180) continue;
            this.currentControllerList.addElement(object);
        }
        n2 = this.currentControllerList.size();
        while (--n2 >= 0) {
            object = (Controller)this.currentControllerList.elementAt(n2);
            object.realize();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.currentControllerList.removeAllElements();
        }
        n2 = this.controllerList.size();
        while (--n2 >= 0) {
            object = (Controller)this.controllerList.elementAt(n2);
            if (object.getState() >= 300) continue;
            Log.error("Error: Unable to realize " + object);
            this.source.disconnect();
            return false;
        }
        this.updateDuration();
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception exception) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateWorkThreadAction.cons;
                this.statsThread = (StatsThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$StatsThread != null ? class$com$sun$media$StatsThread : (class$com$sun$media$StatsThread = BasicPlayer.class$("com.sun.media.StatsThread")), class$com$sun$media$BasicPlayer != null ? class$com$sun$media$BasicPlayer : (class$com$sun$media$BasicPlayer = BasicPlayer.class$("com.sun.media.BasicPlayer")), this));
                this.statsThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.statsThread = new StatsThread(this);
            this.statsThread.start();
        }
        return true;
    }

    protected void doSetMediaTime(Time time) {
    }

    protected float doSetRate(float f2) {
        return f2;
    }

    private void doSetStopTime(Time time) {
        this.getClock().setStopTime(time);
        Vector vector = this.controllerList;
        int n2 = vector.size();
        while (--n2 >= 0) {
            Controller controller = (Controller)this.controllerList.elementAt(n2);
            controller.setStopTime(time);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void downloadUpdate() {
        int n2;
        if (this.extendedCachingControl == null) {
            return;
        }
        this.sendEvent(new CachingControlEvent(this, this.cachingControl, this.cachingControl.getContentProgress()));
        if (this.regionControl == null) {
            return;
        }
        long l2 = this.cachingControl.getContentLength();
        if (l2 == -1L || l2 <= 0L) {
            n2 = 0;
        } else {
            long l3 = this.extendedCachingControl.getEndOffset();
            n2 = (int)(100.0 * (double)l3 / (double)l2);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 100) {
                n2 = 100;
            }
        }
        this.regionControl.setMinValue(0L);
        this.regionControl.setMaxValue(n2);
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public Component getControlPanelComponent() {
        int n2 = this.getState();
        if (n2 < 300) {
            this.throwError(new NotRealizedError("Cannot get control panel component on an unrealized player"));
        }
        if (this.controlComp == null) {
            this.controlComp = new DefaultControlPanel(this);
        }
        return this.controlComp;
    }

    public final Vector getControllerList() {
        return this.controllerList;
    }

    public Control[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> vector = new Vector<Control>();
        if (this.cachingControl != null) {
            vector.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            vector.addElement(this.bufferControl);
        }
        int n2 = this.controllerList.size();
        int n3 = 0;
        while (n3 < n2) {
            Controller controller = (Controller)this.controllerList.elementAt(n3);
            Control[] controlArray = controller.getControls();
            if (controlArray != null) {
                int n4 = 0;
                while (n4 < controlArray.length) {
                    vector.addElement(controlArray[n4]);
                    ++n4;
                }
            }
            ++n3;
        }
        n2 = vector.size();
        Control[] controlArray = new Control[n2];
        n3 = 0;
        while (n3 < n2) {
            controlArray[n3] = (Control)vector.elementAt(n3);
            ++n3;
        }
        if (this.getState() >= 300) {
            this.controls = controlArray;
        }
        return controlArray;
    }

    public Time getDuration() {
        long l2 = this.getMediaNanoseconds();
        if (l2 > this.lastTime) {
            this.lastTime = l2;
            this.updateDuration();
        }
        return this.duration;
    }

    public GainControl getGainControl() {
        int n2 = this.getState();
        if (n2 >= 300) {
            return (GainControl)this.getControl("javax.media.GainControl");
        }
        this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        return null;
    }

    protected abstract TimeBase getMasterTimeBase();

    public MediaLocator getMediaLocator() {
        if (this.source != null) {
            return this.source.getLocator();
        }
        return null;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    protected DataSource getSource() {
        return this.source;
    }

    public Time getStartLatency() {
        super.getStartLatency();
        long l2 = 0L;
        int n2 = 0;
        while (n2 < this.controllerList.size()) {
            Controller controller = (Controller)this.controllerList.elementAt(n2);
            Time time = controller.getStartLatency();
            if (time != Controller.LATENCY_UNKNOWN && time.getNanoseconds() > l2) {
                l2 = time.getNanoseconds();
            }
            ++n2;
        }
        if (l2 == 0L) {
            return Controller.LATENCY_UNKNOWN;
        }
        return new Time(l2);
    }

    public Component getVisualComponent() {
        int n2 = this.getState();
        if (n2 < 300) {
            this.throwError(new NotRealizedError("Cannot get visual component on an unrealized player"));
        }
        return null;
    }

    public boolean isAboutToRestart() {
        return this.aboutToRestart;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public boolean isFramePositionable() {
        return this.framePositioning;
    }

    protected final void manageController(Controller controller) {
        this.manageController(controller, false);
    }

    protected final void manageController(Controller controller, boolean bl) {
        if (controller != null && !this.controllerList.contains(controller)) {
            this.controllerList.addElement(controller);
            if (bl) {
                this.optionalControllerList.addElement(controller);
            }
            controller.addControllerListener(this);
        }
        this.updateDuration();
    }

    private void notifyIfAllEventsArrived(Vector vector, Vector vector2) {
        if (vector2 != null && vector2.size() == this.currentControllerList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.notifyAll();
            }
        }
    }

    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        this.prefetchFailed = false;
        int n2 = this.getState();
        if (n2 == 100 || n2 == 180 || n2 == 300) {
            this.prefetch();
        }
        while (!(this.closing || this.prefetchFailed || this.getState() != 140 && this.getState() != 200 && this.getState() != 300 && this.getState() != 400)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getState() != 600 && this.getTargetState() == 600 && this.getState() == 500) {
            this.syncStart(this.getTimeBase().getTime());
        }
    }

    protected final void processEndOfMedia() {
        super.stop();
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected void processEvent(ControllerEvent controllerEvent) {
        Controller controller;
        int n2;
        int n3;
        Controller controller2 = controllerEvent.getSourceController();
        if (controllerEvent instanceof AudioDeviceUnavailableEvent) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            return;
        }
        if (controllerEvent instanceof ControllerClosedEvent && !this.closing && this.controllerList.contains(controller2) && !(controllerEvent instanceof ResourceUnavailableEvent)) {
            this.controllerList.removeElement(controller2);
            if (controllerEvent instanceof ControllerErrorEvent) {
                this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)controllerEvent).getMessage()));
            }
            this.close();
        }
        if (controllerEvent instanceof SizeChangeEvent && this.controllerList.contains(controller2)) {
            this.sendEvent(new SizeChangeEvent(this, ((SizeChangeEvent)controllerEvent).getWidth(), ((SizeChangeEvent)controllerEvent).getHeight(), ((SizeChangeEvent)controllerEvent).getScale()));
            return;
        }
        if (controllerEvent instanceof DurationUpdateEvent && this.controllerList.contains(controller2)) {
            this.updateDuration();
            return;
        }
        if (controllerEvent instanceof RestartingEvent && this.controllerList.contains(controller2)) {
            this.restartFrom = controller2;
            n3 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            n2 = 0;
            while (n2 < n3) {
                controller = (Controller)this.controllerList.elementAt(n2);
                if (controller != controller2) {
                    controller.stop();
                }
                ++n2;
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (controllerEvent instanceof StartEvent && controller2 == this.restartFrom) {
            this.restartFrom = null;
            this.start();
        }
        if (controllerEvent instanceof SeekFailedEvent && this.controllerList.contains(controller2)) {
            n3 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            n2 = 0;
            while (n2 < n3) {
                controller = (Controller)this.controllerList.elementAt(n2);
                if (controller != controller2) {
                    controller.stop();
                }
                ++n2;
            }
            this.sendEvent(new SeekFailedEvent(this, 600, 500, 500, this.getMediaTime()));
        }
        if (controllerEvent instanceof EndOfMediaEvent && this.controllerList.contains(controller2)) {
            if (this.eomEventsReceivedFrom.contains(controller2)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(controller2);
            if (this.eomEventsReceivedFrom.size() == this.controllerList.size()) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
            return;
        }
        if (controllerEvent instanceof StopAtTimeEvent && this.controllerList.contains(controller2) && this.getState() == 600) {
            Vector vector = this.stopAtTimeReceivedFrom;
            synchronized (vector) {
                block25: {
                    boolean bl;
                    if (this.stopAtTimeReceivedFrom.contains(controller2)) {
                        Object var4_8 = null;
                        return;
                    }
                    this.stopAtTimeReceivedFrom.addElement(controller2);
                    boolean bl2 = bl = this.stopAtTimeReceivedFrom.size() == this.controllerList.size();
                    if (!bl) {
                        bl = true;
                        int n4 = 0;
                        while (n4 < this.controllerList.size()) {
                            Controller controller3 = (Controller)this.controllerList.elementAt(n4);
                            if (!this.stopAtTimeReceivedFrom.contains(controller3) && !this.eomEventsReceivedFrom.contains(controller3)) {
                                bl = false;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (!bl) break block25;
                    super.stop();
                    this.doSetStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                }
                Object var4_9 = null;
                return;
            }
        }
        if (controllerEvent instanceof CachingControlEvent && this.controllerList.contains(controller2)) {
            CachingControl cachingControl = ((CachingControlEvent)controllerEvent).getCachingControl();
            this.sendEvent(new CachingControlEvent(this, cachingControl, cachingControl.getContentProgress()));
            return;
        }
        Vector vector = this.potentialEventsList;
        if (this.controllerList != null && this.controllerList.contains(controller2) && vector != null && vector.contains(controllerEvent.getClass().getName())) {
            this.updateReceivedEventsList(controllerEvent);
            this.notifyIfAllEventsArrived(this.controllerList, this.getReceivedEventsList());
        }
    }

    public final synchronized void removeController(Controller controller) {
        block5: {
            int n2 = this.getState();
            if (n2 < 300) {
                this.throwError(new NotRealizedError("Cannot remove controller from a unrealized player"));
            }
            if (n2 == 600) {
                this.throwError(new ClockStartedError("Cannot remove controller from a started player"));
            }
            if (controller == null) {
                return;
            }
            if (!this.controllerList.contains(controller)) break block5;
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
            this.updateDuration();
            try {
                controller.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {}
        }
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    protected void setMediaLength(long l2) {
        this.duration = new Time(l2);
        super.setMediaLength(l2);
    }

    public final void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(BasicController.MediaTimeError));
        }
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                Object var3_3 = null;
                return;
            }
            if (this.getState() == 600) {
                this.aboutToRestart = true;
                this.stop(2);
            }
            if (this.source instanceof Positionable) {
                time = ((Positionable)((Object)this.source)).setPosition(time, 2);
            }
            super.setMediaTime(time);
            int n2 = this.controllerList.size();
            while (--n2 >= 0) {
                ((Controller)this.controllerList.elementAt(n2)).setMediaTime(time);
            }
            this.doSetMediaTime(time);
            if (this.aboutToRestart) {
                this.syncStart(this.getTimeBase().getTime());
                this.aboutToRestart = false;
            }
        }
    }

    public float setRate(float f2) {
        float f3;
        float f4;
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        if (this.source instanceof RateConfigureable) {
            f2 = this.checkRateConfig((RateConfigureable)((Object)this.source), f2);
        }
        if ((f4 = this.getRate()) == f2) {
            return f2;
        }
        if (this.getState() == 600) {
            this.aboutToRestart = true;
            this.stop(2);
        }
        if (!this.trySetRate(f2)) {
            if (!this.trySetRate(f4)) {
                this.trySetRate(1.0f);
                f3 = 1.0f;
            } else {
                f3 = f4;
            }
        } else {
            f3 = f2;
        }
        super.setRate(f3);
        if (this.aboutToRestart) {
            this.syncStart(this.getTimeBase().getTime());
            this.aboutToRestart = false;
        }
        return f3;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        this.source = dataSource;
        try {
            this.cachingControl = (CachingControl)dataSource.getControl("javax.media.CachingControl");
            if (this.cachingControl != null && this.cachingControl instanceof ExtendedCachingControl) {
                this.extendedCachingControl = (ExtendedCachingControl)this.cachingControl;
                if (this.extendedCachingControl != null) {
                    this.regionControl = new SliderRegionControlAdapter();
                    this.extendedCachingControl.addDownloadProgressListener(this, 100);
                }
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public void setStopTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getClock().getStopTime() == null || this.getClock().getStopTime().getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        this.doSetStopTime(time);
    }

    /*
     * Unable to fully structure code
     */
    public void setTimeBase(TimeBase var1_1) throws IncompatibleTimeBaseException {
        block6: {
            var2_2 = this.getMasterTimeBase();
            if (var1_1 == null) {
                var1_1 = var2_2;
            }
            var3_3 = null;
            if (this.controllerList != null) {
                try {
                    var4_4 = this.controllerList.size();
                    while (--var4_4 >= 0) {
                        var3_3 = (Controller)this.controllerList.elementAt(var4_4);
                        var3_3.setTimeBase(var1_1);
                    }
                    break block6;
                }
                catch (IncompatibleTimeBaseException var5_6) {
                    var4_5 = this.controllerList.size();
                    ** while (--var4_5 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    var6_7 = (Controller)this.controllerList.elementAt(var4_5);
                    if (var6_7 == var3_3) break;
                    var6_7.setTimeBase(var2_2);
                    continue;
                }
lbl20:
                // 2 sources

                Log.dumpStack(var5_6);
                throw var5_6;
            }
        }
        super.setTimeBase(var1_1);
    }

    protected void slaveToMasterTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        this.setTimeBase(timeBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.restartFrom != null) {
                return;
            }
            if (this.getState() != 600) {
                Object object2;
                block15: {
                    if (this.playThread != null) {
                        if (this.playThread.isAlive()) return;
                    }
                    this.setTargetState(600);
                    if (jmfSecurity != null) {
                        object2 = null;
                        try {
                            if (jmfSecurity.getName().startsWith("jmf-security")) {
                                object2 = "thread";
                                jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                                this.m[0].invoke((Object)this.cl[0], this.args[0]);
                                object2 = "thread group";
                                jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                                this.m[0].invoke((Object)this.cl[0], this.args[0]);
                                break block15;
                            }
                            if (jmfSecurity.getName().startsWith("internet")) {
                                PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                                PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                            }
                        }
                        catch (Throwable throwable) {
                            securityPrivelege = false;
                        }
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object2 = CreateWorkThreadAction.cons;
                        this.playThread = (PlayThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object2).newInstance(class$com$sun$media$PlayThread != null ? class$com$sun$media$PlayThread : (class$com$sun$media$PlayThread = BasicPlayer.class$("com.sun.media.PlayThread")), class$com$sun$media$BasicPlayer != null ? class$com$sun$media$BasicPlayer : (class$com$sun$media$BasicPlayer = BasicPlayer.class$("com.sun.media.BasicPlayer")), this));
                        this.playThread.start();
                    }
                    catch (Exception exception) {}
                } else {
                    this.playThread = new PlayThread(this);
                    this.playThread.start();
                }
                return;
            }
            this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
            return;
        }
    }

    public final void stop() {
        this.stop(1);
    }

    private void stop(int n2) {
        int n3 = this.getState();
        switch (n3) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(n3);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
                break;
            }
        }
        if (this.getState() != 600) {
            switch (n2) {
                case 1: {
                    this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
                case 2: {
                    this.sendEvent(new RestartingEvent(this, this.getState(), this.getState(), 600, this.getMediaTime()));
                    break;
                }
                default: {
                    this.sendEvent(new StopEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
            }
        } else if (this.getState() == 600) {
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentControllerList.removeAllElements();
                int n4 = this.controllerList.size();
                while (--n4 >= 0) {
                    Controller controller = (Controller)this.controllerList.elementAt(n4);
                    this.currentControllerList.addElement(controller);
                    controller.stop();
                }
                if (this.currentControllerList == null) {
                    Object var4_6 = null;
                    return;
                }
                if (!this.currentControllerList.isEmpty()) {
                    try {
                        while (!this.closing && !this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    this.currentControllerList.removeAllElements();
                }
                super.stop();
                switch (n2) {
                    case 1: {
                        this.sendEvent(new StopByRequestEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                        break;
                    }
                    case 2: {
                        this.sendEvent(new RestartingEvent(this, 600, this.getState(), 600, this.getMediaTime()));
                        break;
                    }
                    default: {
                        this.sendEvent(new StopEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                        break;
                    }
                }
            }
        }
    }

    protected void stopAtTime() {
    }

    public final void syncStart(Time time) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                Object var3_3 = null;
                return;
            }
            int n2 = this.getState();
            if (n2 == 600) {
                this.throwError(new ClockStartedError("syncStart() cannot be used on an already started player"));
            }
            if (n2 != 500) {
                this.throwError(new NotPrefetchedError("Cannot start player before it has been prefetched"));
            }
            this.eomEventsReceivedFrom.removeAllElements();
            this.stopAtTimeReceivedFrom.removeAllElements();
            this.setTargetState(600);
            int n3 = this.controllerList.size();
            while (--n3 >= 0) {
                if (this.getTargetState() != 600) continue;
                ((Controller)this.controllerList.elementAt(n3)).syncStart(time);
            }
            if (this.getTargetState() == 600) {
                this.startTime = time;
                this.mediaTimeAtStart = this.getMediaTime();
                super.syncStart(time);
            }
        }
    }

    private boolean trySetRate(float f2) {
        int n2 = this.controllerList.size();
        while (--n2 >= 0) {
            Controller controller = (Controller)this.controllerList.elementAt(n2);
            if (controller.setRate(f2) == f2) continue;
            return false;
        }
        return true;
    }

    public final void unmanageController(Controller controller) {
        if (controller != null && this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
        }
    }

    protected synchronized void updateDuration() {
        Time time = this.duration;
        this.duration = Duration.DURATION_UNKNOWN;
        int n2 = 0;
        while (n2 < this.controllerList.size()) {
            Controller controller = (Controller)this.controllerList.elementAt(n2);
            Time time2 = controller.getDuration();
            if (time2.equals(Duration.DURATION_UNKNOWN)) {
                if (!(controller instanceof BasicController)) {
                    this.duration = Duration.DURATION_UNKNOWN;
                    break;
                }
            } else {
                if (time2.equals(Duration.DURATION_UNBOUNDED)) {
                    this.duration = Duration.DURATION_UNBOUNDED;
                    break;
                }
                if (this.duration.equals(Duration.DURATION_UNKNOWN)) {
                    this.duration = time2;
                } else if (this.duration.getNanoseconds() < time2.getNanoseconds()) {
                    this.duration = time2;
                }
            }
            ++n2;
        }
        if (this.duration.getNanoseconds() != time.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    private void updateReceivedEventsList(ControllerEvent controllerEvent) {
        if (this.receivedEventList != null) {
            Controller controller = controllerEvent.getSourceController();
            if (this.receivedEventList.contains(controller)) {
                return;
            }
            this.receivedEventList.addElement(controller);
        }
    }

    public abstract void updateStats();

    protected abstract boolean videoEnabled();
}

