/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicSinkModule;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.PlaybackEngine;
import com.sun.media.util.ElapseTime;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Prefetchable;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;

public class BasicMuxModule
extends BasicSinkModule {
    protected Multiplexer multiplexer;
    protected Format[] inputs;
    protected InputConnector[] ics;
    protected boolean[] prefetchMarkers;
    protected boolean[] endMarkers;
    protected boolean[] resettedMarkers;
    protected boolean[] stopAtTimeMarkers;
    protected boolean[] paused;
    protected boolean[] prerollTrack;
    private Object[] pauseSync;
    protected ElapseTime[] elapseTime;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean closed = false;
    private boolean failed = false;
    private Object prefetchSync = new Object();
    private float frameRate = 30.0f;
    private float lastFramesBehind = -1.0f;
    private int framesPlayed = 0;
    private VideoFormat rtpVideoFormat = null;
    private VideoFormat firstVideoFormat = null;
    public static String ConnectorNamePrefix = "input";
    private long bitsWritten = 0L;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    protected BasicMuxModule(Multiplexer multiplexer, Format[] formatArray) {
        this.multiplexer = multiplexer;
        if (formatArray != null) {
            this.ics = new InputConnector[formatArray.length];
            int n2 = 0;
            while (n2 < formatArray.length) {
                MyInputConnector myInputConnector = new MyInputConnector();
                myInputConnector.setSize(1);
                myInputConnector.setModule(this);
                this.registerInputConnector(String.valueOf(ConnectorNamePrefix) + n2, myInputConnector);
                this.ics[n2] = myInputConnector;
                if (formatArray[n2] instanceof VideoFormat && this.firstVideoFormat == null) {
                    this.firstVideoFormat = (VideoFormat)formatArray[n2];
                    String string = formatArray[n2].getEncoding().toUpperCase();
                    if (string.endsWith("RTP")) {
                        this.rtpVideoFormat = this.firstVideoFormat;
                    }
                }
                ++n2;
            }
            this.inputs = formatArray;
        }
        if (this.multiplexer != null && this.multiplexer instanceof Clock) {
            this.setClock((Clock)((Object)this.multiplexer));
        }
        this.setProtocol(0);
    }

    public void abortPrefetch() {
        this.prefetching = false;
    }

    boolean checkEnd(int n2) {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            this.endMarkers[n2] = true;
            int n3 = 0;
            while (n3 < this.endMarkers.length) {
                if (!this.endMarkers[n3]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n3;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    boolean checkPrefetch(int n2) {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (blArray) {
            this.prefetchMarkers[n2] = true;
            int n3 = 0;
            while (n3 < this.prefetchMarkers.length) {
                if (!this.prefetchMarkers[n3]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n3;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    boolean checkResetted(int n2) {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            this.resettedMarkers[n2] = true;
            int n3 = 0;
            while (n3 < this.resettedMarkers.length) {
                if (!this.resettedMarkers[n3]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n3;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    boolean checkStopAtTime(int n2) {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (blArray) {
            this.stopAtTimeMarkers[n2] = true;
            int n3 = 0;
            while (n3 < this.stopAtTimeMarkers.length) {
                if (!this.stopAtTimeMarkers[n3]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n3;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    public void connectorPushed(InputConnector inputConnector) {
        long l2;
        int n2 = -1;
        if (this.ics[0] == inputConnector) {
            n2 = 0;
        } else if (this.ics[1] == inputConnector) {
            n2 = 1;
        } else {
            int n3 = 2;
            while (n3 < this.ics.length) {
                if (this.ics[n3] == inputConnector) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 == -1) {
                throw new RuntimeException("BasicMuxModule: unmatched input connector!");
            }
        }
        while (true) {
            if (this.paused[n2]) {
                Object object = this.pauseSync[n2];
                synchronized (object) {
                    try {
                        while (this.paused[n2] && !this.closed) {
                            this.pauseSync[n2].wait();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.stopTime <= -1L || this.elapseTime[n2].value < this.stopTime) break;
            this.paused[n2] = true;
            if (!this.checkStopAtTime(n2)) continue;
            if (this.multiplexer instanceof Drainable) {
                ((Drainable)((Object)this.multiplexer)).drain();
            }
            this.doStop();
            if (this.moduleListener == null) continue;
            this.moduleListener.stopAtTime(this);
        }
        Buffer buffer = inputConnector.getValidBuffer();
        int n4 = buffer.getFlags();
        int n5 = 0;
        if (this.resetted) {
            if ((n4 & 0x200) != 0 && this.checkResetted(n2)) {
                this.resetted = false;
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            inputConnector.readReport();
            return;
        }
        if (this.failed || this.closed || buffer.isDiscard()) {
            inputConnector.readReport();
            return;
        }
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, true);
        }
        if ((n4 & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(n4 &= 0xFFFFFBFF);
        }
        boolean bl = false;
        Format format = buffer.getFormat();
        if (format == null) {
            format = inputConnector.getFormat();
            buffer.setFormat(format);
        }
        if (this.elapseTime[n2].update(buffer.getLength(), buffer.getTimeStamp(), format)) {
            int n6;
            if (this.prerollTrack[n2]) {
                l2 = this.getMediaNanoseconds();
                if (this.elapseTime[n2].value > l2) {
                    if (format instanceof AudioFormat && "LINEAR".equals(format.getEncoding())) {
                        n6 = (int)ElapseTime.audioTimeToLen(this.elapseTime[n2].value - l2, (AudioFormat)format);
                        int n7 = buffer.getOffset() + buffer.getLength() - n6;
                        if (n7 >= 0) {
                            buffer.setOffset(n7);
                            buffer.setLength(n6);
                        }
                    }
                    this.prerollTrack[n2] = false;
                    this.elapseTime[n2].setValue(l2);
                } else {
                    bl = true;
                }
            }
            if (this.stopTime > -1L && this.elapseTime[n2].value > this.stopTime && format instanceof AudioFormat) {
                l2 = this.elapseTime[n2].value - this.stopTime;
                n6 = (int)ElapseTime.audioTimeToLen(l2, (AudioFormat)format);
                if (buffer.getLength() > n6) {
                    buffer.setLength(buffer.getLength() - n6);
                }
            }
        }
        if (this.moduleListener != null && format instanceof VideoFormat) {
            l2 = this.getMediaNanoseconds();
            long l3 = l2 / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            float f2 = (float)l3 * this.frameRate / 1000.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (this.lastFramesBehind != f2 && (n4 & 0x20) == 0) {
                this.moduleListener.framesBehind(this, f2, inputConnector);
                this.lastFramesBehind = f2;
            }
        }
        do {
            if (!bl) {
                block55: {
                    try {
                        n5 = this.multiplexer.process(buffer, n2);
                    }
                    catch (Throwable throwable) {
                        Log.dumpStack(throwable);
                        if (this.moduleListener == null) break block55;
                        this.moduleListener.internalErrorOccurred(this);
                    }
                }
                if (n5 == 0 && format == this.firstVideoFormat) {
                    if (format == this.rtpVideoFormat) {
                        if ((n4 & 0x800) > 0) {
                            ++this.framesPlayed;
                        }
                    } else {
                        ++this.framesPlayed;
                    }
                }
            } else {
                n5 = 0;
            }
            if ((n5 & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                inputConnector.readReport();
                return;
            }
            if (!this.prefetching || this.multiplexer instanceof Prefetchable && !((Prefetchable)((Object)this.multiplexer)).isPrefetched()) continue;
            Object object = this.prefetchSync;
            synchronized (object) {
                if (!this.started && this.prefetching && !this.resetted) {
                    this.paused[n2] = true;
                }
                if (this.checkPrefetch(n2)) {
                    this.prefetching = false;
                }
            }
            if (this.prefetching || this.moduleListener == null) continue;
            this.moduleListener.bufferPrefetched(this);
        } while (!this.resetted && n5 == 2);
        this.bitsWritten += (long)buffer.getLength();
        if (buffer.isEOM()) {
            if (!this.resetted) {
                this.paused[n2] = true;
            }
            if (this.checkEnd(n2)) {
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.mediaEnded(this);
                }
            }
        }
        inputConnector.readReport();
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, false);
        }
    }

    public void doClose() {
        this.multiplexer.close();
        this.closed = true;
        int n2 = 0;
        while (n2 < this.pauseSync.length) {
            Object object = this.pauseSync[n2];
            synchronized (object) {
                this.pauseSync[n2].notifyAll();
            }
            ++n2;
        }
    }

    public void doDealloc() {
    }

    public void doFailedPrefetch() {
        this.prefetching = false;
    }

    public boolean doPrefetch() {
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.resetPrefetchMarkers();
        this.prefetching = true;
        this.resume();
        return true;
    }

    public boolean doRealize() {
        if (this.multiplexer == null || this.inputs == null) {
            return false;
        }
        try {
            this.multiplexer.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        this.prefetchMarkers = new boolean[this.ics.length];
        this.endMarkers = new boolean[this.ics.length];
        this.resettedMarkers = new boolean[this.ics.length];
        this.stopAtTimeMarkers = new boolean[this.ics.length];
        this.paused = new boolean[this.ics.length];
        this.prerollTrack = new boolean[this.ics.length];
        this.pauseSync = new Object[this.ics.length];
        this.elapseTime = new ElapseTime[this.ics.length];
        int n2 = 0;
        while (n2 < this.ics.length) {
            this.prerollTrack[n2] = false;
            this.pauseSync[n2] = new Object();
            this.elapseTime[n2] = new ElapseTime();
            ++n2;
        }
        this.pause();
        return true;
    }

    public void doStart() {
        super.doStart();
        this.resetEndMarkers();
        this.resetStopAtTimeMarkers();
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.resume();
        }
    }

    public void doStop() {
        super.doStop();
        this.started = false;
        this.resetPrefetchMarkers();
        this.prefetching = true;
    }

    public long getBitsWritten() {
        return this.bitsWritten;
    }

    public Object getControl(String string) {
        return this.multiplexer.getControl(string);
    }

    public Object[] getControls() {
        return this.multiplexer.getControls();
    }

    public DataSource getDataOutput() {
        return this.multiplexer.getDataOutput();
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public boolean isThreaded() {
        return false;
    }

    void pause() {
        int n2 = 0;
        while (n2 < this.paused.length) {
            this.paused[n2] = true;
            ++n2;
        }
    }

    protected void process() {
    }

    public void reset() {
        super.reset();
        this.resetResettedMarkers();
        this.prefetching = false;
    }

    public void resetBitsWritten() {
        this.bitsWritten = 0L;
    }

    void resetEndMarkers() {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            int n2 = 0;
            while (n2 < this.endMarkers.length) {
                this.endMarkers[n2] = false;
                ++n2;
            }
        }
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    void resetPrefetchMarkers() {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (blArray) {
            int n2 = 0;
            while (n2 < this.prefetchMarkers.length) {
                this.prefetchMarkers[n2] = false;
                ++n2;
            }
        }
    }

    void resetResettedMarkers() {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            int n2 = 0;
            while (n2 < this.resettedMarkers.length) {
                this.resettedMarkers[n2] = false;
                ++n2;
            }
        }
    }

    void resetStopAtTimeMarkers() {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (blArray) {
            int n2 = 0;
            while (n2 < this.stopAtTimeMarkers.length) {
                this.stopAtTimeMarkers[n2] = false;
                ++n2;
            }
        }
    }

    void resume() {
        int n2 = 0;
        while (n2 < this.pauseSync.length) {
            Object object = this.pauseSync[n2];
            synchronized (object) {
                this.paused[n2] = false;
                this.pauseSync[n2].notifyAll();
            }
            ++n2;
        }
    }

    public void setFormat(Connector connector, Format format) {
        float f2;
        if (format instanceof VideoFormat && (f2 = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f2;
        }
    }

    public void setPreroll(long l2, long l3) {
        super.setPreroll(l2, l3);
        int n2 = 0;
        while (n2 < this.elapseTime.length) {
            this.elapseTime[n2].setValue(l3);
            this.prerollTrack[n2] = !(this.inputs[n2] instanceof AudioFormat) || !mpegAudio.matches(this.inputs[n2]);
            ++n2;
        }
    }

    public void triggerReset() {
        this.multiplexer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.resume();
            }
        }
    }

    class MyInputConnector
    extends BasicInputConnector {
        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getFormat();
        }
    }
}

