/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import com.ibm.media.protocol.SourceStreamSlave;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class CloneableSourceStreamAdapter {
    SourceStream master;
    SourceStream adapter = null;
    Vector slaves = new Vector();
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int numTracks = 0;
    protected Format[] trackFormats;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    CloneableSourceStreamAdapter(SourceStream sourceStream) {
        this.master = sourceStream;
        if (sourceStream instanceof PullSourceStream) {
            this.adapter = new PullSourceStreamAdapter();
        }
        if (sourceStream instanceof PullBufferStream) {
            this.adapter = new PullBufferStreamAdapter();
        }
        if (sourceStream instanceof PushSourceStream) {
            this.adapter = new PushSourceStreamAdapter();
        }
        if (sourceStream instanceof PushBufferStream) {
            this.adapter = new PushBufferStreamAdapter();
        }
    }

    static /* synthetic */ boolean access$4() {
        return securityPrivelege;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void copyAndRead(Buffer buffer) throws IOException {
        if (this.master instanceof PullBufferStream) {
            ((PullBufferStream)this.master).read(buffer);
        }
        if (this.master instanceof PushBufferStream) {
            ((PushBufferStream)this.master).read(buffer);
        }
        Enumeration enumeration = this.slaves.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            ((PushBufferStreamSlave)e2).setBuffer((Buffer)buffer.clone());
            Thread.yield();
        }
    }

    int copyAndRead(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.master instanceof PullSourceStream) {
            n4 = ((PullSourceStream)this.master).read(byArray, n2, n3);
        }
        if (this.master instanceof PushSourceStream) {
            n4 = ((PushSourceStream)this.master).read(byArray, n2, n3);
        }
        Enumeration enumeration = this.slaves.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n4);
            ((PushSourceStreamSlave)e2).setBuffer(byArray2);
        }
        return n4;
    }

    SourceStream createSlave() {
        PushStreamSlave pushStreamSlave = null;
        if (this.master instanceof PullSourceStream || this.master instanceof PushSourceStream) {
            pushStreamSlave = new PushSourceStreamSlave();
        }
        if (this.master instanceof PullBufferStream || this.master instanceof PushBufferStream) {
            pushStreamSlave = new PushBufferStreamSlave();
        }
        this.slaves.addElement(pushStreamSlave);
        return pushStreamSlave;
    }

    SourceStream getAdapter() {
        return this.adapter;
    }

    class SourceStreamAdapter
    implements SourceStream {
        SourceStreamAdapter() {
        }

        public boolean endOfStream() {
            return CloneableSourceStreamAdapter.this.master.endOfStream();
        }

        public ContentDescriptor getContentDescriptor() {
            return CloneableSourceStreamAdapter.this.master.getContentDescriptor();
        }

        public long getContentLength() {
            return CloneableSourceStreamAdapter.this.master.getContentLength();
        }

        public Object getControl(String string) {
            return CloneableSourceStreamAdapter.this.master.getControl(string);
        }

        public Object[] getControls() {
            return CloneableSourceStreamAdapter.this.master.getControls();
        }
    }

    abstract class PushStreamSlave
    extends SourceStreamAdapter
    implements SourceStreamSlave,
    Runnable {
        MediaThread notifyingThread;
        boolean connected = false;

        PushStreamSlave() {
        }

        public synchronized void connect() {
            Object object;
            if (this.connected) {
                return;
            }
            this.connected = true;
            if (jmfSecurity != null) {
                object = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object = "thread";
                        jmfSecurity.requestPermission(CloneableSourceStreamAdapter.this.m, CloneableSourceStreamAdapter.this.cl, CloneableSourceStreamAdapter.this.args, 16);
                        CloneableSourceStreamAdapter.this.m[0].invoke((Object)CloneableSourceStreamAdapter.this.cl[0], CloneableSourceStreamAdapter.this.args[0]);
                        object = "thread group";
                        jmfSecurity.requestPermission(CloneableSourceStreamAdapter.this.m, CloneableSourceStreamAdapter.this.cl, CloneableSourceStreamAdapter.this.args, 32);
                        CloneableSourceStreamAdapter.this.m[0].invoke((Object)CloneableSourceStreamAdapter.this.cl[0], CloneableSourceStreamAdapter.this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    object = jdk12CreateThreadRunnableAction.cons;
                    this.notifyingThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$util$MediaThread != null ? class$com$sun$media$util$MediaThread : (class$com$sun$media$util$MediaThread = CloneableSourceStreamAdapter.class$("com.sun.media.util.MediaThread")), this));
                }
                catch (Exception exception) {}
            } else {
                this.notifyingThread = new MediaThread(this);
            }
            if (this.notifyingThread != null) {
                if (CloneableSourceStreamAdapter.this.master instanceof PushBufferStream) {
                    if (((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat() instanceof VideoFormat) {
                        this.notifyingThread.useVideoPriority();
                    } else {
                        this.notifyingThread.useAudioPriority();
                    }
                }
                this.notifyingThread.start();
            }
        }

        public synchronized void disconnect() {
            this.connected = false;
            this.notifyAll();
        }

        public abstract void run();
    }

    class PushSourceStreamSlave
    extends PushStreamSlave
    implements PushSourceStream,
    Runnable {
        SourceTransferHandler handler;
        private byte[] buffer;

        PushSourceStreamSlave() {
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        SourceTransferHandler getTransferHandler() {
            return this.handler;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
            if (var3_3 + var2_2 <= var1_1.length) ** GOTO lbl8
            throw new IOException("buffer is too small");
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait(50L);
                    continue;
                }
                catch (InterruptedException var4_4) {
                    System.out.println("Exception: " + var4_4);
                }
lbl8:
                // 3 sources

                ** while (this.buffer == null && this.connected)
            }
lbl9:
            // 1 sources

            if (!this.connected) {
                throw new IOException("DataSource is not connected");
            }
            var4_5 = var3_3 > this.buffer.length ? this.buffer.length : var3_3;
            System.arraycopy(this.buffer, 0, var1_1, var2_2, var4_5);
            this.buffer = null;
            return var4_5;
        }

        public void run() {
            while (!this.endOfStream() && this.connected) {
                try {
                    PushSourceStreamSlave pushSourceStreamSlave = this;
                    synchronized (pushSourceStreamSlave) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Exception: " + interruptedException);
                }
                if (!this.connected || this.handler == null) continue;
                this.handler.transferData(this);
            }
        }

        synchronized void setBuffer(byte[] byArray) {
            this.buffer = byArray;
            this.notifyAll();
        }

        public void setTransferHandler(SourceTransferHandler sourceTransferHandler) {
            this.handler = sourceTransferHandler;
        }
    }

    class PushBufferStreamSlave
    extends PushStreamSlave
    implements PushBufferStream,
    Runnable {
        BufferTransferHandler handler;
        private Buffer b;

        PushBufferStreamSlave() {
        }

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        BufferTransferHandler getTransferHandler() {
            return this.handler;
        }

        public synchronized void read(Buffer buffer) throws IOException {
            while (this.b == null && this.connected) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Exception: " + interruptedException);
                }
            }
            if (!this.connected) {
                throw new IOException("DataSource is not connected");
            }
            buffer.copy(this.b);
            this.b = null;
        }

        public void run() {
            while (!this.endOfStream() && this.connected) {
                try {
                    PushBufferStreamSlave pushBufferStreamSlave = this;
                    synchronized (pushBufferStreamSlave) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Exception: " + interruptedException);
                }
                if (!this.connected || this.handler == null) continue;
                this.handler.transferData(this);
            }
        }

        synchronized void setBuffer(Buffer buffer) {
            this.b = buffer;
            this.notifyAll();
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.handler = bufferTransferHandler;
        }
    }

    class PullSourceStreamAdapter
    extends SourceStreamAdapter
    implements PullSourceStream {
        PullSourceStreamAdapter() {
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(byArray, n2, n3);
        }

        public boolean willReadBlock() {
            return ((PullSourceStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }
    }

    class PullBufferStreamAdapter
    extends SourceStreamAdapter
    implements PullBufferStream {
        PullBufferStreamAdapter() {
        }

        public Format getFormat() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public boolean willReadBlock() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }
    }

    class PushSourceStreamAdapter
    extends SourceStreamAdapter
    implements PushSourceStream,
    SourceTransferHandler {
        SourceTransferHandler handler;

        PushSourceStreamAdapter() {
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(byArray, n2, n3);
        }

        public void setTransferHandler(SourceTransferHandler sourceTransferHandler) {
            this.handler = sourceTransferHandler;
            ((PushSourceStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushSourceStream pushSourceStream) {
            if (this.handler != null) {
                this.handler.transferData(this);
            }
        }
    }

    class PushBufferStreamAdapter
    extends SourceStreamAdapter
    implements PushBufferStream,
    BufferTransferHandler {
        BufferTransferHandler handler;

        PushBufferStreamAdapter() {
        }

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.handler = bufferTransferHandler;
            ((PushBufferStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushBufferStream pushBufferStream) {
            if (this.handler != null) {
                this.handler.transferData(this);
            }
        }
    }
}

