/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ulaw;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private int numberOfInputChannels;
    private int numberOfOutputChannels = 1;
    private boolean downmix = false;
    private int inputSampleSize;
    private int lsbOffset;
    private int msbOffset;
    private int inputBias;
    private int signMask;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1)};
        this.PLUGIN_NAME = "pcm to mu-law converter";
    }

    private int calculateOutputSize(int n2) {
        if (this.inputSampleSize == 16) {
            n2 /= 2;
        }
        if (this.downmix) {
            n2 /= 2;
        }
        return n2;
    }

    public void close() {
    }

    private void convert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n2 + this.msbOffset;
        while (n5 < n3 + n2) {
            int n6;
            int n7;
            int n8;
            if (this.inputSampleSize == 8) {
                n8 = byArray[n5++] << 8;
                if (this.downmix) {
                    n8 = (n8 & this.signMask) + (byArray[n5++] << 8 & this.signMask) >> 1;
                }
            } else {
                n8 = (byArray[n5] << 8) + (0xFF & byArray[n5 + this.lsbOffset]);
                n5 += 2;
                if (this.downmix) {
                    n8 = (n8 & this.signMask) + ((byArray[n5] << 8) + (0xFF & byArray[n5 + this.lsbOffset]) & this.signMask) >> 1;
                    n5 += 2;
                }
            }
            if ((n7 = (int)(n8 + this.inputBias)) >= 0) {
                n6 = 128;
            } else {
                n7 = -n7;
                n6 = 0;
            }
            n7 = 132 + n7 >> 3;
            byArray2[n4++] = (byte)(n7 < 32 ? n6 | 0x70 | 31 - n7 : (n7 < 64 ? n6 | 0x60 | 31 - (n7 >> 1) : (n7 < 128 ? n6 | 0x50 | 31 - (n7 >> 2) : (n7 < 256 ? n6 | 0x40 | 31 - (n7 >> 3) : (n7 < 512 ? n6 | 0x30 | 31 - (n7 >> 4) : (n7 < 1024 ? n6 | 0x20 | 31 - (n7 >> 5) : (n7 < 2048 ? n6 | 0x10 | 31 - (n7 >> 6) : (n7 < 4096 ? n6 | 31 - (n7 >> 7) : n6))))))));
        }
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        int n2 = audioFormat.getChannels();
        int n3 = (int)audioFormat.getSampleRate();
        this.supportedOutputFormats = n2 == 2 ? new AudioFormat[]{new AudioFormat("ULAW", n3, 8, 2, -1, -1), new AudioFormat("ULAW", n3, 8, 1, -1, -1)} : new AudioFormat[]{new AudioFormat("ULAW", n3, 8, 1, -1, -1)};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat audioFormat) {
        this.lastFormat = audioFormat;
        this.numberOfInputChannels = audioFormat.getChannels();
        if (this.outputFormat != null) {
            this.numberOfOutputChannels = this.outputFormat.getChannels();
        }
        this.inputSampleSize = audioFormat.getSampleSizeInBits();
        if (audioFormat.getEndian() == 1 || this.inputSampleSize == 8) {
            this.lsbOffset = 1;
            this.msbOffset = 0;
        } else {
            this.lsbOffset = -1;
            this.msbOffset = 1;
        }
        if (audioFormat.getSigned() == 1) {
            this.inputBias = 0;
            this.signMask = -1;
        } else {
            this.inputBias = 32768;
            this.signMask = 65535;
        }
        this.downmix = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Format format = buffer.getFormat();
        if (this.lastFormat != format) {
            this.initConverter((AudioFormat)format);
        }
        int n2 = buffer.getLength();
        int n3 = this.calculateOutputSize(buffer.getLength());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        this.convert(byArray, buffer.getOffset(), n2, byArray2, 0);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        return 0;
    }
}

