/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.ima4.IMA4State;

public class IMA4 {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";
    public static int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    public static int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    public static int[] diffLUT = new int[1424];

    static {
        int n2 = 0;
        while (n2 < 16) {
            int n3 = 0;
            while (n3 <= 88) {
                int n4 = n2 & 8;
                int n5 = stepsizeTable[n3];
                int n6 = n5 >> 3;
                if ((n2 & 4) != 0) {
                    n6 += n5;
                }
                if ((n2 & 2) != 0) {
                    n6 += n5 >> 1;
                }
                if ((n2 & 1) != 0) {
                    n6 += n5 >> 2;
                }
                if (n4 != 0) {
                    n6 = -n6;
                }
                IMA4.diffLUT[(n3 << 4) + n2] = n6;
                ++n3;
            }
            ++n2;
        }
    }

    public static void decode(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, IMA4State iMA4State, int n5) {
        int n6;
        int n7 = 0;
        boolean bl = false;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = byArray;
        int n8 = iMA4State.valprev;
        int n9 = n6 = iMA4State.index;
        while (n4 > 0) {
            int n10;
            if (bl) {
                n10 = n7 >> 4 & 0xF;
            } else {
                n7 = byArray4[n2++];
                n10 = n7 & 0xF;
            }
            bl ^= true;
            if ((n6 += indexTable[n10]) < 0) {
                n6 = 0;
            } else if (n6 > 88) {
                n6 = 88;
            }
            if ((n8 += diffLUT[(n9 << 4) + n10]) > Short.MAX_VALUE) {
                n8 = Short.MAX_VALUE;
            } else if (n8 < Short.MIN_VALUE) {
                n8 = Short.MIN_VALUE;
            }
            n9 = n6;
            byArray3[n3++] = (byte)(n8 >> 8);
            byArray3[n3++] = (byte)n8;
            n3 += n5;
            --n4;
        }
        iMA4State.valprev = n8;
        iMA4State.index = n6;
    }

    static void encode(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, IMA4State iMA4State, int n5) {
        int n6 = 0;
        int n7 = iMA4State.valprev;
        int n8 = iMA4State.index;
        int n9 = stepsizeTable[n8];
        boolean bl = true;
        while (n4 > 0) {
            int n10;
            int n11 = byArray[n2++] & 0xFF;
            int n12 = byArray[n2++] << 8 | n11;
            n2 += n5;
            int n13 = n12 - n7;
            if (n13 < 0) {
                n10 = 8;
                n13 = -n13;
            } else {
                n10 = 0;
            }
            int n14 = 0;
            int n15 = n9 >> 3;
            if (n13 >= n9) {
                n14 = 4;
                n13 -= n9;
                n15 += n9;
            }
            if (n13 >= (n9 >>= 1)) {
                n14 |= 2;
                n13 -= n9;
                n15 += n9;
            }
            if (n13 >= (n9 >>= 1)) {
                n14 |= 1;
                n15 += n9;
            }
            n7 = n10 != 0 ? (n7 -= n15) : (n7 += n15);
            if (n7 > Short.MAX_VALUE) {
                n7 = Short.MAX_VALUE;
            } else if (n7 < Short.MIN_VALUE) {
                n7 = Short.MIN_VALUE;
            }
            if ((n8 += indexTable[n14 |= n10]) < 0) {
                n8 = 0;
            } else if (n8 > 88) {
                n8 = 88;
            }
            n9 = stepsizeTable[n8];
            if (bl) {
                n6 = n14;
            } else {
                byArray2[n3++] = (byte)(n14 << 4 | n6);
            }
            bl ^= true;
            --n4;
        }
        if (bl) {
            byArray2[n3++] = (byte)n6;
        }
        iMA4State.valprev = n7;
        iMA4State.index = n8;
    }
}

