/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection) throws XAException {
        super(connection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {}
        if (this.m_version < 8160) {
            this.trace("Java XA  is not supported for this server version");
            throw new XAException(-6);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n = -1;
        int n2 = 0;
        Statement statement = null;
        this.trace("OracleXAResource.commit(xid, bool):start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n3 = bl ? 1 : 0;
        try {
            try {
                Xid xid2 = super.suspendStacked(xid);
                this.setSQLXAErrorFlag(false);
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        this.trace("Should use OracleXid for 8.1.6 database");
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(xa_commit_816);
                    statement.registerOutParameter(1, 2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.setInt(3, n3);
                    statement.registerOutParameter(4, 2);
                    statement.execute();
                    n = statement.getInt(1);
                    n2 = statement.getInt(4);
                    ((OracleXid)xid).setState(n2);
                } else {
                    statement = this.m_conn.prepareCall(xa_commit_post_816);
                    statement.registerOutParameter(1, 2);
                    statement.setInt(2, xid.getFormatId());
                    statement.setBytes(3, xid.getGlobalTransactionId());
                    statement.setBytes(4, xid.getBranchQualifier());
                    statement.setInt(5, n3);
                    statement.execute();
                    n = statement.getInt(1);
                }
                super.resumeStacked(xid2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.setSQLXAErrorFlag(true);
        this.trace("Return Status of xa_commit is " + n);
        this.checkError(n);
        this.trace("OracleXAResource.commit(xid, bool):end");
    }

    public void end(Xid xid, int n) throws XAException {
        int n2 = -1;
        Statement statement = null;
        this.trace("OracleXAResource.end(xid, int):start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
            this.trace("OracleXAResource.end(xid, int): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        try {
            try {
                Xid xid2 = super.suspendStacked(xid, n);
                super.pop();
                this.setSQLXAErrorFlag(false);
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        this.trace("Should use OracleXid for 8.1.6 database");
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(xa_end_816);
                    statement.registerOutParameter(1, 2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.setInt(3, n);
                    statement.execute();
                    n2 = statement.getInt(1);
                } else {
                    statement = this.m_conn.prepareCall(xa_end_post_816);
                    statement.registerOutParameter(1, 2);
                    statement.setInt(2, xid.getFormatId());
                    statement.setBytes(3, xid.getGlobalTransactionId());
                    statement.setBytes(4, xid.getBranchQualifier());
                    statement.setInt(5, n);
                    statement.execute();
                    n2 = statement.getInt(1);
                }
                super.resumeStacked(xid2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.trace("Return Status of xa_end is " + n2);
        this.setSQLXAErrorFlag(true);
        this.checkError(n2);
        this.trace("OracleXAResource.end(xid, int):end");
    }

    public void forget(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        this.trace("OracleXAResource.forget():start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        try {
            try {
                this.setSQLXAErrorFlag(false);
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        this.trace("Should use OracleXid for 8.1.6 database");
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                    statement.registerOutParameter(1, 2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.registerOutParameter(3, 2);
                    statement.execute();
                    n = statement.getInt(1);
                    n2 = statement.getInt(3);
                    ((OracleXid)xid).setState(n2);
                } else {
                    statement = this.m_conn.prepareCall(xa_forget_post_816);
                    statement.registerOutParameter(1, 2);
                    statement.setInt(2, xid.getFormatId());
                    statement.setBytes(3, xid.getGlobalTransactionId());
                    statement.setBytes(4, xid.getBranchQualifier());
                    statement.execute();
                    n = statement.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.trace("Return Status of xa_forget is " + n);
        this.setSQLXAErrorFlag(true);
        this.checkError(n);
        this.trace("OracleXAResource.forget():end");
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        this.trace("OracleXAResource.prepare():start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        try {
            block14: {
                try {
                    Xid xid2 = super.suspendStacked(xid);
                    this.setSQLXAErrorFlag(false);
                    if (this.m_version == 8160) {
                        if (!(xid instanceof OracleXid)) {
                            this.trace("Should use OracleXid for 8.1.6 database");
                            throw new XAException(-6);
                        }
                        statement = this.m_conn.prepareCall(xa_prepare_816);
                        statement.registerOutParameter(1, 2);
                        byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                        statement.setBytes(2, byArray);
                        statement.registerOutParameter(3, 2);
                        statement.execute();
                        n = statement.getInt(1);
                        n2 = statement.getInt(3);
                        ((OracleXid)xid).setState(n2);
                    } else {
                        statement = this.m_conn.prepareCall(xa_prepare_post_816);
                        statement.registerOutParameter(1, 2);
                        statement.setInt(2, xid.getFormatId());
                        statement.setBytes(3, xid.getGlobalTransactionId());
                        statement.setBytes(4, xid.getBranchQualifier());
                        statement.execute();
                        n = statement.getInt(1);
                    }
                    super.resumeStacked(xid2);
                }
                catch (SQLException sQLException) {
                    int n3 = sQLException.getErrorCode();
                    if (n3 != 3113 && n3 != 3114) break block14;
                    n = n3;
                }
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.trace("Return Status of xa_prepare is " + n);
        this.setSQLXAErrorFlag(true);
        int n4 = n == 0 ? 0 : OracleXAException.errorConvert(n);
        this.trace("x_e is " + n4);
        if (n4 != 0 && n4 != 3) {
            throw new OracleXAException(n);
        }
        this.trace("OracleXAResource.prepare():end");
        return n4;
    }

    public void rollback(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        this.trace("OracleXAResource.rollback():start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        try {
            try {
                Xid xid2 = super.suspendStacked(xid);
                this.setSQLXAErrorFlag(false);
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        this.trace("Should use OracleXid for 8.1.6 database");
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(xa_rollback_816);
                    statement.registerOutParameter(1, 2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.registerOutParameter(3, 2);
                    statement.execute();
                    n = statement.getInt(1);
                    n2 = statement.getInt(3);
                    ((OracleXid)xid).setState(n2);
                } else {
                    statement = this.m_conn.prepareCall(xa_rollback_post_816);
                    statement.registerOutParameter(1, 2);
                    statement.setInt(2, xid.getFormatId());
                    statement.setBytes(3, xid.getGlobalTransactionId());
                    statement.setBytes(4, xid.getBranchQualifier());
                    statement.execute();
                    n = statement.getInt(1);
                }
                super.resumeStacked(xid2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.trace("Return Status of xa_rollback is " + n);
        this.setSQLXAErrorFlag(true);
        this.checkError(n);
        this.trace("OracleXAResource.rollback():end");
    }

    public void start(Xid xid, int n) throws XAException {
        int n2 = -1;
        Statement statement = null;
        this.trace("OracleXAResource.start():start");
        if (xid == null) {
            this.trace("OracleXAResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n != 0 && n != 0x8000000 && n != 0x200000 && (n & 2) != 2) {
            this.trace("OracleXAResource.start(): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        try {
            try {
                this.setSQLXAErrorFlag(false);
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        this.trace("Should use OracleXid for 8.1.6 database");
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(xa_start_816);
                    statement.registerOutParameter(1, -2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.setInt(3, this.m_timeout);
                    statement.setInt(4, n);
                    statement.registerOutParameter(5, 2);
                    statement.execute();
                    byte[] byArray2 = statement.getBytes(1);
                    ((OracleXid)xid).setTxContext(byArray2);
                    n2 = statement.getInt(5);
                } else {
                    statement = this.m_conn.prepareCall(xa_start_post_816);
                    statement.registerOutParameter(1, 2);
                    statement.setInt(2, xid.getFormatId());
                    statement.setBytes(3, xid.getGlobalTransactionId());
                    statement.setBytes(4, xid.getBranchQualifier());
                    statement.setInt(5, this.m_timeout);
                    statement.setInt(6, n);
                    statement.execute();
                    n2 = statement.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            statement = null;
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        statement = null;
        this.trace("Return Status of xa_start is " + n2);
        this.checkError(n2);
        super.push(xid);
        this.trace("OracleXAResource.start():end");
    }
}

