/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.oracle.OracleClobDataType;

public class OracleDataTypeFactory
extends DefaultDataTypeFactory {
    public static final DataType ORACLE_CLOB = new OracleClobDataType();

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (sqlType == 91) {
            return DataType.TIMESTAMP;
        }
        if (sqlType == 1111) {
            if ("BLOB".equals(sqlTypeName)) {
                return DataType.BLOB;
            }
            if ("CLOB".equals(sqlTypeName) || "NCLOB".equals(sqlTypeName)) {
                return ORACLE_CLOB;
            }
            if ("NVARCHAR2".equals(sqlTypeName)) {
                return DataType.VARCHAR;
            }
            if (sqlTypeName.startsWith("TIMESTAMP")) {
                return DataType.TIMESTAMP;
            }
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

