/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class OracleClobDataType
extends ClobDataType {
    private static final Integer DURATION_SESSION = new Integer(1);
    private static final Integer MODE_READWRITE = new Integer(1);
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return this.typeCast(resultSet.getClob(column));
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }

    private Object getClob(Object value, Connection connection) throws TypeCastException {
        Object tempClob = null;
        try {
            Class<?> aClobClass = Class.forName("oracle.sql.CLOB");
            Method createTemporaryMethod = aClobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleClobDataType.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            tempClob = createTemporaryMethod.invoke(null, connection, Boolean.TRUE, DURATION_SESSION);
            Method openMethod = aClobClass.getMethod("open", Integer.TYPE);
            openMethod.invoke(tempClob, MODE_READWRITE);
            Method getCharacterOutputStreamMethod = tempClob.getClass().getMethod("getCharacterOutputStream", new Class[0]);
            Writer tempClobWriter = (Writer)getCharacterOutputStreamMethod.invoke(tempClob, new Object[0]);
            tempClobWriter.write((String)this.typeCast(value));
            tempClobWriter.flush();
            tempClobWriter.close();
            Method closeMethod = tempClob.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(tempClob, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(e);
        }
        catch (NoSuchMethodException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(e);
        }
        catch (IOException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(e);
        }
        catch (InvocationTargetException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(e);
        }
        return tempClob;
    }

    private void freeTemporaryClob(Object tempClob) throws TypeCastException {
        if (tempClob == null) {
            return;
        }
        try {
            Method freeTemporaryMethod = tempClob.getClass().getMethod("freeTemporary", new Class[0]);
            freeTemporaryMethod.invoke(tempClob, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

