/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.PrintWriter;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;

public class FlatDtdWriter {
    private Writer _writer;

    public FlatDtdWriter(Writer writer) {
        this._writer = writer;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        int i;
        PrintWriter printOut = new PrintWriter(this._writer);
        String[] tableNames = dataSet.getTableNames();
        printOut.println("<!ELEMENT dataset (");
        for (i = 0; i < tableNames.length; ++i) {
            printOut.print("    ");
            printOut.print(tableNames[i]);
            printOut.print("*");
            if (i + 1 >= tableNames.length) continue;
            printOut.println(",");
        }
        printOut.println(")>");
        printOut.println();
        for (i = 0; i < tableNames.length; ++i) {
            String tableName = tableNames[i];
            printOut.print("<!ELEMENT ");
            printOut.print(tableName);
            printOut.println(" EMPTY>");
            printOut.print("<!ATTLIST ");
            printOut.println(tableName);
            Column[] columns = dataSet.getTableMetaData(tableName).getColumns();
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                printOut.print("    ");
                printOut.print(column.getColumnName());
                if (column.getNullable() == Column.NULLABLE) {
                    printOut.println(" CDATA #IMPLIED");
                    continue;
                }
                printOut.println(" CDATA #REQUIRED");
            }
            printOut.println(">");
            printOut.println();
        }
        printOut.flush();
    }
}

