/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.excel.XlsTable;

public class XlsDataSet
extends AbstractDataSet {
    private final ITable[] _tables;

    public XlsDataSet(File file) throws IOException, DataSetException {
        this(new FileInputStream(file));
    }

    public XlsDataSet(InputStream in) throws IOException, DataSetException {
        HSSFWorkbook workbook = new HSSFWorkbook(in);
        this._tables = new ITable[workbook.getNumberOfSheets()];
        for (int i = 0; i < this._tables.length; ++i) {
            this._tables[i] = new XlsTable(workbook.getSheetName(i), workbook.getSheetAt(i));
        }
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        int index = 0;
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            int j;
            ITable table = iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            HSSFSheet sheet = workbook.createSheet(metaData.getTableName());
            workbook.setSheetName(index, metaData.getTableName());
            HSSFRow headerRow = sheet.createRow(0);
            Column[] columns = metaData.getColumns();
            for (j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                HSSFCell cell = headerRow.createCell((short)j);
                cell.setCellValue(column.getColumnName());
            }
            for (j = 0; j < table.getRowCount(); ++j) {
                HSSFRow row = sheet.createRow(j + 1);
                for (int k = 0; k < columns.length; ++k) {
                    Column column = columns[k];
                    Object value = table.getValue(j, column.getColumnName());
                    if (value == null) continue;
                    HSSFCell cell = row.createCell((short)k);
                    cell.setCellValue(DataType.asString(value));
                }
            }
            ++index;
        }
        workbook.write(out);
        out.flush();
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new DefaultTableIterator(this._tables, reversed);
    }
}

