/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.Base64;

public class BytesDataType
extends AbstractDataType {
    static /* synthetic */ Class array$B;

    BytesDataType(String name, int sqlType) {
        super(name, sqlType, array$B == null ? (array$B = BytesDataType.class$("[B")) : array$B, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null) {
            return value;
        }
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof String) {
            return Base64.decode((String)value);
        }
        if (value instanceof Blob) {
            try {
                Blob blobValue = (Blob)value;
                return blobValue.getBytes(1L, (int)blobValue.length());
            }
            catch (SQLException e) {
                throw new TypeCastException(e);
            }
        }
        throw new TypeCastException(value.toString());
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        try {
            byte[] value1 = (byte[])this.typeCast(o1);
            byte[] value2 = (byte[])this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return this.compare(value1, value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }

    public int compare(byte[] v1, byte[] v2) throws TypeCastException {
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        int j = 0;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                byte c1 = v1[k];
                byte c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                byte c2;
                byte c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getBytes(column);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        super.setSqlValue(value, column, statement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

