/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class BooleanDataType
extends AbstractDataType {
    static /* synthetic */ Class class$java$lang$Boolean;

    BooleanDataType() {
        super("BIT", -7, class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanDataType.class$("java.lang.Boolean")) : class$java$lang$Boolean, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.intValue() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (value instanceof String) {
            String string = (String)value;
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                return Boolean.valueOf(string);
            }
            return this.typeCast(DataType.INTEGER.typeCast(string));
        }
        throw new TypeCastException(value.toString());
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        Boolean value1 = (Boolean)this.typeCast(o1);
        Boolean value2 = (Boolean)this.typeCast(o2);
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null && value2 != null) {
            return -1;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1.equals(value2)) {
            return 0;
        }
        if (value1.equals(Boolean.FALSE)) {
            return -1;
        }
        return 1;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        boolean value = resultSet.getBoolean(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setBoolean(column, (Boolean)this.typeCast(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

