/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.ReplacementTable;

public class ReplacementDataSet
extends AbstractDataSet {
    private final IDataSet _dataSet;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;

    public ReplacementDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
        this._objectMap = new HashMap();
        this._substringMap = new HashMap();
    }

    public ReplacementDataSet(IDataSet dataSet, Map objectMap, Map substringMap) {
        this._dataSet = dataSet;
        this._objectMap = objectMap == null ? new HashMap() : objectMap;
        this._substringMap = substringMap == null ? new HashMap() : substringMap;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private ReplacementTable createReplacementTable(ITable table) {
        return new ReplacementTable(table, this._objectMap, this._substringMap, this._startDelim, this._endDelim);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new ReplacementIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        return this.createReplacementTable(this._dataSet.getTable(tableName));
    }

    private class ReplacementIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public ReplacementIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return ReplacementDataSet.this.createReplacementTable(this._iterator.getTable());
        }
    }
}

