/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dbunit.Assertion;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class DataSetUtils {
    private DataSetUtils() {
    }

    public static void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws Exception {
        Assertion.assertEquals(expectedDataSet, actualDataSet);
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable) throws Exception {
        Assertion.assertEquals(expectedTable, actualTable);
    }

    public static String getQualifiedName(String prefix, String name) {
        return DataSetUtils.getQualifiedName(prefix, name, null);
    }

    public static String getQualifiedName(String prefix, String name, String escapePattern) {
        if (escapePattern != null) {
            prefix = DataSetUtils.getEscapedName(prefix, escapePattern);
            name = DataSetUtils.getEscapedName(name, escapePattern);
        }
        if (prefix == null || prefix.equals("") || name.indexOf(".") >= 0) {
            return name;
        }
        return prefix + "." + name;
    }

    public static String getEscapedName(String name, String escapePattern) {
        if (name == null || escapePattern == null) {
            return name;
        }
        int index = escapePattern.indexOf("?");
        if (index >= 0) {
            String prefix = escapePattern.substring(0, index);
            String suffix = escapePattern.substring(index + 1);
            return prefix + name + suffix;
        }
        return name;
    }

    public static String getSqlValueString(Object value, DataType dataType) throws TypeCastException {
        if (value == null) {
            return "NULL";
        }
        String stringValue = DataType.asString(value);
        if (dataType == DataType.DATE) {
            return "{d '" + stringValue + "'}";
        }
        if (dataType == DataType.TIME) {
            return "{t '" + stringValue + "'}";
        }
        if (dataType == DataType.TIMESTAMP) {
            return "{ts '" + stringValue + "'}";
        }
        if (!dataType.isNumber()) {
            if (stringValue.indexOf("'") < 0) {
                stringValue = "'" + stringValue + "'";
                return stringValue;
            }
            StringBuffer buffer = new StringBuffer(stringValue.length() * 2);
            StringTokenizer tokenizer = new StringTokenizer(stringValue, "'", true);
            buffer.append("'");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                buffer.append(token);
                if (!token.equals("'")) continue;
                buffer.append("'");
            }
            buffer.append("'");
            return buffer.toString();
        }
        return stringValue;
    }

    public static Column getColumn(String columnName, Column[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!columnName.equalsIgnoreCase(columns[i].getColumnName())) continue;
            return column;
        }
        return null;
    }

    public static ITable[] getTables(String[] names, IDataSet dataSet) throws DataSetException {
        ITable[] tables = new ITable[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            tables[i] = dataSet.getTable(name);
        }
        return tables;
    }

    public static ITable[] getTables(IDataSet dataSet) throws DataSetException {
        return DataSetUtils.getTables(dataSet.iterator());
    }

    public static ITable[] getTables(ITableIterator iterator) throws DataSetException {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        while (iterator.next()) {
            tableList.add(iterator.getTable());
        }
        return tableList.toArray(new ITable[0]);
    }

    public static String[] getReverseTableNames(IDataSet dataSet) throws DataSetException {
        return DataSetUtils.reverseStringArray(dataSet.getTableNames());
    }

    public static String[] reverseStringArray(String[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - 1 - i] = array[i];
        }
        return newArray;
    }
}

