/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.database.statement.AbstractPreparedBatchStatement;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class PreparedBatchStatement
extends AbstractPreparedBatchStatement {
    private int _index = 0;

    PreparedBatchStatement(String sql, Connection connection) throws SQLException {
        super(sql, connection);
    }

    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        if (value == null) {
            this._statement.setNull(++this._index, dataType.getSqlType());
            return;
        }
        dataType.setSqlValue(value, ++this._index, this._statement);
    }

    public void addBatch() throws SQLException {
        this._statement.addBatch();
        this._index = 0;
    }

    public int executeBatch() throws SQLException {
        int[] results = this._statement.executeBatch();
        int result = 0;
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        return result;
    }

    public void clearBatch() throws SQLException {
        this._statement.clearBatch();
    }
}

