/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.Operation;
import org.dbunit.database.IDatabaseConnection;

public class Composite
extends Operation {
    private List operations = new ArrayList();

    public Composite() {
        this.type = "COMPOSITE";
    }

    public void setType(String type) {
        throw new IllegalStateException("Cannot set type of a <composite>!");
    }

    public List getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        ListIterator operIter = this.operations.listIterator();
        while (operIter.hasNext()) {
            Operation operation = (Operation)operIter.next();
            if (operation.getSrc() != null) {
                throw new DatabaseUnitException("Cannot set 'src' attribute in a <composite>'s sub-<operation>");
            }
            operation.setSrc(this.getSrc());
            if (operation.getRawFormat() != null && !operation.getFormat().equalsIgnoreCase(this.getFormat())) {
                throw new DatabaseUnitException("Cannot override 'format' attribute in a <composite>'s sub-<operation>");
            }
            operation.setFormat(this.getFormat());
            operation.execute(connection);
        }
    }

    public String getLogMessage() {
        StringBuffer result = new StringBuffer();
        result.append("Executing composite: ");
        result.append("\n          on   file: " + this.getSrc().getAbsolutePath());
        ListIterator operIter = this.operations.listIterator();
        while (operIter.hasNext()) {
            Operation operation = (Operation)operIter.next();
            result.append("\n    operation: " + operation.getType());
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Composite: ");
        result.append("  src=" + this.getSrc().getAbsolutePath());
        result.append(", format=" + this.getFormat());
        result.append(", operations=" + this.operations);
        return result.toString();
    }
}

