/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.jbo.JboException;

public class LongRunningStatementHandle {
    private Statement mStmt;
    private int mState = 1;
    private long mExpiresAt;
    public static final int COMPLETED = 0;
    public static final int RUNNING = 1;
    public static final int CANCELLED = 2;

    public LongRunningStatementHandle(long l, Statement statement) {
        this.mExpiresAt = l;
        this.mStmt = statement;
    }

    public synchronized void setState(int n) {
        this.mState = n;
    }

    public synchronized int getState() {
        return this.mState;
    }

    public long getExpiryTime() {
        return this.mExpiresAt;
    }

    public synchronized boolean cancel() {
        if (this.mStmt == null) {
            return false;
        }
        if (this.mState == 1 && this.mStmt != null) {
            try {
                this.mStmt.cancel();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new JboException(sQLException);
            }
            this.mState = 2;
        }
        return true;
    }
}

