/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.format;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.format.FormatErrorException;
import oracle.jbo.format.Formatter;
import oracle.jbo.format.UnknownLocaleException;

public class DefaultDateFormatter
extends Formatter {
    private LocaleContext _theLocale;
    private SimpleDateFormat _theSimpleDateFormatHelper;
    private String _defaultFormatString;

    private /* synthetic */ void $init$() {
        this._theLocale = new DefLocaleContext();
        this._theSimpleDateFormatHelper = new SimpleDateFormat("", this._theLocale.getLocale());
    }

    public DefaultDateFormatter() {
        this.$init$();
        this._defaultFormatString = this._theSimpleDateFormatHelper.toPattern();
        this._theSimpleDateFormatHelper.getCalendar().setLenient(false);
        this._theSimpleDateFormatHelper.setLenient(false);
    }

    public String format(String string, Object object) throws FormatErrorException {
        this._theSimpleDateFormatHelper.setLenient(false);
        this._theSimpleDateFormatHelper.applyPattern(string);
        if (object instanceof oracle.jbo.domain.Date) {
            return this._theSimpleDateFormatHelper.format(((oracle.jbo.domain.Date)object).timestampValue());
        }
        if (object instanceof oracle.jbo.domain.Timestamp) {
            Object object2 = this._convertJboDomainToTimestamp((oracle.jbo.domain.Timestamp)object);
            return this._theSimpleDateFormatHelper.format(object2);
        }
        return this._theSimpleDateFormatHelper.format(object);
    }

    public Object parse(String string, String string2) throws ParseException {
        this._theSimpleDateFormatHelper.setLenient(false);
        this._theSimpleDateFormatHelper.applyPattern(string);
        Date date = this._theSimpleDateFormatHelper.parse(string2, new ParsePosition(0));
        if (date != null) {
            if (date instanceof Timestamp) {
                return date;
            }
            if (date instanceof Date) {
                return this._DateToTimestamp(date);
            }
        } else {
            throw new ParseException("parse failed", 0);
        }
        return null;
    }

    public void setLocale(LocaleContext localeContext) throws UnknownLocaleException {
        if (this._theLocale != localeContext && localeContext != null) {
            this._theSimpleDateFormatHelper.setDateFormatSymbols(new DateFormatSymbols(localeContext.getLocale()));
            this._theSimpleDateFormatHelper.setCalendar(Calendar.getInstance(localeContext.getLocale()));
            this._theLocale = localeContext;
        }
    }

    public LocaleContext getLocale() {
        return this._theLocale;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        this._theSimpleDateFormatHelper.setLenient(false);
        Object object = this._theSimpleDateFormatHelper.parseObject(string, parsePosition);
        if (object != null) {
            if (object instanceof Timestamp) {
                return object;
            }
            if (object instanceof Date) {
                return this._DateToTimestamp((Date)object);
            }
        }
        return null;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this._theSimpleDateFormatHelper.setLenient(false);
        if (object instanceof oracle.jbo.domain.Date) {
            return this._theSimpleDateFormatHelper.format((Date)((oracle.jbo.domain.Date)object).timestampValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof oracle.jbo.domain.Timestamp) {
            Object object2 = this._convertJboDomainToTimestamp((oracle.jbo.domain.Timestamp)object);
            return this._theSimpleDateFormatHelper.format(object2, stringBuffer, fieldPosition);
        }
        return this._theSimpleDateFormatHelper.format(object, stringBuffer, fieldPosition);
    }

    private Timestamp _DateToTimestamp(Date date) {
        if (date != null) {
            Calendar calendar = this._theSimpleDateFormatHelper.getCalendar();
            calendar.setTime(date);
            Timestamp timestamp = new Timestamp(date.getTime());
            return timestamp;
        }
        return null;
    }

    private Object _convertJboDomainToTimestamp(oracle.jbo.domain.Timestamp timestamp) {
        try {
            java.sql.Date date = timestamp.dateValue();
            return date;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public String getDefaultFormatString() {
        return "yyyy-MM-dd";
    }
}

