/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.NameClashException;
import oracle.jbo.NoDefException;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.common.VariableImpl;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.rules.ValidationManager;

public class VariableManagerImpl
implements Serializable,
VariableManager {
    private transient VariableManagerOwner mOwner;
    private transient VariableManager[] mVarMgrParents;
    private HashMap mVariables = new HashMap(4);
    private ArrayList mVariableList = new ArrayList(4);
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public VariableManagerImpl() {
    }

    public VariableManagerImpl(VariableManagerOwner variableManagerOwner, VariableManager[] variableManagerArray) {
        this();
        this.mOwner = variableManagerOwner;
        this.mVarMgrParents = variableManagerArray;
    }

    protected Map variables() {
        return this.mVariables;
    }

    protected List variableList() {
        return this.mVariableList;
    }

    ArrayList doGetVariables(String string, HashMap hashMap, ArrayList arrayList) {
        if (hashMap == null) {
            hashMap = new HashMap<String, Variable>(20);
            arrayList = new ArrayList<Variable>(20);
        }
        int n = 0;
        while (n < this.mVariableList.size()) {
            Variable variable = (Variable)this.mVariableList.get(n);
            if (hashMap.get(variable.getName()) == null && (string == null || string.equals(variable.getVariableKind()) || string.length() == 0 && variable.getVariableKind() == null)) {
                hashMap.put(variable.getName(), variable);
                arrayList.add(variable);
            }
            ++n;
        }
        VariableManager[] variableManagerArray = this.getVarMgrParents();
        if (variableManagerArray != null) {
            int n2 = 0;
            while (n2 < variableManagerArray.length) {
                if (variableManagerArray[n2] != null) {
                    ((VariableManagerImpl)variableManagerArray[n2]).doGetVariables(string, hashMap, arrayList);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public String getName() {
        return this.mOwner != null ? this.mOwner.getName() : this.toString();
    }

    public VariableManagerOwner getVarMgrOwner() {
        return this.mOwner;
    }

    public VariableManager[] getVarMgrParents() {
        return this.mVarMgrParents;
    }

    public void setVarMgrParents(VariableManager[] variableManagerArray) {
        this.mVarMgrParents = variableManagerArray;
    }

    public Map getVariablesMap() {
        return new 1();
    }

    public Variable[] getVariables() {
        return this.getVariablesOfKind(null);
    }

    public Variable[] getVariablesOfKind(String string) {
        ArrayList arrayList = this.doGetVariables(string, null, null);
        return arrayList.toArray(new Variable[arrayList.size()]);
    }

    public int getVariableCount() {
        return this.doGetVariables(null, null, null).size();
    }

    public Variable[] getDeclaredVariables() {
        return this.mVariableList.toArray(new Variable[this.mVariableList.size()]);
    }

    public int getDeclaredVariableCount() {
        return this.mVariableList.size();
    }

    boolean variableBelongs(Variable variable) {
        if (variable.getVariableManager() == this) {
            return true;
        }
        VariableManager[] variableManagerArray = this.getVarMgrParents();
        if (variableManagerArray != null) {
            int n = 0;
            while (n < variableManagerArray.length) {
                if (variableManagerArray[n] != null && ((VariableManagerImpl)variableManagerArray[n]).variableBelongs(variable)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public Variable findDeclaredVariable(String string) {
        Variable variable = (Variable)this.variables().get(string);
        if (variable != null) {
            return variable;
        }
        throw new NoDefException(132, string, this.getName());
    }

    public Variable findVariable(String string) {
        Variable variable = this.lookupVariable(string);
        if (variable != null) {
            return variable;
        }
        throw new NoDefException(132, string, this.getName());
    }

    public Variable lookupVariable(String string) {
        VariableManager[] variableManagerArray;
        Variable variable = (Variable)this.variables().get(string);
        if (variable == null && (variableManagerArray = this.getVarMgrParents()) != null) {
            int n = 0;
            while (n < variableManagerArray.length) {
                if (variableManagerArray[n] != null && (variable = variableManagerArray[n].lookupVariable(string)) != null) break;
                ++n;
            }
        }
        return variable;
    }

    public void addVariable(Variable variable) {
        String string = variable.getName();
        if (string == null || string.length() == 0) {
            throw new InvalidObjNameException(132, string);
        }
        Variable variable2 = (Variable)this.mVariables.get(string);
        if (variable2 != null) {
            throw new NameClashException(132, string);
        }
        this.mVariables.put(string, variable);
        this.mVariableList.add(variable);
        variable.setVariableManager(this);
    }

    public Variable addVariable(String string) {
        VariableImpl variableImpl = this.internalCreateVariableInstance();
        variableImpl.setName(string);
        this.addVariable(variableImpl);
        return variableImpl;
    }

    public Variable replaceVariable(Variable variable) {
        Variable variable2 = this.removeVariable(variable.getName());
        this.addVariable(variable);
        return variable2;
    }

    public Variable removeVariable(String string) {
        Variable variable = (Variable)this.mVariables.get(string);
        if (variable == null) {
            throw new NoDefException(132, string, this.getName());
        }
        this.mVariables.remove(string);
        this.mVariableList.remove(variable);
        variable.setVariableManager(null);
        return variable;
    }

    public void clearVariables() {
        int n = 0;
        while (n < this.mVariableList.size()) {
            ((Variable)this.mVariableList.get(n)).setVariableManager(null);
            ++n;
        }
        this.mVariables.clear();
        this.mVariableList.clear();
    }

    public void mergeVariables(Variable[] variableArray) {
        if (variableArray != null) {
            int n = 0;
            while (n < variableArray.length) {
                this.addVariable((Variable)variableArray[n].clone());
                ++n;
            }
        }
    }

    protected Object accessValue(Variable variable) {
        return null;
    }

    Object getValueRaw(Variable variable, boolean bl, boolean bl2) {
        Object object = this.accessValue(variable);
        VariableManager variableManager = variable.getVariableManager();
        if (object == null) {
            if (variableManager == this) {
                return bl2 ? variable.getDefaultValue() : null;
            }
            VariableManager[] variableManagerArray = this.getVarMgrParents();
            if (variableManagerArray != null) {
                int n = 0;
                while (n < variableManagerArray.length) {
                    if (variableManagerArray[n] != null && (object = ((VariableManagerImpl)variableManagerArray[n]).getValueRaw(variable, false, bl2)) != null) break;
                    ++n;
                }
            }
        }
        if (object == null && bl && !this.variableBelongs(variable)) {
            throw new NoDefException(132, variable.getName(), this.getName());
        }
        return object;
    }

    protected VariableImpl internalCreateVariableInstance() {
        return new VariableImpl();
    }

    public void loadFromXML(DefElement[] defElementArray) {
        this.loadFromXML(defElementArray, true);
    }

    public void loadFromXML(DefElement[] defElementArray, boolean bl) {
        int n = 0;
        while (n < defElementArray.length) {
            VariableImpl variableImpl = this.internalCreateVariableInstance();
            variableImpl.initFromXML(defElementArray[n]);
            if (bl) {
                if (this.mOwner != null) {
                    RulesBeanUtils.loadValidators((DefElement)defElementArray[n], (ValidationManager)variableImpl, (Class)this.mOwner.getMessageBundleClass());
                } else {
                    DefElement defElement = defElementArray[n];
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = VariableManagerImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    RulesBeanUtils.loadValidators((DefElement)defElement, (ValidationManager)variableImpl, (Class)clazz);
                }
            }
            this.addVariable(variableImpl);
            ++n;
        }
    }

    public void variableChanged(Variable variable) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    extends JboAbstractMap {
        protected Object internalGet(String string) {
            if (VariableManagerImpl.this.mVariables != null && VariableManagerImpl.this.mVariables.containsKey(string)) {
                return VariableManagerImpl.this.mVariables.get(string);
            }
            VariableManager[] variableManagerArray = VariableManagerImpl.this.getVarMgrParents();
            if (variableManagerArray != null) {
                int n = 0;
                while (n < variableManagerArray.length) {
                    Map map;
                    if (variableManagerArray[n] != null && (map = ((VariableManagerImpl)variableManagerArray[n]).variables()).containsKey(string)) {
                        return map.get(string);
                    }
                    ++n;
                }
            }
            return null;
        }

        protected void internalPut(String string, Object object) {
            throw new UnsupportedOperationException("VariablesMap.put()");
        }
    }
}

