/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.JboException;
import oracle.jbo.common.JboObjectInputStream;
import oracle.jbo.common.JboObjectOutputStream;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackInputStream;
import oracle.jbo.common.PiggybackObjectOutputStream;
import oracle.jbo.common.SvcMsgResponse;

public class SvcMethodResponse
extends SvcMsgResponse
implements Serializable {
    static final long serialVersionUID = 6217409345205598405L;
    private Object mResponse;
    private byte[] mSerializedResponse;
    private boolean mCustomSerialized;

    private /* synthetic */ void $init$() {
        this.mCustomSerialized = false;
    }

    public SvcMethodResponse(String string) {
        this(string, null);
    }

    public SvcMethodResponse(String string, Object object) {
        super(4236, string);
        this.$init$();
        this.mResponse = object;
    }

    public Object getResponse() {
        return this.mResponse;
    }

    public String getMethodName() {
        return this.getName();
    }

    public boolean isNull() {
        if (this.mResponse == null) {
            return !this.mCustomSerialized || this.mSerializedResponse == null;
        }
        return false;
    }

    public void marshal(ObjectMarshaller objectMarshaller) {
        if (this.mSerializedResponse == null && this.mResponse != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                JboObjectOutputStream jboObjectOutputStream = new JboObjectOutputStream(byteArrayOutputStream, objectMarshaller);
                jboObjectOutputStream.writeObject(this.mResponse);
                jboObjectOutputStream.flush();
                byteArrayOutputStream.flush();
                this.mSerializedResponse = byteArrayOutputStream.toByteArray();
                this.mCustomSerialized = true;
            }
            catch (IOException iOException) {
                throw new JboException(iOException);
            }
        }
    }

    public void unMarshal(ObjectMarshaller objectMarshaller) {
        if (this.mSerializedResponse != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mSerializedResponse);
                JboObjectInputStream jboObjectInputStream = new JboObjectInputStream(byteArrayInputStream, objectMarshaller);
                this.mResponse = jboObjectInputStream.readObject();
                this.mSerializedResponse = null;
            }
            catch (IOException iOException) {
                throw new JboException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException(classNotFoundException);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object = null;
        if (objectOutputStream instanceof PiggybackObjectOutputStream && ((PiggybackObjectOutputStream)objectOutputStream).getMarshaller() != null) {
            this.marshal(((PiggybackObjectOutputStream)objectOutputStream).getMarshaller());
        }
        object = this.mCustomSerialized ? this.mSerializedResponse : (Object)this.mResponse;
        objectOutputStream.writeBoolean(this.mCustomSerialized);
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mCustomSerialized = objectInputStream.readBoolean();
        if (this.mCustomSerialized) {
            if (!(objectInputStream instanceof PiggybackInputStream)) {
                throw new IOException();
            }
            this.mSerializedResponse = (byte[])objectInputStream.readObject();
        } else {
            this.mResponse = objectInputStream.readObject();
        }
    }
}

