/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.JboException;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboUnexpectedException;

public class PiggybackClsCheckWrapper
implements Serializable {
    static final long serialVersionUID = 2490607987755373002L;
    private Object mToWrap;
    private String mClassName;
    private byte[] mContent;
    private JboException mException;

    public PiggybackClsCheckWrapper(Object object) {
        this.mToWrap = object;
        this.mClassName = object.getClass().getName();
        this.mContent = null;
    }

    public Object getInnerObject() {
        if (this.mException != null) {
            throw this.mException;
        }
        return this.mToWrap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.mClassName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream2.writeObject(this.mToWrap);
        objectOutputStream2.flush();
        this.mContent = byteArrayOutputStream.toByteArray();
        objectOutputStream2.close();
        byteArrayOutputStream.close();
        objectOutputStream.writeObject(this.mContent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mToWrap = null;
        this.mClassName = objectInputStream.readUTF();
        this.mContent = (byte[])objectInputStream.readObject();
        this.mException = null;
        try {
            JBOClass.forName(this.mClassName);
        }
        catch (Exception exception) {
            this.mException = new JboUnexpectedException("JBO-28303: Error while deserializing object.  Cannot find/load class " + this.mClassName + ".  Root exception " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
        }
        if (this.mException == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mContent);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
            try {
                this.mToWrap = objectInputStream2.readObject();
            }
            catch (Exception exception) {
                this.mException = new JboUnexpectedException("JBO-28304: Error while deserializing object.  Deserialization problem for an instance of " + this.mClassName + ".  Root exception " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
            }
            objectInputStream2.close();
            byteArrayInputStream.close();
        }
    }
}

