/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.HashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyManager;

public class JboNameUtil {
    private static int mInstanceCount = 0;
    public static final char INNER_CLASS_DESIGNATOR = '$';
    public static final String DCX_EXTENSION = ".dcx";
    static HashMap rsrvedJavaWords = null;
    static HashMap rsrvedSQLWords = null;
    static boolean rsrvedWordsInit = false;

    public static boolean isNameValid(String string) {
        return JboNameUtil.isNameValid(string, 0, string.length(), false);
    }

    public static boolean isNameValid(String string, int n, int n2, boolean bl) {
        if (string == null || n2 == 0) {
            return false;
        }
        char c = string.charAt(n);
        if (bl) {
            char c2 = string.charAt(n + n2 - 1);
            if (Character.isSpace(c) || Character.isSpace(c2)) {
                string = string.substring(n, n + n2).trim();
                n = 0;
                n2 = string.length();
                c = string.charAt(n);
            }
        }
        if (!Character.isJavaIdentifierStart(c) || c == '$') {
            return false;
        }
        int n3 = n + n2;
        int n4 = n + 1;
        while (n4 < n3) {
            c = string.charAt(n4);
            if (!Character.isJavaIdentifierPart(c) || c == '$') {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean isAttributeNameValid(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        if (!Character.isJavaIdentifierStart(c) || c == '$') {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = stringBuffer.charAt(n2);
            if (!Character.isJavaIdentifierPart(c) || c == '$') {
                if (c == '$') {
                    if (n2 == n - 1 && (string.equals("SYS_NC_OID$") || string.equals("REF$"))) {
                        return true;
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ERROR:Name invalid. Retry after removing the $ symbol from :" + string);
                    }
                    return PropertyManager.is323Compatible();
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isFullNameValid(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 > 0) {
            if (!JboNameUtil.isNameValid(string, n, n2 - n, true)) {
                return false;
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return JboNameUtil.isNameValid(string, n, string.length() - n, true);
    }

    public static boolean isFlattenedName(String string) {
        if (string == null) {
            return true;
        }
        return string.indexOf(46) == -1;
    }

    public static String flattenName(String string) {
        return string.replace('.', '_');
    }

    public static String unflattenName(String string) {
        return string.replace('_', '.');
    }

    public static String shortenDefName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.endsWith("Def")) {
            string2 = string.substring(0, string.length() - new String("Def").length());
        }
        return string2;
    }

    public static String lengthenDefName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (!string.endsWith("Def")) {
            string2 = string2 + "Def";
        }
        return string2;
    }

    public static String getInstNameFromClassName(String string) {
        String string2 = JboNameUtil.getLastPartOfName(string);
        String string3 = JboNameUtil.flattenName(string2);
        String string4 = string3 + "_" + mInstanceCount++;
        return string4.replace('$', 'a');
    }

    public static String getInstNameFromDefName(String string) {
        String string2 = JboNameUtil.shortenDefName(string);
        String string3 = JboNameUtil.flattenName(string2);
        String string4 = string3 + "_" + mInstanceCount++;
        return string4.replace('$', 'a');
    }

    public static String getDocumentName(String string) {
        String string2 = ".xml";
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(1 + n + ".xml".length());
        stringBuffer.append('/');
        stringBuffer.append(string);
        if (string.endsWith(".xml") || string.endsWith(".jpx") || string.endsWith(".cpx") || string.endsWith(DCX_EXTENSION) || string.endsWith(".ccx")) {
            n = string.lastIndexOf(46);
        } else {
            stringBuffer.append(".xml");
        }
        int n2 = 1;
        while (n2 <= n) {
            if (stringBuffer.charAt(n2) == '.') {
                stringBuffer.setCharAt(n2, '/');
            }
            ++n2;
        }
        if (stringBuffer.charAt(1) == '/') {
            stringBuffer.deleteCharAt(0);
        }
        return new String(stringBuffer);
    }

    public static String getFirstPartOfName(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return string.trim();
        }
        return string.substring(0, n).trim();
    }

    public static String getRemainingPartOfName(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1).trim();
    }

    public static String getLastPartOfName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string.trim();
        }
        return string.substring(n + 1).trim();
    }

    public static String getContainerPartOfName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n).trim();
    }

    public static String getDefNameFromInstName(String string) {
        String string2;
        String string3 = string2 = JboNameUtil.unflattenName(string);
        if (string2 == null) {
            return null;
        }
        if (string2.lastIndexOf(46) != -1) {
            String string4 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
            try {
                Integer n = Integer.decode(string4);
            }
            catch (Exception exception) {
                String string5 = string3;
                return string5;
            }
            string3 = string2.substring(0, string2.lastIndexOf(46));
        }
        return string3;
    }

    public static String getInfoNameFromJNDIName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length());
        }
        return JboNameUtil.unflattenName(string2);
    }

    private static String getDefNameFromJNDIName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length());
        }
        return JboNameUtil.lengthenDefName(JboNameUtil.unflattenName(string2));
    }

    public static String getJNDINameFromDefName(Hashtable hashtable, String string) {
        if (string == null) {
            return null;
        }
        String string2 = JboEnvUtil.getApplicationName(hashtable) + "/" + JboNameUtil.shortenDefName(JboNameUtil.flattenName(string));
        return string2;
    }

    public static String getXMLNameFromDefName(String string) {
        String string2 = JboNameUtil.shortenDefName(string);
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(n);
        int n2 = string2.lastIndexOf(46, n - 1);
        return string2.substring(n2 + 1, n) + string3;
    }

    public static Object getDefObject(String string) throws Exception {
        Class clazz = null;
        Method method = null;
        clazz = JBOClass.forName(string);
        method = clazz.getMethod("getDefObject", new Class[0]);
        return method.invoke(null, new Object[0]);
    }

    private static void initReservedWords() {
        rsrvedJavaWords = new HashMap();
        rsrvedSQLWords = new HashMap();
        rsrvedSQLWords.put((Object)"ALTER", (Object)"SQL");
        rsrvedSQLWords.put((Object)"AND", (Object)"SQL");
        rsrvedSQLWords.put((Object)"ARRAY", (Object)"SQL");
        rsrvedSQLWords.put((Object)"AVG", (Object)"SQL");
        rsrvedSQLWords.put((Object)"BEGIN", (Object)"SQL");
        rsrvedSQLWords.put((Object)"BETWEEN", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CASCADE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CAST", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CHECK", (Object)"SQL");
        rsrvedSQLWords.put((Object)"COALESCE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"COLUMN", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CONSTRIANT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CONTAINS", (Object)"SQL");
        rsrvedSQLWords.put((Object)"COUNT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"CREATE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"DEFAULT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"DELETE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"DESC", (Object)"SQL");
        rsrvedSQLWords.put((Object)"DO", (Object)"SQL");
        rsrvedSQLWords.put((Object)"DROP", (Object)"SQL");
        rsrvedSQLWords.put((Object)"ELSE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"END", (Object)"SQL");
        rsrvedSQLWords.put((Object)"EXISTS", (Object)"SQL");
        rsrvedSQLWords.put((Object)"FROM", (Object)"SQL");
        rsrvedSQLWords.put((Object)"FUNCTION", (Object)"SQL");
        rsrvedSQLWords.put((Object)"GROUPBY", (Object)"SQL");
        rsrvedSQLWords.put((Object)"GROUP", (Object)"SQL");
        rsrvedSQLWords.put((Object)"INSERT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"IF", (Object)"SQL");
        rsrvedSQLWords.put((Object)"IS", (Object)"SQL");
        rsrvedSQLWords.put((Object)"KEY", (Object)"SQL");
        rsrvedSQLWords.put((Object)"LIKE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"MAX", (Object)"SQL");
        rsrvedSQLWords.put((Object)"MIN", (Object)"SQL");
        rsrvedSQLWords.put((Object)"NOT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"SQL", (Object)"SQL");
        rsrvedSQLWords.put((Object)"NULLIF", (Object)"SQL");
        rsrvedSQLWords.put((Object)"OR", (Object)"SQL");
        rsrvedSQLWords.put((Object)"ORDERBY", (Object)"SQL");
        rsrvedSQLWords.put((Object)"OVERLAPS", (Object)"SQL");
        rsrvedSQLWords.put((Object)"PRIMARY", (Object)"SQL");
        rsrvedSQLWords.put((Object)"REFERENCES", (Object)"SQL");
        rsrvedSQLWords.put((Object)"ROWID", (Object)"SQL");
        rsrvedSQLWords.put((Object)"SELECT", (Object)"SQL");
        rsrvedSQLWords.put((Object)"SUM", (Object)"SQL");
        rsrvedSQLWords.put((Object)"TABLE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"THEN", (Object)"SQL");
        rsrvedSQLWords.put((Object)"UNION", (Object)"SQL");
        rsrvedSQLWords.put((Object)"UNIQUE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"UPDATE", (Object)"SQL");
        rsrvedSQLWords.put((Object)"USER", (Object)"SQL");
        rsrvedSQLWords.put((Object)"VIEW", (Object)"SQL");
        rsrvedSQLWords.put((Object)"WHERE", (Object)"SQL");
        rsrvedJavaWords.put((Object)"abstract", (Object)"java");
        rsrvedJavaWords.put((Object)"boolean", (Object)"java");
        rsrvedJavaWords.put((Object)"break", (Object)"java");
        rsrvedJavaWords.put((Object)"byte", (Object)"java");
        rsrvedJavaWords.put((Object)"byvalue", (Object)"java");
        rsrvedJavaWords.put((Object)"case", (Object)"java");
        rsrvedJavaWords.put((Object)"cast", (Object)"java");
        rsrvedJavaWords.put((Object)"catch", (Object)"java");
        rsrvedJavaWords.put((Object)"char", (Object)"java");
        rsrvedJavaWords.put((Object)"class", (Object)"java");
        rsrvedJavaWords.put((Object)"const", (Object)"java");
        rsrvedJavaWords.put((Object)"continue", (Object)"java");
        rsrvedJavaWords.put((Object)"default", (Object)"java");
        rsrvedJavaWords.put((Object)"do", (Object)"java");
        rsrvedJavaWords.put((Object)"double", (Object)"java");
        rsrvedJavaWords.put((Object)"else", (Object)"java");
        rsrvedJavaWords.put((Object)"extends", (Object)"java");
        rsrvedJavaWords.put((Object)"false", (Object)"java");
        rsrvedJavaWords.put((Object)"final", (Object)"java");
        rsrvedJavaWords.put((Object)"finally", (Object)"java");
        rsrvedJavaWords.put((Object)"float", (Object)"java");
        rsrvedJavaWords.put((Object)"for", (Object)"java");
        rsrvedJavaWords.put((Object)"future", (Object)"java");
        rsrvedJavaWords.put((Object)"generic", (Object)"java");
        rsrvedJavaWords.put((Object)"goto", (Object)"java");
        rsrvedJavaWords.put((Object)"if", (Object)"java");
        rsrvedJavaWords.put((Object)"implements", (Object)"java");
        rsrvedJavaWords.put((Object)"import", (Object)"java");
        rsrvedJavaWords.put((Object)"inner", (Object)"java");
        rsrvedJavaWords.put((Object)"instanceof", (Object)"java");
        rsrvedJavaWords.put((Object)"int", (Object)"java");
        rsrvedJavaWords.put((Object)"interface", (Object)"java");
        rsrvedJavaWords.put((Object)"long", (Object)"java");
        rsrvedJavaWords.put((Object)"native", (Object)"java");
        rsrvedJavaWords.put((Object)"new", (Object)"java");
        rsrvedJavaWords.put((Object)"java", (Object)"java");
        rsrvedJavaWords.put((Object)"operator", (Object)"java");
        rsrvedJavaWords.put((Object)"outer", (Object)"java");
        rsrvedJavaWords.put((Object)"package", (Object)"java");
        rsrvedJavaWords.put((Object)"private", (Object)"java");
        rsrvedJavaWords.put((Object)"protected", (Object)"java");
        rsrvedJavaWords.put((Object)"public", (Object)"java");
        rsrvedJavaWords.put((Object)"rest", (Object)"java");
        rsrvedJavaWords.put((Object)"return", (Object)"java");
        rsrvedJavaWords.put((Object)"short", (Object)"java");
        rsrvedJavaWords.put((Object)"static", (Object)"java");
        rsrvedJavaWords.put((Object)"super", (Object)"java");
        rsrvedJavaWords.put((Object)"switch", (Object)"java");
        rsrvedJavaWords.put((Object)"synchronized", (Object)"java");
        rsrvedJavaWords.put((Object)"this", (Object)"java");
        rsrvedJavaWords.put((Object)"throw", (Object)"java");
        rsrvedJavaWords.put((Object)"throws", (Object)"java");
        rsrvedJavaWords.put((Object)"transient", (Object)"java");
        rsrvedJavaWords.put((Object)"true", (Object)"java");
        rsrvedJavaWords.put((Object)"try", (Object)"java");
        rsrvedJavaWords.put((Object)"var", (Object)"java");
        rsrvedJavaWords.put((Object)"void", (Object)"java");
        rsrvedJavaWords.put((Object)"volatile", (Object)"java");
        rsrvedJavaWords.put((Object)"while", (Object)"java");
        rsrvedJavaWords.put((Object)"clone", (Object)"java method");
        rsrvedJavaWords.put((Object)"equals", (Object)"java method");
        rsrvedJavaWords.put((Object)"finalize", (Object)"java method");
        rsrvedJavaWords.put((Object)"getClass", (Object)"java method");
        rsrvedJavaWords.put((Object)"hashCode", (Object)"java method");
        rsrvedJavaWords.put((Object)"notify", (Object)"java method");
        rsrvedJavaWords.put((Object)"notifyAll", (Object)"java method");
        rsrvedJavaWords.put((Object)"toString", (Object)"java method");
        rsrvedJavaWords.put((Object)"wait", (Object)"java method");
        rsrvedWordsInit = true;
    }

    public static boolean isSQLReservedWord(String string) {
        if (!rsrvedWordsInit) {
            JboNameUtil.initReservedWords();
        }
        String string2 = new String(string);
        return rsrvedSQLWords.containsKey((Object)string2.toUpperCase());
    }

    public static boolean isJavaReservedWord(String string, boolean bl) {
        if (!rsrvedWordsInit) {
            JboNameUtil.initReservedWords();
        }
        if (bl) {
            return rsrvedJavaWords.containsKey((Object)string);
        }
        String string2 = new String(string);
        return rsrvedJavaWords.containsKey((Object)string2) || rsrvedJavaWords.containsKey((Object)string2.toUpperCase()) || rsrvedJavaWords.containsKey((Object)string2.toLowerCase());
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        return JboNameUtil.findMethod(clazz, string, classArray, clazz2, false);
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray, Class clazz2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (clazz.equals(clazz2)) {
            return null;
        }
        Method method = null;
        while (clazz != null && method == null) {
            int n;
            block6: {
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block6;
                    Diagnostic.println("Could not find method:" + string + " in " + clazz.getName() + " - " + exception.getMessage());
                }
            }
            if (method != null && (!Modifier.isStatic(n = method.getModifiers()) || bl) && Modifier.isPublic(n)) {
                return method;
            }
            if ((clazz = clazz.getSuperclass()) == null || clazz2 == null || clazz != clazz2) continue;
            clazz = null;
        }
        return null;
    }

    public static Constructor findConstructor(Class clazz, Class[] classArray) {
        int n;
        Constructor constructor;
        block3: {
            constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(classArray);
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block3;
                Diagnostic.println("Could not find constructor in " + clazz.getName() + " - " + exception.getMessage());
            }
        }
        if (constructor != null && Modifier.isPublic(n = constructor.getModifiers())) {
            return constructor;
        }
        return null;
    }

    public static String toXMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 39;
        int n2 = 34;
        int n3 = 38;
        int n4 = 60;
        int n5 = 62;
        int n6 = 13;
        int n7 = 10;
        int n8 = 0;
        while (n8 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n8);
            switch (c) {
                case '\r': {
                    stringBuffer2.append('\n');
                    break;
                }
                case '&': {
                    stringBuffer2.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer2.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer2.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer2.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer2.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
            ++n8;
        }
        return stringBuffer2.toString();
    }

    public static boolean xmlValidateTagName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        if (Character.isLetter(c) || c == '_' || c == ':') {
            int n = 1;
            while (n < stringBuffer.length()) {
                c = stringBuffer.charAt(n);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                    return false;
                }
                ++n;
            }
        } else {
            return false;
        }
        return true;
    }

    public static String getLocaleName(LocaleContext localeContext, String string) {
        if (localeContext == null) {
            localeContext = new DefLocaleContext();
        }
        String string2 = null;
        string2 = localeContext instanceof DefLocaleContext ? ((DefLocaleContext)localeContext).getISO3Language() : localeContext.getLocale().getISO3Language();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        stringBuffer.append(string).append('_').append(string2).append('_').append(localeContext.getLocale().getCountry());
        return stringBuffer.toString();
    }

    public static String stripToValidName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        char c = stringBuffer2.charAt(0);
        if (!(Character.isJavaIdentifierStart(c) ^ true) && c != '$') {
            stringBuffer.append(c);
        }
        int n2 = 1;
        while (n2 < n) {
            c = stringBuffer2.charAt(n2);
            if (!(Character.isJavaIdentifierPart(c) ^ true) && c != '$') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String fastTrim(String string) {
        int n;
        if (string != null && (n = string.length()) > 0 && (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(n - 1)))) {
            return string.trim();
        }
        return string;
    }

    public static String toUpperCaseFirstChar(String string) {
        return new StringBuffer(string.length()).append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String getDefaultBindingName(String string) {
        String string2 = "Bind_";
        StringBuffer stringBuffer = new StringBuffer(string2.length() + string.length());
        return stringBuffer.append(string2).append(string).toString();
    }
}

