/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.PersistenceException;
import oracle.jbo.SortCriteria;
import oracle.jbo.SortCriteriaImpl;
import oracle.jbo.Version;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.StringManager;

public class JboEnvUtil {
    public static String USE_CLIENT_SERVICE = "UseClientService";
    public static String APPLICATION_NAME = "ApplicationName";
    public static String JVM_ID = "RuntimeId";
    public static String ORACLE_SID = "Sid";
    public static String IAS_EM_DIAGNOSTIC_DELIM = ",";
    public static int DEFAULT_CONNECTION_MODE = 2;
    public static int NULL_CONNECTION_MODE = -1;
    public static boolean DEFAULT_USE_CLIENT_SERVICE = true;
    public static String DEFAULT_APPLICATION_NAME = "";
    private static String DEFAULT_CONNECTION_PORT = "-1";
    public static String DEFAULT_ORACLE_SID = "ORCL";
    private static String mDefaultHost = null;
    private static String mDefaultRuntimeId = null;
    public static String SESSION_ID = "SessionId";
    private static int mSessionId = 0;
    private static boolean _isAppletCalled = false;
    private static boolean _isAppletValue = false;
    private static boolean _inJServerCalled = false;
    private static boolean _inJServerValue = false;
    private static boolean _inOC4JCalled = false;
    private static boolean _inOC4JValue = false;
    private static boolean _inJava12Called = false;
    private static boolean _inJava12Value = false;
    private static boolean permissionsChecked = false;
    private static /* synthetic */ Class class$oracle$jbo$common$PropertyManager;
    private static /* synthetic */ Class class$oracle$jbo$common$CommonMessageBundle;

    public static String getDeployPlatform(Hashtable hashtable) {
        if (hashtable != null) {
            return (String)hashtable.get(PropertyMetadata.DEPLOY_PLATFORM.getName());
        }
        return null;
    }

    public static boolean isClient(Hashtable hashtable) {
        return JboEnvUtil.getDeployPlatform(hashtable).equals("LOCAL") ^ true;
    }

    public static boolean isApplet() {
        if (_isAppletCalled) {
            return _isAppletValue;
        }
        boolean bl = false;
        if (JboEnvUtil.inJServer()) {
            bl = false;
        } else {
            try {
                System.getProperty("jbo.test.property");
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        _isAppletCalled = true;
        _isAppletValue = bl;
        return _isAppletValue;
    }

    public static String getProperty(String string) {
        return JboEnvUtil.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        String string3 = null;
        string3 = MOMProperties.getProperty(string, string2);
        if (string3 == null) {
            try {
                string3 = System.getProperty(string, string2);
            }
            catch (Exception exception) {
                string3 = null;
            }
            if (string3 != null && Diagnostic.isOn()) {
                Diagnostic.println("WARNING: accessed system property for " + string + "= '" + string3 + "'");
            }
        }
        if (string3 != null && string3.equals("null")) {
            string3 = null;
        }
        return string3;
    }

    public static boolean getPropertyAsBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        try {
            String string2 = JboEnvUtil.getProperty(string);
            if (string2 != null) {
                if (string2.toUpperCase().equals("TRUE")) {
                    bl2 = true;
                } else if (string2.toUpperCase().equals("FALSE")) {
                    bl2 = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public static int getPropertyAsInt(String string, int n) {
        Integer n2 = JboEnvUtil.getInteger(JboEnvUtil.getProperty(string));
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public static void setSystemProperty(String string, String string2) {
        block3: {
            try {
                System.setProperty(string, string2);
            }
            catch (SecurityException securityException) {
                if (!Diagnostic.isOn()) break block3;
                Class clazz = class$oracle$jbo$common$CommonMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$CommonMessageBundle = JboEnvUtil.class$("oracle.jbo.common.CommonMessageBundle");
                }
                String string3 = StringManager.getString(clazz.getName(), "12300", null, new String[]{string, string2});
                Diagnostic.println(string3);
            }
        }
    }

    public static String getDefaultHost() {
        if (mDefaultHost == null) {
            try {
                mDefaultHost = InetAddress.getLocalHost().getHostName().toUpperCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mDefaultHost;
    }

    public static String getHostName(Hashtable hashtable) {
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get(PropertyMetadata.HOST_NAME.getName());
        }
        return string;
    }

    public static String getDefaultRuntimeId() {
        if (mDefaultRuntimeId == null) {
            mDefaultRuntimeId = "" + Runtime.getRuntime();
        }
        return mDefaultRuntimeId;
    }

    public static String getRuntimeId(Hashtable hashtable) {
        if (hashtable == null) {
            return JboEnvUtil.getDefaultRuntimeId();
        }
        String string = (String)hashtable.get(JVM_ID);
        if (JboEnvUtil.isEmptyString(string)) {
            return JboEnvUtil.getDefaultRuntimeId();
        }
        return string;
    }

    public static int getConnectionMode(Hashtable hashtable) {
        if (hashtable == null) {
            return DEFAULT_CONNECTION_MODE;
        }
        Integer n = JboEnvUtil.getInteger(hashtable.get(PropertyMetadata.CONNECTION_MODE.getName()));
        if (n == null) {
            return DEFAULT_CONNECTION_MODE;
        }
        return n;
    }

    public static String getDefaultSessionId() {
        return new String("Session" + mSessionId++);
    }

    public static String getSessionId(Hashtable hashtable) {
        if (hashtable == null) {
            return JboEnvUtil.getDefaultSessionId();
        }
        String string = (String)hashtable.get(SESSION_ID);
        if (JboEnvUtil.isEmptyString(string)) {
            return JboEnvUtil.getDefaultSessionId();
        }
        return string;
    }

    public static boolean getUseClientService(Hashtable hashtable) {
        if (hashtable == null) {
            return DEFAULT_USE_CLIENT_SERVICE;
        }
        String string = (String)hashtable.get(USE_CLIENT_SERVICE);
        if (JboEnvUtil.isEmptyString(string)) {
            return DEFAULT_USE_CLIENT_SERVICE;
        }
        return (string.equals("false") || string.equals("FALSE") || string.equals("no") || string.equals("NO")) ^ true;
    }

    public static int getConnectionPort(Hashtable hashtable) {
        if (hashtable == null) {
            return JboEnvUtil.getInteger(DEFAULT_CONNECTION_PORT);
        }
        Object v = hashtable.get(PropertyMetadata.CONNECTION_PORT.getName());
        if (v == null) {
            return JboEnvUtil.getInteger(DEFAULT_CONNECTION_PORT);
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            String string = (String)v;
            if (string.length() <= 0) {
                string = DEFAULT_CONNECTION_PORT;
            }
            return JboEnvUtil.getInteger(string);
        }
        throw new IllegalArgumentException(v.getClass().getName() + ":" + v);
    }

    public static String getApplicationName(Hashtable hashtable) {
        if (hashtable == null) {
            return DEFAULT_APPLICATION_NAME;
        }
        String string = (String)hashtable.get(APPLICATION_NAME);
        if (JboEnvUtil.isEmptyString(string)) {
            return DEFAULT_APPLICATION_NAME;
        }
        return string;
    }

    public static boolean isSameHost(Hashtable hashtable) {
        return JboEnvUtil.getHostName(hashtable).equals(JboEnvUtil.getDefaultHost());
    }

    public static boolean isSameVM(Hashtable hashtable) {
        return JboEnvUtil.isSameHost(hashtable) && JboEnvUtil.getRuntimeId(hashtable).equals(JboEnvUtil.getDefaultRuntimeId());
    }

    public static Applet getApplet(Hashtable hashtable) {
        Object v = hashtable.get("java.naming.applet");
        if (v != null && v instanceof Applet) {
            return (Applet)v;
        }
        return null;
    }

    public static String getApplicationPath(Hashtable hashtable) {
        String string = (String)hashtable.get(PropertyMetadata.APPLICATION_PATH.getName());
        if (JboEnvUtil.isEmptyString(string)) {
            return PropertyMetadata.APPLICATION_PATH.getDefault();
        }
        return string;
    }

    public static String getOracleSid(Hashtable hashtable) {
        String string = (String)hashtable.get(ORACLE_SID);
        if (JboEnvUtil.isEmptyString(string)) {
            return DEFAULT_ORACLE_SID;
        }
        return string;
    }

    public static boolean inJServer() {
        if (_inJServerCalled) {
            return _inJServerValue;
        }
        boolean bl = false;
        try {
            if (System.getProperty("oracle.jserver.version") != null) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        _inJServerCalled = true;
        _inJServerValue = bl;
        return _inJServerValue;
    }

    public static boolean inOC4J() {
        if (_inOC4JCalled) {
            return _inOC4JValue;
        }
        boolean bl = false;
        String string = null;
        try {
            string = System.getProperty("jbo.server.in_oc4j");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string != null) {
            bl = Boolean.valueOf(string);
        } else {
            try {
                String string2 = System.getProperty("oracle.j2ee.container.version");
                bl = string2 != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _inOC4JCalled = true;
        _inOC4JValue = bl;
        return _inOC4JValue;
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.equals("");
    }

    public static Integer getInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return new Integer(Integer.parseInt((String)object));
        }
        return null;
    }

    public static boolean inJava12() {
        if (_inJava12Called) {
            return _inJava12Value;
        }
        boolean bl = false;
        try {
            String string = System.getProperty("java.version");
            if (string != null) {
                bl = string.startsWith("1.1") ^ true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _inJava12Called = true;
        _inJava12Value = bl;
        return _inJava12Value;
    }

    public static void checkJServerPermissions() {
        if (permissionsChecked) {
            return;
        }
        permissionsChecked = true;
        if (JboEnvUtil.inJServer()) {
            InputStream inputStream;
            Properties properties = new Properties();
            Class clazz = class$oracle$jbo$common$PropertyManager;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$PropertyManager = JboEnvUtil.class$("oracle.jbo.common.PropertyManager");
            }
            if ((inputStream = clazz.getResourceAsStream("/oracle/jbo/BC4J.properties")) != null) {
                try {
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    PersistenceException persistenceException = new PersistenceException("26026", new Object[]{"/oracle/jbo/BC4J.properties"});
                    persistenceException.addToDetails(iOException);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("PropertyManager: Error loading properties from /oracle/jbo/BC4J.properties");
                        Diagnostic.println("Exception class is " + iOException.getClass().getName());
                        Diagnostic.printStackTrace(persistenceException);
                    }
                    throw persistenceException;
                }
            }
        }
    }

    public static Vector convertArrayListToVector(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            vector.addElement(arrayList.get(n));
            ++n;
        }
        return vector;
    }

    public static ArrayList convertVectorToArrayList(Vector vector) {
        if (vector == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(vector.size());
        int n = 0;
        while (n < vector.size()) {
            arrayList.add(vector.elementAt(n));
            ++n;
        }
        return arrayList;
    }

    public static Hashtable convertHashMapToHashTable(HashMap hashMap) {
        if (hashMap == null) {
            return null;
        }
        int n = hashMap.size();
        if (n == 0) {
            n = 1;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(n);
        com.sun.java.util.collections.Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = hashMap.get(object);
            if (object2 == null) continue;
            hashtable.put(object, object2);
        }
        return hashtable;
    }

    public static HashMap convertHashTableToHashMap(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        HashMap hashMap = new HashMap(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashMap.put(k, hashtable.get(k));
        }
        return hashMap;
    }

    public static Iterator javaIterator(com.sun.java.util.collections.Iterator iterator) {
        return new 1myIterator(iterator);
    }

    public static void setSizeInArrayList(ArrayList arrayList, int n) {
        if (n > arrayList.size()) {
            int n2 = arrayList.size();
            while (n2 < n) {
                arrayList.add(null);
                ++n2;
            }
        } else {
            int n3 = arrayList.size() - 1;
            while (n3 >= n) {
                arrayList.remove(n3);
                --n3;
            }
        }
    }

    public static void setSizeInArrayList(java.util.ArrayList arrayList, int n) {
        if (n > arrayList.size()) {
            int n2 = arrayList.size();
            while (n2 < n) {
                arrayList.add(null);
                ++n2;
            }
        } else {
            int n3 = arrayList.size() - 1;
            while (n3 >= n) {
                arrayList.remove(n3);
                --n3;
            }
        }
    }

    public static boolean isUsing32IDE() {
        return Version.isUsing32IDE();
    }

    public static boolean useDefaultContext(Hashtable hashtable) {
        boolean bl = false;
        Object v = hashtable.get("jbo.jndi.use_default_context");
        if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v instanceof String) {
            bl = Boolean.valueOf((String)v);
        }
        return bl;
    }

    public static boolean isAuthenticateUser(Hashtable hashtable) {
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        if (securityContext.isAuthenticated()) {
            return false;
        }
        if (JboEnvUtil.isUserAuthenticated(hashtable)) {
            return false;
        }
        try {
            Hashtable hashtable2 = securityContext.getEnvironment();
            Object v = hashtable2.get("oracle.adf.security.authentication.require");
            if (v != null && v.equals("true")) {
                boolean bl = true;
                return bl;
            }
            v = hashtable2.get("oracle.adf.security.authorization.enforce");
            if (v != null && v.equals("true")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        String string = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_ENFORCE.pName);
        return string != null && ("Test".equals(string) || "Must".equals(string) || "Auth".equals(string));
    }

    public static boolean isUserAuthenticated(Hashtable hashtable) {
        String string;
        String string2 = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_ENFORCE.pName);
        return string2 != null && ("Test".equals(string2) || "Must".equals(string2) || "Auth".equals(string2)) && "true".equals(string = (String)hashtable.get("jbo.security.authorized"));
    }

    public static boolean isCheckPermission(Hashtable hashtable) {
        String string = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_ENFORCE.pName);
        return "true".equals(hashtable.get("jbo.security.authorized")) && "Auth".equals(string);
    }

    public static String getBC4JTempDir(ApplicationModule applicationModule) {
        String string = null;
        if (applicationModule != null) {
            string = (String)applicationModule.getSession().getEnvironment().get("jbo.tmpdir");
        }
        if (!(string != null && string.length() != 0 || (string = PropertyMetadata.TEMPORARY_FILES_HOME.getProperty()) != null && string.length() != 0)) {
            string = System.getProperty("user.dir") + File.separatorChar;
        }
        MOMProperties.setProperty("jbo.tmpdir", string);
        return string;
    }

    public static SortCriteria[] parseSortBy(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        SortCriteria[] sortCriteriaArray = new SortCriteria[n];
        int n2 = 0;
        while (n2 < n) {
            SortCriteriaImpl sortCriteriaImpl;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            int n3 = stringTokenizer2.countTokens();
            if (n3 > 2 || n3 == 0) {
                throw new IllegalArgumentException("SortBy spec: " + string);
            }
            String string3 = stringTokenizer2.nextToken();
            String string4 = null;
            boolean bl = false;
            if (n3 > 1) {
                string4 = stringTokenizer2.nextToken();
            }
            if (string4 != null && string4.toUpperCase().startsWith("DESC")) {
                bl = true;
            }
            if (Character.isDigit(string3.charAt(0))) {
                int n4 = Integer.valueOf(string3);
                sortCriteriaImpl = new SortCriteriaImpl(n4, bl);
            } else {
                String string5 = string3;
                sortCriteriaImpl = new SortCriteriaImpl(string5, bl);
            }
            sortCriteriaArray[n2] = sortCriteriaImpl;
            ++n2;
        }
        return sortCriteriaArray;
    }

    public static void applyVOSortCriteria(ViewObject viewObject, SortCriteria[] sortCriteriaArray) {
        if (sortCriteriaArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < sortCriteriaArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                AttributeDef attributeDef = viewObject.findAttributeDef(sortCriteriaArray[n].getAttributeName());
                stringBuffer.append(attributeDef.getColumnNameForQuery());
                if (sortCriteriaArray[n].isDescending()) {
                    stringBuffer.append(" DESC");
                }
                ++n;
            }
            viewObject.setOrderByClause(stringBuffer.toString());
        } else {
            viewObject.setOrderByClause(null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1myIterator
    implements Iterator {
        com.sun.java.util.collections.Iterator myIter;

        1myIterator(com.sun.java.util.collections.Iterator iterator) {
            this.myIter = iterator;
        }

        public boolean hasNext() {
            return this.myIter.hasNext();
        }

        public Object next() {
            return this.myIter.next();
        }

        public void remove() {
            this.myIter.remove();
        }
    }
}

