/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public final class GraphicsUtils {
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 1, 1);
    protected static final Component component = new 1();
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static Hashtable imageCache = new Hashtable();

    private GraphicsUtils() {
    }

    public static void centerWindowOnScreen(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        window.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static void drawHighlightBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(bl ? color2 : color);
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(bl ? color : color2);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 2, n4 - 1);
        graphics.translate(-n, -n2);
        graphics.setColor(color3);
    }

    public static Insets getHighlightBorderInsets() {
        return HIGHLIGHT_INSETS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImageIcon(Image image) {
        if (image == null) {
            return null;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return new ImageIcon(image);
    }

    public static Point getPopupMenuShowPoint(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Point point = component.getLocationOnScreen();
        Point point2 = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
        point2.translate(-point.x, -point.y);
        return point2;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu jPopupMenu, int n, int n2) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        Point point = new Point(n + dimension.width, n2 + dimension.height);
        Dimension dimension2 = jPopupMenu.getToolkit().getScreenSize();
        dimension2.height -= 32;
        int n3 = 0;
        if (point.x > dimension2.width) {
            n3 = -dimension.width;
        }
        int n4 = 0;
        if (point.y > dimension2.height) {
            n4 = dimension2.height - point.y;
        }
        return new Point(n + n3, n2 + n4);
    }

    public static void centerWindowOnComponent(Window window, Component component) {
        if (component == null || !component.isShowing()) {
            GraphicsUtils.centerWindowOnScreen(window);
            return;
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 2;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n + dimension2.width > dimension3.width) {
            n = dimension3.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 + dimension2.height > dimension3.height) {
            n2 = dimension3.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }

    public static boolean isAncestorOfFocusedComponent(Component component) {
        if (component.hasFocus()) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (GraphicsUtils.isAncestorOfFocusedComponent(component2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Component focusComponentOrChild(Component component) {
        if (component.isEnabled() || component.isVisible()) {
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (jComponent.isFocusTraversable()) {
                    jComponent.requestFocus();
                    return jComponent;
                }
                int n = jComponent.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = jComponent.getComponent(n2);
                    Component component3 = GraphicsUtils.focusComponentOrChild(component2);
                    if (component3 != null) {
                        return component3;
                    }
                    ++n2;
                }
            } else {
                component.requestFocus();
                return component;
            }
        }
        return null;
    }

    public static Image loadFromResource(String string, Class clazz) {
        try {
            URL uRL = clazz.getResource(string);
            if (uRL == null) {
                Image image = null;
                return image;
            }
            Image image = (Image)imageCache.get(uRL.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                imageCache.put(uRL.toString(), image);
            }
            Image image2 = image;
            return image2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final class 1
    extends Component {
    }
}

