/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.DiagnosticFactory;

public final class DebugDiagnostic {
    private static String s_debugPrefix;

    static {
        try {
            String string = System.getProperty("jbo.showdebugwarningbanner", "true");
            if (string.equalsIgnoreCase("true")) {
                System.out.println("**************************************************************************");
                System.out.println("*** WARNING: Oracle BC4J debug build executing - do not use for timing ***");
                System.out.println("**************************************************************************");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_debugPrefix = DiagnosticFactory.getProperty("jbo.debug.prefix");
    }

    static void printWarning() {
    }

    private DebugDiagnostic() {
    }

    public static void print(String string, int n) {
        ++Diagnostic.s_depthOffset;
        if (Diagnostic.s_firstPrintOnLine) {
            Diagnostic.print(s_debugPrefix + string, n);
        } else {
            Diagnostic.print(string, n);
        }
        --Diagnostic.s_depthOffset;
    }

    public static void print(String string) {
        ++Diagnostic.s_depthOffset;
        --Diagnostic.s_depthOffset;
    }

    public static void println(String string, int n) {
        ++Diagnostic.s_depthOffset;
        Diagnostic.println("", n);
        --Diagnostic.s_depthOffset;
    }

    public static void println(String string) {
        ++Diagnostic.s_depthOffset;
        --Diagnostic.s_depthOffset;
    }

    public static void ASSERT(boolean bl, String string, Object[] objectArray) {
        Diagnostic.ASSERT(bl, s_debugPrefix + string, objectArray);
    }

    public static void ASSERT(boolean bl, String string) {
        Diagnostic.ASSERT(bl, s_debugPrefix + string);
    }

    public static void ASSERT(boolean bl) {
        Diagnostic.ASSERT(bl, s_debugPrefix);
    }

    public static void NULL(String string) {
    }

    public static void setStopOnAssert(boolean bl) {
        Diagnostic.setStopOnAssert(bl);
    }

    public static void printStackTrace() {
        Diagnostic.printStackTrace();
    }

    public static void printStackTrace(Throwable throwable) {
        Diagnostic.printStackTrace(throwable);
    }
}

