/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.util.BitSet;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NoDefException;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.StructureDef;
import oracle.jbo.Transaction;
import oracle.jbo.XMLInterface;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.AttributeDefImpl;
import oracle.jbo.client.remote.ClientViewDef;
import oracle.jbo.client.remote.DetailSet;
import oracle.jbo.client.remote.RowSetIteratorImpl;
import oracle.jbo.client.remote.ViewUsageImpl;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.SvcMsgDataRow;
import oracle.jbo.common.SvcMsgResponseByValueRowSet;
import oracle.jbo.common.SvcMsgResponseException;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.MutableDomainInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.svcmsg.Response;
import oracle.svcmsg.ServiceMessage;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RowImpl
implements DomainOwnerInterface,
Row {
    private int mRowState;
    private Object[] mData;
    private Integer mHandle;
    private BitSet mAttrFlags;
    private int mAttrFlagsCount;
    private RowSetIteratorImpl mRowSetIterator;
    private BitSet mChanged;
    private int mChangedCount;
    private int mRowIndex;
    private int mRangeStart;
    private int mPKChangedCount;
    private Key mServerRowKey;
    private DetailSet mDetailSet;
    private int mCommitSeq;
    private int mNumUnmarshalledAttrs;
    private StructureDef mStructDef;
    boolean mDomainsResolved;
    boolean mAccessorsResolved;
    static final int PS_CREATED = -1;
    static final int PS_NEW = 0;
    static final int PS_CLEAN = 1;
    static final int PS_MODIFIED = 2;
    static final int PS_DELETED = 3;
    static final int PS_DEAD = 4;
    static final int PS_LAZY = 5;
    static final int PS_REMOVED_FROM_COLLECTION = 6;
    static final int PS_REMOVED_AND_RETAINED = 7;
    private static final String CLIENT_DOMAIN_VAL = "1";
    private static final int DEFAULT_NUM_CHANGED_BITS = 4;
    private byte mNewRowState;
    static final int REMOVE_FROM_TABLE = 0;
    static final int REMOVE_FROM_COLLECTION = 1;
    static final int REMOVE_AND_RETAIN = 2;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$domain$MutableDomainInterface;

    private /* synthetic */ void $init$() {
        this.mRowState = 0;
        this.mAttrFlags = new BitSet(4);
        this.mAttrFlagsCount = 0;
        this.mChanged = null;
        this.mChangedCount = 0;
        this.mRowIndex = -1;
        this.mRangeStart = -1;
        this.mPKChangedCount = 0;
        this.mCommitSeq = -1;
        this.mStructDef = null;
        this.mDomainsResolved = false;
        this.mAccessorsResolved = false;
        this.mNewRowState = (byte)127;
    }

    public RowImpl() {
        this.$init$();
    }

    protected void initialize(int n, Object[] objectArray, RowSetIteratorImpl rowSetIteratorImpl, Object object, byte by, int n2, int n3) {
        this.mData = objectArray;
        this.mRowSetIterator = rowSetIteratorImpl;
        this.mHandle = (Integer)object;
        this.mNewRowState = by;
        this.mCommitSeq = this.getApplicationModuleImpl().getCommitSeq();
        this._setState(n, this.mRowSetIterator);
        this.resetChanged();
        this.mPKChangedCount = 0;
        this.mServerRowKey = null;
        this.mNumUnmarshalledAttrs = n2;
        this.setDetailSet(this.mRowSetIterator.getCurrentDetailSet());
        if (n3 >= 0) {
            Object object2 = this.getApplicationModuleImpl().getObject(n3);
            if (object2 == null) {
                throw new JboException("Internal error: ViewDef of id " + n3 + " not found in ROT");
            }
            this.mStructDef = this.getViewObjectImpl().getSubclassDef((ClientViewDef)object2);
        }
    }

    void adjustAfterCommit() {
        int n = this.getAttributeCount();
        int n2 = this.getViewObjectImpl().getUpdWhileNewAttrCount();
        int n3 = 0;
        while (n3 < n && n2 > 0) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.getStructureDef().getAttributeDef(n3);
            byte by = attributeDefImpl.getUpdateableFlag();
            if (by == 1) {
                this.mAttrFlags.clear(n3);
                --n2;
            }
            ++n3;
        }
        this.mCommitSeq = this.getApplicationModuleImpl().getCommitSeq();
    }

    void getContent() {
        this.getApplicationModuleImpl().syncIterator(this.getRSIId(), 16, this.getHandleAsInt(), false, null, null);
    }

    void unMarshalValues() {
        this.unMarshalValues(this.mData, null);
    }

    void unMarshalValues(Object[] objectArray, int[] nArray) {
        if (objectArray == null) {
            return;
        }
        if (this.mRowSetIterator.rowSet == null) {
            return;
        }
        if (this.mNumUnmarshalledAttrs > 0) {
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof Response) {
                    if (!(object instanceof SvcMsgResponseException)) {
                        object = object instanceof SvcMsgResponseByValueRowSet ? this.processAccessorRowSet((SvcMsgResponseByValueRowSet)object) : SvcMsgDataRow.unMarshalValue(object, this.getApplicationModuleImpl());
                    }
                    objectArray[n] = object;
                }
                ++n;
            }
            this.mNumUnmarshalledAttrs = 0;
        }
        if (!this.mDomainsResolved && this.getViewObjectImpl().getMutDomainAttrCount() > 0) {
            HashMap hashMap = new HashMap(5);
            Transaction transaction = this.getApplicationModule().getTransaction();
            hashMap.put((Object)"3", (Object)CLIENT_DOMAIN_VAL);
            int n = 0;
            while (n < objectArray.length) {
                int n2 = nArray == null ? n : nArray[n];
                Object object = objectArray[n];
                if (object instanceof MutableDomainInterface) {
                    hashMap.put((Object)"0", (Object)new Integer(n2));
                    ((DomainInterface)object).setContext(this, transaction, hashMap);
                }
                ++n;
            }
            this.mDomainsResolved = true;
        }
    }

    void resolveAccessors() {
        if (!this.mAccessorsResolved && this.getApplicationModuleImpl().isBoundToWorkingSet()) {
            int n = 0;
            while (n < this.mData.length) {
                this.mData[n] = this.getApplicationModuleImpl().unMarshalWSObject(this.mData[n]);
                ++n;
            }
            this.mAccessorsResolved = true;
        }
    }

    private Object processAccessorRowSet(SvcMsgResponseByValueRowSet svcMsgResponseByValueRowSet) {
        RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.getApplicationModuleImpl().unMarshal(svcMsgResponseByValueRowSet.getRowSetIteratorRef());
        rowSetIteratorImpl.updateRowEvent(svcMsgResponseByValueRowSet.getRowSetData(), null);
        Object object = svcMsgResponseByValueRowSet.isForRowSet() ? rowSetIteratorImpl : rowSetIteratorImpl.first();
        return object;
    }

    public Object getAttribute(int n) {
        if (this.mRowState == 5) {
            this.getContent();
        }
        this.unMarshalValues(this.mData, null);
        if (this.mData != null && n < this.mData.length) {
            Object object = this.mData[n];
            if ((object instanceof Row || object instanceof RowIterator) && this.mPKChangedCount > 0) {
                this.getContent();
                object = this.mData[n];
            }
            if (object instanceof SvcMsgResponseException) {
                Object object2 = ((SvcMsgResponseException)object).getDetail();
                if (object2 instanceof Exception) {
                    JboException jboException;
                    if (object2 instanceof JboException) {
                        jboException = (JboException)object2;
                        this.getApplicationModuleImpl().adjustJboException(jboException);
                    } else {
                        jboException = new JboException((Exception)object2);
                    }
                    throw jboException;
                }
            } else if (object instanceof SvcMsgResponseByValueRowSet) {
                this.mData[n] = object = this.processAccessorRowSet((SvcMsgResponseByValueRowSet)object);
            }
            if (object instanceof RowIterator && this.getApplicationModuleImpl().isBoundToWorkingSet()) {
                object = this.getApplicationModuleImpl().unMarshalWSObject(object);
            }
            return object;
        }
        return null;
    }

    public final Object getAttribute(String string) {
        int n = this.findAttrAndGetIndex(string);
        if (this.mRowState == 5) {
            this.getContent();
        }
        return this.getAttribute(n);
    }

    public boolean isAttributeUpdateable(int n) {
        if (this.mRowState == 5) {
            this.getContent();
        }
        if (n >= this.mAttrFlagsCount) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.getStructureDef().getAttributeDef(n);
            byte by = attributeDefImpl.getUpdateableFlag();
            switch (by) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this._getPostState() == 0;
                }
                case 2: {
                    return true;
                }
            }
            return true;
        }
        return this.mAttrFlags.get(n);
    }

    public boolean isDead() {
        return this.getApplicationModuleImpl().isRowDead(this.getRSIId(), this);
    }

    public StructureDef getStructureDef() {
        if (this.mStructDef == null) {
            return this.mRowSetIterator.rowSet.getViewObject();
        }
        return this.mStructDef;
    }

    protected ViewUsageImpl getViewObjectImpl() {
        return (ViewUsageImpl)this.mRowSetIterator.rowSet.getViewObject();
    }

    final void _markChanged(int n, AttributeDef attributeDef) {
        if (!this.mChanged.get(n)) {
            this.mChanged.set(n);
            ++this.mChangedCount;
            if (attributeDef.isPrimaryKey()) {
                ++this.mPKChangedCount;
            }
        }
    }

    public void setAttribute(int n, Object object) {
        if (this.mRowState == 5) {
            this.getContent();
        }
        this.unMarshalValues(this.mData, null);
        Object object2 = this.getAttribute(n);
        ViewUsageImpl viewUsageImpl = this.getViewObjectImpl();
        AttributeDef attributeDef = viewUsageImpl.getAttributeDef(n);
        if (attributeDef.isPrimaryKey() && this.mRowSetIterator.isBatchMode() && this.mServerRowKey == null) {
            this.mServerRowKey = this.getKey();
        }
        try {
            if (!this.isAttributeUpdateable(n)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new ReadOnlyAttrException(111, clazz, "27008", viewUsageImpl.getName(), attributeDef.getName());
            }
            if (object == null) {
                if (this.mData != null && n < this.mData.length) {
                    this.mData[n] = null;
                }
                if (this.mChanged == null) {
                    this.mChanged = new BitSet(4);
                }
            } else {
                Object object3;
                boolean bl = true;
                if (attributeDef.getAttributeKind() == 4 || attributeDef.getJavaType() == object.getClass()) {
                    object3 = object;
                } else if (object instanceof String && ((String)object).length() == 0) {
                    object3 = null;
                } else if (this.getApplicationModule().getTransaction().isBundledExceptionMode()) {
                    object3 = object;
                    bl = false;
                } else {
                    try {
                        object3 = TypeFactory.convertAttributeValueToType(attributeDef, attributeDef.getJavaType(), object, 111, viewUsageImpl.getFullName());
                    }
                    catch (AttrValException attrValException) {
                        attrValException.setRowKey(111, this.getKey());
                        attrValException.setNeedsEntityToVOMapping(false);
                        throw attrValException;
                    }
                }
                if (this.mData == null || n >= this.mData.length) {
                    this.addAttribute(n);
                }
                if (bl) {
                    Class clazz = class$oracle$jbo$domain$MutableDomainInterface;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$domain$MutableDomainInterface = RowImpl.class$("oracle.jbo.domain.MutableDomainInterface");
                    }
                    if (clazz.isAssignableFrom(attributeDef.getJavaType())) {
                        HashMap hashMap = new HashMap(5);
                        hashMap.put((Object)"3", (Object)CLIENT_DOMAIN_VAL);
                        hashMap.put((Object)"0", (Object)new Integer(n));
                        ((DomainInterface)object3).setContext(this, this.getApplicationModule().getTransaction(), hashMap);
                    }
                }
                this.mData[n] = object3;
            }
            this._markChanged(n, attributeDef);
        }
        catch (DataCreationException dataCreationException) {
            dataCreationException.setAttrInfo(111, viewUsageImpl.getFullName(), attributeDef.getName(), object);
            throw dataCreationException;
        }
        catch (JboException jboException) {
            jboException.printStackTrace();
            throw jboException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (this._getPostState() != 0) {
            this._setState(2, this.mRowSetIterator);
        }
        if (this.getApplicationModule().getSyncMode() == 1) {
            this.getApplicationModule().sync();
        } else if (this.getNewRowState() == -1) {
            this.setNewRowState((byte)0);
        }
    }

    public final void setAttribute(String string, Object object) {
        this.setAttribute(this.findAttrAndGetIndex(string), object);
    }

    public int getAttributeCount() {
        if (this.mRowState == 5) {
            this.getContent();
        }
        return this.mData != null ? this.mData.length : 0;
    }

    public int getAttributeIndexOf(String string) {
        return this.getStructureDef().getAttributeIndexOf(string);
    }

    int findAttrAndGetIndex(String string) {
        int n = this.getAttributeIndexOf(string);
        if (n < 0) {
            throw new NoDefException(131, string, this.getStructureDef().getName());
        }
        return n;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.getAttributeCount()];
        AttributeDef[] attributeDefArray = this.getStructureDef().getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            stringArray[n] = attributeDefArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    public ApplicationModule getApplicationModule() {
        return this.getApplicationModuleImpl();
    }

    public ApplicationModuleImpl getApplicationModuleImpl() {
        return this.mRowSetIterator.rowSet.am;
    }

    Key getServerRowKey() {
        return this.mServerRowKey != null ? this.mServerRowKey : this.getKey();
    }

    void finishedProcessingChanges() {
        this.mServerRowKey = null;
    }

    Object[] getRowFilterValues() {
        if (this.mDetailSet != null) {
            return this.mDetailSet.getRowFilterValues();
        }
        return null;
    }

    Object getMasterRowHandles() {
        if (this.mDetailSet != null) {
            return this.mDetailSet.getMasterRowHandles();
        }
        return null;
    }

    DetailSet getDetailSet() {
        return this.mDetailSet;
    }

    void setDetailSet(DetailSet detailSet) {
        this.mDetailSet = detailSet;
    }

    public Key getKey() {
        ViewUsageImpl viewUsageImpl;
        AttributeDef[] attributeDefArray;
        Key key = null;
        if (this.mRowSetIterator != null && this.mRowSetIterator.rowSet != null && (attributeDefArray = (viewUsageImpl = this.getViewObjectImpl()).getKeyAttributeDefs()) != null) {
            int n = attributeDefArray.length;
            Object[] objectArray = new Object[n];
            while (n > 0) {
                objectArray[--n] = this.getAttribute(attributeDefArray[n].getIndex());
            }
            key = new Key(objectArray, viewUsageImpl.getSignature(), this.getHandle());
        }
        return key;
    }

    public void validate() {
        this.mRowSetIterator.validateRow(this);
    }

    public void revert() {
        this.mRowSetIterator.refreshRow(this, 0);
    }

    public void refresh(int n) {
        this.mRowSetIterator.refreshRow(this, n);
    }

    public void domainToBeModified(DomainInterface domainInterface) {
        this.lock();
    }

    public void lock() {
        this.mRowSetIterator.lockRow(this);
    }

    public void remove() {
        this.mRowSetIterator.removeRow(this, 0);
    }

    public void removeFromCollection() {
        this.mRowSetIterator.removeRow(this, 1);
    }

    public void removeAndRetain() {
        this.mRowSetIterator.removeRow(this, 2);
    }

    final int getCommitSeq() {
        return this.mCommitSeq;
    }

    final Object getHandle() {
        return this.mHandle;
    }

    final void setHandle(Object object) {
        this.mHandle = (Integer)object;
    }

    final int getRowIndex() {
        return this.mRowIndex;
    }

    final void setRowIndex(int n) {
        this.mRowIndex = n;
    }

    final int getRangeStart() {
        return this.mRangeStart;
    }

    final void setRangeStart(int n) {
        this.mRangeStart = n;
    }

    final int getAttributeChangedCount() {
        return this.mChangedCount;
    }

    final Object[] getData() {
        if (this.mRowState == 5) {
            this.getContent();
        }
        return this.mData;
    }

    void setAttributeUpdateableFlags(int[] nArray, BitSet bitSet) {
        int n;
        boolean bl = false;
        int n2 = n = this.mData == null || this.mData.length == 0 ? 1 : this.mData.length;
        if (bitSet == null) {
            bl = true;
            bitSet = new BitSet(n);
        }
        if (nArray == null || bl) {
            this.mAttrFlags = bitSet;
            this.mAttrFlagsCount = n;
        } else {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = nArray[n3];
                if (bitSet.get(n4)) {
                    this.mAttrFlags.set(n4);
                } else {
                    this.mAttrFlags.clear(n4);
                }
                if (n4 >= this.mAttrFlagsCount) {
                    this.mAttrFlagsCount = n4 + 1;
                }
                ++n3;
            }
        }
    }

    final void update(byte by, Object[] objectArray, int[] nArray, BitSet bitSet, int n) {
        this.unMarshalValues(this.mData, null);
        int n2 = -1;
        this.mNewRowState = by;
        this.mNumUnmarshalledAttrs = n;
        this.mCommitSeq = this.getApplicationModuleImpl().getCommitSeq();
        this.mDomainsResolved = false;
        this.unMarshalValues(objectArray, nArray);
        if (nArray == null || this.mData != null && objectArray.length == this.mData.length) {
            if (this.getViewObjectImpl().getMutDomainAttrCount() > 0) {
                int n3 = n2 = objectArray != null ? objectArray.length : 0;
                if (this.mData == null || this.mData.length < n2) {
                    this.addAttribute(n2 - 1);
                }
            } else {
                this.mData = objectArray;
                this.setAttributeUpdateableFlags(nArray, bitSet);
            }
            this.mPKChangedCount = 0;
            this.mServerRowKey = null;
        } else if (this.mData == null) {
            if (this.mRowState == 5) {
                return;
            }
            this.mData = objectArray;
            this.setAttributeUpdateableFlags(nArray, bitSet);
            this.mPKChangedCount = 0;
            this.mServerRowKey = null;
        } else {
            n2 = nArray.length;
        }
        if (n2 >= 0) {
            Transaction transaction = this.getApplicationModule().getTransaction();
            HashMap hashMap = null;
            if (this.getViewObjectImpl().getMutDomainAttrCount() > 0) {
                hashMap = new HashMap(5);
                hashMap.put((Object)"3", (Object)CLIENT_DOMAIN_VAL);
            }
            int n4 = 0;
            while (n4 < n2) {
                Object object;
                AttributeDef attributeDef;
                int n5;
                int n6 = n5 = nArray != null ? nArray[n4] : n4;
                if (n5 >= this.mData.length && (attributeDef = this.getStructureDef().getAttributeDef(n5)).getAttributeKind() == 4) {
                    this.addAttribute(n5);
                }
                if (!((object = objectArray[n4]) instanceof MutableDomainInterface)) {
                    this.mData[n5] = object;
                } else {
                    Object object2 = this.mData[n5];
                    if (object2 instanceof LobInterface) {
                        ((LobInterface)object2).syncClientLob((LobInterface)object);
                    } else {
                        object2 = object;
                    }
                    if (object2 != null) {
                        hashMap.put((Object)"0", (Object)new Integer(n5));
                        ((DomainInterface)object2).setContext(this, transaction, hashMap);
                    }
                    this.mData[n5] = object2;
                }
                if (bitSet != null) {
                    this.setAttributeUpdateableFlags(nArray, bitSet);
                }
                ++n4;
            }
        }
        this._setState(1, this.mRowSetIterator);
        this.resetChanged();
    }

    final void addAttribute(int n) {
        if (this.mRowState == 5) {
            this.getContent();
        }
        int n2 = n + 1;
        Object[] objectArray = new Object[n2];
        if (this.mData != null) {
            System.arraycopy(this.mData, 0, objectArray, 0, this.mData.length);
        }
        this.mData = objectArray;
        if (this.mChanged == null) {
            this.mChanged = new BitSet(4);
        }
        this.mChanged.clear(this.mData.length);
    }

    final boolean _remove(int n) {
        int n2 = -1;
        if (n == 0) {
            n2 = 3;
        } else if (n == 1) {
            n2 = 6;
        } else if (n == 2) {
            n2 = 7;
        }
        this._setState(n2, this.mRowSetIterator);
        this.mRowSetIterator.rowRemoved(this);
        return true;
    }

    final boolean _add(RowSetIteratorImpl rowSetIteratorImpl) {
        this._setState(0, rowSetIteratorImpl);
        this.mNewRowState = 0;
        return true;
    }

    final int _getPostState() {
        return this.mRowState;
    }

    final void _setState(int n, RowSetIteratorImpl rowSetIteratorImpl) {
        this.mRowState = n;
        if (this.mRowState != 1 && this.mRowState != 5) {
            rowSetIteratorImpl.setChanged(this, true);
        }
    }

    final boolean hasChanged(int n) {
        return this.mChanged != null ? this.mChanged.get(n) : false;
    }

    final boolean hasChanged(String string) {
        return this.hasChanged(this.findAttrAndGetIndex(string));
    }

    private final void resetChanged() {
        this.mChanged = this.mData != null ? new BitSet(this.mData.length) : new BitSet(4);
        this.mChangedCount = 0;
    }

    final boolean belongsTo(RowSetIteratorImpl rowSetIteratorImpl) {
        return rowSetIteratorImpl == this.mRowSetIterator;
    }

    protected byte[] getPiggyback() {
        return this.getApplicationModuleImpl().getPiggyback();
    }

    protected ServiceMessage getServiceMessage() {
        return this.getApplicationModuleImpl().getServiceMessage();
    }

    protected void processPiggyback(byte[] byArray) {
        this.getApplicationModuleImpl().processPiggyback(byArray);
    }

    protected ArrayList processServiceMessage(ServiceMessage serviceMessage) {
        return this.getApplicationModuleImpl().processServiceMessage(serviceMessage);
    }

    protected final int getRSIId() {
        return this.mRowSetIterator.getRemoteId();
    }

    protected final int getHandleAsInt() {
        return this.mHandle;
    }

    public RowSetIterator getRowSetIterator() {
        return this.mRowSetIterator;
    }

    public RowSet getRowSet() {
        return this.mRowSetIterator.getRowSet();
    }

    protected ObjectMarshaller getObjectMarshaller() {
        return this.getApplicationModuleImpl().getObjectMarshaller();
    }

    public Node writeXML(long l, HashMap hashMap) {
        return this.getApplicationModuleImpl().writeRowXMLWithMap(this.getRSIId(), this, l, hashMap);
    }

    public Node writeXML(int n, long l) {
        return this.getApplicationModuleImpl().writeRowXML(this.getRSIId(), this, n, l);
    }

    public void readXML(Element element, int n) {
        this.getApplicationModuleImpl().readRowXML(this.getRSIId(), this, element, n);
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, l, hashMap, xSLStylesheet);
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, n, l, xSLStylesheet);
    }

    public void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        JboXMLUtil.processAndReadXML(this, element, n, xSLStylesheet);
    }

    public void setNewRowState(byte by) {
        if (this.mRowSetIterator.isBatchMode()) {
            if (this.mNewRowState != by && (this.mNewRowState == 0 || this.mNewRowState == -1)) {
                this.mNewRowState = by;
                if (this.mRowState == 1) {
                    this._setState(2, this.mRowSetIterator);
                }
            }
        } else {
            this.getApplicationModuleImpl().setNewRowState(this.getRSIId(), this, by, true);
        }
    }

    final byte getNewRowState() {
        return this.mNewRowState;
    }

    protected ApplicationModuleImpl getApplicationModuleProxy() {
        return this.getApplicationModuleImpl();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

