/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import java.io.IOException;
import java.io.OutputStream;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.domain.DomainOwnerInterface;

public class LobDomainOutputStream
extends OutputStream {
    ApplicationModuleImpl am;
    int rsId;
    int rowId;
    String attrId;
    Object[] args;

    public LobDomainOutputStream(Transaction transaction, DomainOwnerInterface domainOwnerInterface, String string) {
        this.am = (ApplicationModuleImpl)transaction;
        RowImpl rowImpl = (RowImpl)domainOwnerInterface;
        this.rsId = rowImpl.getRSIId();
        this.rowId = (Integer)rowImpl.getHandle();
        this.attrId = string;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new JboException(new NullPointerException());
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 < 0) {
            throw new JboException(new IndexOutOfBoundsException());
        }
        if (byArray.length != 0 && n2 == 0) {
            return;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        byte[] byArray2 = byArray;
        if (n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        this.am.writeLob(this.rsId, this.rowId, this.attrId, byArray2);
    }

    public void flush() throws IOException {
        super.flush();
        this.am.writeLob(this.rsId, this.rowId, this.attrId, new byte[0]);
    }

    public void close() throws IOException {
        this.am.closeLob(this.rsId, this.rowId, this.attrId, false, false);
        super.close();
    }
}

