/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import java.io.IOException;
import java.io.Reader;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.domain.DomainOwnerInterface;

public class ClobDomainCharacterStream
extends Reader {
    ApplicationModuleImpl am;
    int rsId;
    int rowId;
    String attrId;
    Object[] args;

    public ClobDomainCharacterStream(Transaction transaction, DomainOwnerInterface domainOwnerInterface, String string) {
        this.am = (ApplicationModuleImpl)transaction;
        RowImpl rowImpl = (RowImpl)domainOwnerInterface;
        this.rsId = rowImpl.getRSIId();
        this.rowId = (Integer)rowImpl.getHandle();
        this.attrId = string;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new JboException(new NullPointerException());
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new JboException(new IndexOutOfBoundsException());
        }
        if (n2 == 0) {
            return 0;
        }
        char[] cArray2 = (char[])this.am.readBlobStream(this.rsId, this.rowId, this.attrId, 0, n2);
        if (cArray2 != null) {
            int n3 = cArray2.length <= cArray.length ? cArray2.length : cArray.length;
            System.arraycopy(cArray2, 0, cArray, n, n3);
            return n3;
        }
        return -1;
    }

    public void close() throws IOException {
        this.am.closeLob(this.rsId, this.rowId, this.attrId, true, true);
    }
}

