/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import java.util.ArrayList;
import oracle.jbo.Variable;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.ClientComponentObject;
import oracle.jbo.common.SvcMsgVariable;
import oracle.jbo.common.VariableValueManagerImpl;

public class ClientVariableValueManager
extends VariableValueManagerImpl {
    private ApplicationModuleImpl mAM;
    private boolean mIsInSync;
    private ArrayList mBatchOpers;
    private boolean mDoBatchOpers;

    private /* synthetic */ void $init$() {
        this.mIsInSync = false;
        this.mBatchOpers = null;
        this.mDoBatchOpers = true;
    }

    public ClientVariableValueManager(ApplicationModuleImpl applicationModuleImpl, VariableManagerOwner variableManagerOwner, ClientVariableValueManager[] clientVariableValueManagerArray) {
        super(variableManagerOwner, clientVariableValueManagerArray);
        this.$init$();
        this.mAM = applicationModuleImpl;
    }

    int getRemoteId() {
        return ((ClientComponentObject)((Object)this.getVarMgrOwner())).getRemoteId();
    }

    boolean isBatchMode() {
        return this.mAM.isBoundToWorkingSet();
    }

    void addBatchOper(int n, Variable variable, String string, Object object) {
        if (this.mDoBatchOpers) {
            if (this.mBatchOpers == null) {
                this.mBatchOpers = new ArrayList(2);
            }
            SvcMsgVariable svcMsgVariable = new SvcMsgVariable(n, this.getRemoteId(), variable, string, object);
            this.mBatchOpers.add(svcMsgVariable);
        }
    }

    ArrayList getBatchOpers() {
        return this.mBatchOpers;
    }

    void resetBatchOpers() {
        this.mBatchOpers = null;
    }

    public Object getVariableValue(Variable variable) {
        this.ensureVariablesRefreshed();
        return super.getVariableValue(variable);
    }

    public Object getVariableValue(String string) {
        this.ensureVariablesRefreshed();
        return super.getVariableValue(string);
    }

    public Object getVariableValueRaw(Variable variable, boolean bl) {
        this.ensureVariablesRefreshed();
        return super.getVariableValueRaw(variable, bl);
    }

    public Object getVariableValueRaw(String string, boolean bl) {
        this.ensureVariablesRefreshed();
        return super.getVariableValueRaw(string, bl);
    }

    public void setVariableValue(Variable variable, Object object) {
        this.ensureVariablesRefreshed();
        super.setVariableValue(variable, object);
        if (this.isBatchMode()) {
            this.addBatchOper(3, null, variable.getName(), object);
        } else {
            this.mAM.setVariableValue(this.getRemoteId(), variable.getName(), object);
        }
    }

    public void setVariableValue(String string, Object object) {
        this.ensureVariablesRefreshed();
        this.setVariableValue(this.findVariable(string), object);
    }

    void populateVarMgr(Variable[] variableArray) {
        super.clearVariables();
        if (variableArray != null) {
            int n = 0;
            while (n < variableArray.length) {
                super.addVariable(variableArray[n]);
                ++n;
            }
        }
        this.mIsInSync = true;
        if (this.mBatchOpers != null) {
            this.mBatchOpers.clear();
        }
    }

    void refreshVariables() {
        Object[] objectArray = this.mAM.refreshVariables(this.getRemoteId());
        if (objectArray == null || objectArray.length < 2 || objectArray[0] == null || objectArray[1] == null) {
            return;
        }
        Variable[] variableArray = (Variable[])objectArray[0];
        this.populateVarMgr(variableArray);
        Object[] objectArray2 = (Object[])objectArray[1];
        int n = 0;
        while (n < variableArray.length) {
            this.populateVariableValue(variableArray[n], objectArray2[n]);
            ++n;
        }
    }

    void setNeedsRefresh() {
        this.mIsInSync = false;
    }

    void ensureVariablesRefreshed() {
        if (!this.mIsInSync && !this.isBatchMode()) {
            this.refreshVariables();
        }
    }

    public Variable[] getVariables() {
        this.ensureVariablesRefreshed();
        return super.getVariables();
    }

    public Variable[] getVariablesOfKind(String string) {
        this.ensureVariablesRefreshed();
        return super.getVariablesOfKind(string);
    }

    public int getVariableCount() {
        this.ensureVariablesRefreshed();
        return super.getVariableCount();
    }

    public Variable findVariable(String string) {
        this.ensureVariablesRefreshed();
        return super.findVariable(string);
    }

    public Variable lookupVariable(String string) {
        this.ensureVariablesRefreshed();
        return super.lookupVariable(string);
    }

    Variable doAddVariable(Variable variable, String string) {
        boolean bl = this.isBatchMode();
        if (!bl) {
            Object[] objectArray = this.mAM.addVariable(this.getRemoteId(), variable, string, this.mIsInSync);
            Variable[] variableArray = (Variable[])objectArray[0];
            Variable variable2 = (Variable)objectArray[1];
            if (!this.mIsInSync) {
                this.populateVarMgr(variableArray);
            }
            if (variable == null) {
                variable = variable2;
            }
            super.addVariable(variable);
        } else if (variable != null) {
            super.addVariable(variable);
            this.addBatchOper(1, variable, null, null);
        } else {
            variable = super.addVariable(string);
        }
        return variable;
    }

    public void addVariable(Variable variable) {
        this.doAddVariable(variable, null);
    }

    public Variable addVariable(String string) {
        return this.doAddVariable(null, string);
    }

    public Variable removeVariable(String string) {
        boolean bl = this.isBatchMode();
        if (!bl) {
            Object[] objectArray = this.mAM.removeVariable(this.getRemoteId(), string, this.mIsInSync);
            Variable[] variableArray = (Variable[])objectArray[0];
            if (!this.mIsInSync) {
                this.populateVarMgr(variableArray);
            }
        }
        Variable variable = super.removeVariable(string);
        if (bl) {
            this.addBatchOper(2, null, string, null);
        }
        return variable;
    }

    public void clearVariables() {
        super.clearVariables();
        if (this.isBatchMode()) {
            this.addBatchOper(4, null, null, null);
        } else {
            Object[] objectArray = this.mAM.removeVariable(this.getRemoteId(), null, this.mIsInSync);
        }
    }

    public void variableChanged(Variable variable) {
        super.variableChanged(variable);
        if (this.isBatchMode()) {
            this.addBatchOper(0, variable, null, null);
        } else {
            this.mAM.variableChanged(this.getRemoteId(), new Variable[]{variable});
        }
    }

    void mergeVariableValues(Variable[] variableArray, Object[] objectArray, boolean bl) {
        boolean bl2 = this.mDoBatchOpers;
        try {
            this.mDoBatchOpers = bl;
            this.mergeVariableValues(variableArray, objectArray);
            Object var6_5 = null;
            this.mDoBatchOpers = bl2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mDoBatchOpers = bl2;
            throw throwable;
        }
    }
}

