/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.HashMap;
import java.text.ParseException;
import java.util.Hashtable;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.ViewObject;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.common.AttributeDefHelper;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.format.Formatter;

public class AttributeDefImpl
extends AttributeDefHelper
implements AttributeHints {
    ApplicationModuleImpl am;
    int viewId;
    boolean mControlHintsFetched;
    private final byte FORMAT_INFO_UNINITIALIZED;
    private final byte FORMAT_INFO_NOT_AVAILABLE;
    private final byte FORMAT_INFO_AVAILABLE;
    private byte mHasFormatInfo;

    private /* synthetic */ void $init$() {
        this.mControlHintsFetched = false;
        this.FORMAT_INFO_UNINITIALIZED = (byte)-1;
        this.FORMAT_INFO_NOT_AVAILABLE = 0;
        this.FORMAT_INFO_AVAILABLE = 1;
        this.mHasFormatInfo = (byte)-1;
    }

    AttributeDefImpl(ApplicationModuleImpl applicationModuleImpl, int n) {
        this.$init$();
        this.am = applicationModuleImpl;
        this.viewId = n;
    }

    AttributeDefImpl(ApplicationModuleImpl applicationModuleImpl, int n, String string, String string2, String string3, int n2, String string4, int n3, byte by, boolean bl, boolean bl2, boolean bl3, byte by2, boolean bl4, boolean bl5, int n4, int n5, String string5) throws ClassNotFoundException {
        super(string, string2, string3, n2, string4, n3, by, bl, bl2, bl3, by2, bl4, bl5, n4, n5, string5);
        this.$init$();
        this.am = applicationModuleImpl;
        this.viewId = n;
    }

    public Hashtable getProperties() {
        this.mProperties = this.am.getVOAttrProperties(this.viewId, this.getIndex());
        return this.mProperties;
    }

    public AttributeHints getUIHelper() {
        return this;
    }

    public String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName(localeContext, string);
    }

    String getControlHint(LocaleContext localeContext, String string) {
        HashMap hashMap;
        String string2;
        if (string == null) {
            return null;
        }
        if (!this.mControlHintsFetched) {
            if (this.am.getObject(this.viewId) != null) {
                this.am.fetchAttributeProperties(new String[]{((ViewObject)this.am.getObject(this.viewId)).getFullName()}, new String[][]{{this.getName()}}, localeContext);
                this.mControlHintsFetched = true;
            }
            if (this.mProperties == null) {
                Diagnostic.println("No Properties found while fetching properties for attribute:" + this.getName());
                return null;
            }
        }
        if ((string2 = (String)this.mProperties.get(this.getLocaleName(localeContext, string))) == null) {
            string2 = (String)this.mProperties.get(string);
        }
        if (string2 == null && (hashMap = (HashMap)this.mProperties.get("__bc4j_res__")) != null) {
            String string3 = this.getName() + "_" + string;
            string2 = (String)hashMap.get((Object)string3);
        }
        return string2;
    }

    void setControlHints(Hashtable hashtable) {
        this.mProperties = hashtable;
        this.mControlHintsFetched = true;
    }

    public String getLabel(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "LABEL");
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public String getTooltip(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "TOOLTIP");
    }

    public String getDisplayHint(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHINT");
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public int getControlType(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "CONTROLTYPE");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public int getDisplayWidth(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYWIDTH");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public int getDisplayHeight(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHEIGHT");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        return this.getControlHint(localeContext, string);
    }

    public String getHintValue(LocaleContext localeContext, String string) {
        return this.getControlHint(localeContext, string);
    }

    public String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.getControlHint(localeContext, "FMT_FORMAT");
        if (string == null) {
            string = this.getFormatter(localeContext).getDefaultFormatString();
        }
        return string;
    }

    public Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.getFormatterClassName(localeContext);
        try {
            Class<?> clazz = Class.forName(string);
            Formatter formatter = (Formatter)clazz.newInstance();
            try {
                formatter.setLocale(localeContext);
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            Formatter formatter2 = formatter;
            return formatter2;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public boolean hasFormatInformation(LocaleContext localeContext) {
        if (this.mHasFormatInfo == -1) {
            String string = this.getControlHint(localeContext, "FMT_FORMATTER");
            this.mHasFormatInfo = string == null || string.equals("") ? (byte)0 : 1;
        }
        return this.mHasFormatInfo == 1;
    }

    public String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getIndex());
        if (object == null) {
            return null;
        }
        if (object.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = object;
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public boolean displayInShortForm(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "FORMTYPE");
        if (string == null) {
            return false;
        }
        return string.equals("Summary");
    }

    public String getFormatterClassName(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "FMT_FORMATTER");
    }
}

