/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client;

import oracle.jbo.AttributeDef;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;

public final class JboUtil {
    public static boolean isAttributeDisplayable(AttributeDef attributeDef, LocaleContext localeContext) {
        String string = attributeDef.getUIHelper().getHint(localeContext, "DISPLAYHINT");
        if (string == null || "Display".equals(string)) {
            switch (attributeDef.getAttributeKind()) {
                case 2: 
                case 6: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static String getAttributeLabel(RowSet rowSet, AttributeDef attributeDef) {
        String string;
        LocaleContext localeContext = rowSet.getApplicationModule().getSession().getLocaleContext();
        if (attributeDef.getUIHelper().getLabel(localeContext) != null) {
            string = attributeDef.getUIHelper().getLabel(localeContext);
        } else {
            String string2 = attributeDef.getName() + "_LABEL";
            string2 = string2.toUpperCase();
            String string3 = (String)rowSet.getProperties().get(string2);
            string = string3 != null ? string3 : attributeDef.getName();
        }
        return string;
    }

    public static Row getRowFromKey(RowSetIterator rowSetIterator, String string) {
        Key key;
        try {
            key = new Key(string, rowSetIterator.getRowSet().getViewObject().getKeyAttributeDefs());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Row row = null;
            return row;
        }
        Row[] rowArray = rowSetIterator.findByKey(key, 1);
        if (rowArray.length <= 0) {
            return null;
        }
        return rowArray[0];
    }
}

