/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client;

import com.sun.java.util.collections.ArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ConfigException;
import oracle.jbo.JboException;
import oracle.jbo.client.JboCMUtils;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.PropertyManager;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.RepConversion;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.EnvInfoProvider;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.security.misc.Checksum;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Configuration {
    private static final String SESSION_POOL_NAME = "jbo.poolname";
    public static final String BC4J_CONFIG = "BC4JConfig";
    protected static final String APP_MODULE_CONFIG_BAG = "AppModuleConfigBag";
    protected static final String APP_MODULE_CONFIG_NAME = "AppModuleConfig";
    protected static final String CONNECTION_DEF_NAME = "ConnectionDefinition";
    protected static final String ATTR_CONFIG_NAME = "name";
    public static final String CONFIGURATION_NAME = "jbo.configname";
    public static final String APPLICATION_NAME_PROPERTY = "ApplicationName";
    public static final String APPMODULE_JNDI_NAME = "AppModuleJndiName";
    public static final String BC4J_CONFIG_NAME = "BC4JConfigName";
    public static final String BC4J_CONFIG_NAMES = "BC4JConfigNames";
    public static final String APPLICATION_TYPE_PROPERTY = "ApplicationType";
    public static final String APPLICATION_TYPE_VALUE_PACKAGE = "PACKAGE";
    public static final String APPLICATION_TYPE_VALUE_APPMODULE = "APPMODULE";
    public static final String DB_CONNECTION_PROPERTY = "DBconnection";
    public static final String DB_USERNAME_PROPERTY = "user";
    public static final String DB_PASSWORD_PROPERTY = "password";
    public static final String DB_CONNECT_STRING_PROPERTY = "jbo.jdbc.connectstring";
    public static final String DB_DATASOURCE_PROPERTY = "DsName";
    public static final String DB_DATASOURCE_USERNAME_PROPERTY = "DsUserName";
    public static final String DB_DATASOURCE_PASSWD_PROPERTY = "DsPasswd";
    public static final String IS_INTERNAL = "jbo.internal.embedded";
    public static final String JDBC_CONNECTION_NAME = "JDBCName";
    public static final String DT_DEPLOYMENTPROFILE = "DtDeploymentProfile";
    public static final String DT_COMMONDEPLOYMENTPROFILE = "DtCommonDeploymentProfile";
    public static final String DT_MIDDLETIERDEPLOYMENTPROFILE = "DtMiddleTierDeploymentProfile";
    public static final String IIOP_CONNECTION_NAME = "IIOPName";
    public static final String APPSERVER_CONNECTION_NAME = "AppServerConnectionName";
    public static final String HTTP_CONNECTION_NAME = "HTTPName";
    public static final String JDBC_DS_NAME = "JDBCDataSource";
    public static final String O8I_CONNECT_STRING = "jdbc:oracle:kprb:";
    public static final String COMMON = "common";
    public static final String DEFAULT_CONFIG_FILE_EXT = "xcfg";
    public static final String DEFAULT_CONFIG_FILE = "bc4j";
    public static final String DEFAULT_CONFIG_FILENAME = "bc4j.xcfg";
    public static final String JBO_SESSION_COOKIE = "jbo.sessioncookie";
    protected XMLDocument configDocument;
    protected DOMParser domParser;
    private String mConfigPackage;
    protected static ConnectionManager connectionManager = ConnectionManager.getPrivateInstance();
    private static long mCounter = 0L;
    private static Object mStaticLock = new Object();
    private static final int BUFFER = 512;
    private static final String CHECKSUM_904 = "{904}";
    private static final byte[] checksumKey = null;
    private static /* synthetic */ Class class$oracle$jbo$common$CommonMessageBundle;

    private /* synthetic */ void $init$() {
        this.domParser = JboXMLUtil.createDOMParser(false);
        this.mConfigPackage = "";
    }

    public Configuration() {
        this.$init$();
    }

    public void loadFromStream(InputStream inputStream) throws JboException {
        this.configDocument = this.getXMLDocument(inputStream);
        this.registerConnectionsFromDocument();
    }

    public void loadFromReader(Reader reader) throws JboException {
        this.configDocument = this.getXMLDocument(reader);
        this.registerConnectionsFromDocument();
    }

    public void loadFromFile(String string) throws JboException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string);
            this.loadFromStream(fileInputStream);
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            int n2 = string.lastIndexOf(COMMON);
            if (n2 >= 0) {
                this.mConfigPackage = string.substring(0, n2 - 2);
            }
            if ((n = this.mConfigPackage.indexOf(58)) >= 0) {
                this.mConfigPackage = this.mConfigPackage.substring(n + 2);
            }
            this.mConfigPackage = this.mConfigPackage.replace('/', '.');
            this.mConfigPackage = this.mConfigPackage.replace('\\', '.');
            if (this.mConfigPackage.startsWith(".")) {
                this.mConfigPackage = this.mConfigPackage.substring(1);
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.loadFromFile() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33000", new Object[]{string});
            configException.addToDetails(exception);
            throw configException;
        }
    }

    public void loadFromClassPath(String string) throws JboException {
        String string2 = "/" + string;
        InputStream inputStream = JBOClass.getResourceAsStream(string2 = string2.replace(File.separatorChar, '/'));
        if (inputStream == null) {
            inputStream = JBOClass.getResourceAsStream(string2.substring(1));
        }
        if (inputStream == null) {
            Class clazz = class$oracle$jbo$common$CommonMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33001", new Object[]{string2});
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.loadFromClassPath() failed");
                Diagnostic.printStackTrace(configException);
            }
            throw configException;
        }
        try {
            this.loadFromStream(inputStream);
            inputStream.close();
            inputStream = null;
            int n = string.lastIndexOf(COMMON);
            if (n >= 0) {
                this.mConfigPackage = string.substring(0, n - 2);
            }
            this.mConfigPackage = this.mConfigPackage.replace('/', '.');
            this.mConfigPackage = this.mConfigPackage.replace('\\', '.');
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.loadFromClassPath() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33001", new Object[]{string});
            configException.addToDetails(exception);
            throw configException;
        }
    }

    public Hashtable getConfiguration(String string) throws JboException {
        return this.getConfiguration(string, true);
    }

    public Hashtable getConfiguration(String string, boolean bl) {
        Hashtable hashtable = new Hashtable(20);
        this.getConfiguration(string, hashtable, bl);
        return hashtable;
    }

    public void getConfiguration(String string, Hashtable hashtable) throws JboException {
        this.getConfiguration(string, hashtable, true);
    }

    public void getConfiguration(String string, Hashtable hashtable, boolean bl) {
        Node node = this.getConfigurationNode(string);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                String string2 = node2.getNodeName();
                String string3 = null;
                Node node3 = node2.getFirstChild();
                if (node3 != null) {
                    string3 = node3.getNodeValue();
                }
                if (string2.equals(DB_PASSWORD_PROPERTY) && (string3 == null || string3.length() == 0) || string2.equals(PropertyMetadata.SECURITY_CREDENTIALS.pName)) {
                    string3 = this.getPassword(node2);
                }
                if (string3 != null) {
                    hashtable.put(string2, string3);
                }
                ++n;
            }
        } else {
            Class clazz = class$oracle$jbo$common$CommonMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33005", new Object[]{string});
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.getConfiguration() failed");
                Diagnostic.printStackTrace(configException);
            }
            throw configException;
        }
        this.upgradeConfiguration(hashtable);
        this.loadClientProperties((Hashtable)hashtable.clone());
        this.addProperties(hashtable);
        if (bl) {
            this.initializeFromConnectionName(hashtable);
        }
    }

    public boolean isEmbeddedConfig(String string) {
        Hashtable hashtable;
        boolean bl;
        block3: {
            bl = false;
            hashtable = null;
            try {
                hashtable = this.getConfiguration(string);
            }
            catch (JboException jboException) {
                if ("33005".equals(jboException.getErrorCode())) break block3;
                throw jboException;
            }
        }
        if (hashtable != null) {
            bl = Configuration.isEmbeddedConfig(hashtable);
        }
        return bl;
    }

    public static boolean isEmbeddedConfig(Hashtable hashtable) {
        boolean bl = false;
        String string = (String)hashtable.get(IS_INTERNAL);
        if (string != null && string.length() > 0) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    private void upgradeConfiguration(Hashtable hashtable) {
        String string = (String)hashtable.get(APPLICATION_NAME_PROPERTY);
        if (string != null && hashtable.get(APPMODULE_JNDI_NAME) == null) {
            hashtable.put(APPMODULE_JNDI_NAME, string);
        }
    }

    private void loadClientProperties(Hashtable hashtable) {
        PropertyManager.loadProperty(PropertyMetadata.ENV_MAX_POOL_COOKIE_AGE, null, hashtable, null, null, null, null, null, null);
    }

    protected void addProperties(Hashtable hashtable) {
        hashtable.put(PropertyMetadata.INITIAL_CONTEXT_FACTORY.getName(), PropertyMetadata.INITIAL_CONTEXT_FACTORY.getDefault());
    }

    public String[] getConfigurationNameList() throws JboException {
        return this.getConfigurationNameList(true);
    }

    public String[] getConfigurationNameList(String string) throws JboException {
        String[] stringArray = this.getConfigurationNameList(true);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            Hashtable hashtable = this.getConfiguration(stringArray[n]);
            if (hashtable.get(APPLICATION_NAME_PROPERTY).equals(string)) {
                arrayList.add((Object)stringArray[n]);
            }
            ++n;
        }
        return (String[])arrayList.toArray();
    }

    public String[] getExternalConfigurationNameList() {
        return this.getConfigurationNameList(false);
    }

    private String[] getConfigurationNameList(boolean bl) {
        ArrayList arrayList = new ArrayList();
        NodeList nodeList = this.getAppModuleConfigNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    String string;
                    Node node2 = namedNodeMap.getNamedItem(ATTR_CONFIG_NAME);
                    String string2 = string = node2 != null ? node2.getNodeValue() : null;
                    if (!bl && string != null) {
                        boolean bl2 = this.isEmbeddedConfig(string);
                        if (!bl2) {
                            arrayList.add((Object)string);
                        }
                    } else if (string != null) {
                        arrayList.add((Object)string);
                    }
                }
                ++n;
            }
        }
        return (String[])arrayList.toArray((Object[])new String[arrayList.size()]);
    }

    public static String buildConfigurationFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(COMMON);
        stringBuffer.append(File.separator);
        stringBuffer.append(DEFAULT_CONFIG_FILENAME);
        return stringBuffer.toString();
    }

    public static String buildConfigurationFileNameFromClassPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string.replace('.', File.separatorChar));
            if (!stringBuffer.toString().endsWith(File.separator)) {
                stringBuffer.append(File.separator);
            }
        }
        stringBuffer.append(COMMON);
        stringBuffer.append(File.separator);
        stringBuffer.append(DEFAULT_CONFIG_FILENAME);
        return stringBuffer.toString();
    }

    protected Node getConfigurationNode(String string) {
        NodeList nodeList = this.getAppModuleConfigNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node;
                Node node2 = nodeList.item(n);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap != null && (node = namedNodeMap.getNamedItem(ATTR_CONFIG_NAME)) != null && node.getNodeValue().equalsIgnoreCase(string)) {
                    return node2;
                }
                ++n;
            }
        }
        return null;
    }

    protected NodeList getAppModuleConfigNodes() {
        if (this.configDocument != null) {
            NodeList nodeList = this.configDocument.getElementsByTagName(APP_MODULE_CONFIG_NAME);
            return nodeList;
        }
        return null;
    }

    protected NodeList getConnectionDefinitionNodes() {
        try {
            if (this.configDocument != null) {
                NodeList nodeList;
                NodeList nodeList2 = nodeList = this.configDocument.getElementsByTagName(CONNECTION_DEF_NAME);
                return nodeList2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Node getAppModuleConfigBagNode() {
        if (this.configDocument != null) {
            NodeList nodeList = this.configDocument.getElementsByTagName(APP_MODULE_CONFIG_BAG);
            return nodeList.item(0);
        }
        return null;
    }

    protected XMLDocument getXMLDocument(InputStream inputStream) throws JboException {
        XMLDocument xMLDocument = null;
        try {
            if (inputStream != null) {
                this.domParser.parse(inputStream);
                xMLDocument = this.domParser.getDocument();
                this.domParser.reset();
            } else {
                xMLDocument = new XMLDocument();
                Element element = xMLDocument.createElement(BC4J_CONFIG);
                xMLDocument.appendChild((Node)element);
                element.appendChild(xMLDocument.createElement(APP_MODULE_CONFIG_BAG));
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.getXMLDocument() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33004", null);
            configException.addToDetails(exception);
            throw configException;
        }
        return xMLDocument;
    }

    protected XMLDocument getXMLDocument(Reader reader) throws JboException {
        XMLDocument xMLDocument = null;
        try {
            if (reader != null) {
                this.domParser.parse(reader);
                xMLDocument = this.domParser.getDocument();
                this.domParser.reset();
            } else {
                xMLDocument = new XMLDocument();
                Element element = xMLDocument.createElement(BC4J_CONFIG);
                xMLDocument.appendChild((Node)element);
                element.appendChild(xMLDocument.createElement(APP_MODULE_CONFIG_BAG));
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.getXMLDocument() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33004", null);
            configException.addToDetails(exception);
            throw configException;
        }
        return xMLDocument;
    }

    private static ConnectionManager getCM() {
        return connectionManager;
    }

    private static ConnectionDescriptor resolveConnection(String string) throws IOException {
        ConnectionDescriptor connectionDescriptor = Configuration.getCM().getConnectionDescriptor(string);
        if (connectionDescriptor == null) {
            connectionDescriptor = ConnectionManager.getInstance().getConnectionDescriptor(string);
        }
        return connectionDescriptor;
    }

    private static String getConnectionInfo(String string, Hashtable hashtable) {
        try {
            String string2;
            ConnectionDescriptor connectionDescriptor = Configuration.resolveConnection(string);
            if (connectionDescriptor == null) {
                Class clazz = class$oracle$jbo$common$CommonMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
                }
                ConfigException configException = new ConfigException(clazz, "33003", new Object[]{string});
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Configuration.getConnectionInfo() failed");
                    Diagnostic.printStackTrace(configException);
                }
                throw configException;
            }
            String string3 = connectionDescriptor.getUsername();
            String string4 = string2 = connectionDescriptor.isDeployPassword() ? connectionDescriptor.getPassword() : null;
            if (string3 != null) {
                hashtable.put(DB_USERNAME_PROPERTY, string3);
            }
            if (string2 != null) {
                hashtable.put(DB_PASSWORD_PROPERTY, string2);
            }
            String string5 = JboCMUtils.getJdbcUrl(connectionDescriptor);
            return string5;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.getConnectionInfo() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33003", new Object[]{string});
            configException.addToDetails(exception);
            throw configException;
        }
    }

    public void initializeFromConnectionName(Hashtable hashtable) {
        String string = null;
        boolean bl = false;
        String string2 = (String)hashtable.get(HTTP_CONNECTION_NAME);
        if (string2 != null) {
            string = Configuration.getConnectionInfo(string2, hashtable);
            bl = true;
        } else {
            string2 = (String)hashtable.get(JDBC_CONNECTION_NAME);
            if (string2 != null) {
                string = Configuration.getConnectionInfo(string2, hashtable);
                bl = true;
            }
            if ((string2 = (String)hashtable.get(JDBC_DS_NAME)) != null) {
                string = string2;
                ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor(string2);
                if (connectionDescriptor != null) {
                    if (Diagnostic.isOn()) {
                        // empty if block
                    }
                    Enumeration enumeration = connectionDescriptor.keys();
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        hashtable.put(e, connectionDescriptor.get(e));
                    }
                }
                bl = true;
            }
            if ((string2 = (String)hashtable.get(APPSERVER_CONNECTION_NAME)) != null) {
                try {
                    String string3;
                    String string4;
                    String string5;
                    ConnectionDescriptor connectionDescriptor = Configuration.resolveConnection(string2);
                    if (connectionDescriptor == null) {
                        Class clazz = class$oracle$jbo$common$CommonMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
                        }
                        ConfigException configException = new ConfigException(clazz, "33003", new Object[]{string2});
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Configuration.initializeFromConnectionName() failed");
                            Diagnostic.printStackTrace(configException);
                        }
                        throw configException;
                    }
                    String string6 = connectionDescriptor.getConnectionType();
                    if (string6.equals("IAS_via_REMOTE_DCM") || string6.equals("IAS_via_LOCAL_DCM") || string6.equals("Oracle_AS_10g")) {
                        string5 = connectionDescriptor.getProperty("ormi-client-url");
                        string4 = connectionDescriptor.getProperty("ormi-username");
                        string3 = connectionDescriptor.getProperty("ormi-password");
                    } else {
                        string5 = connectionDescriptor.getURL();
                        string4 = connectionDescriptor.getUsername();
                        string3 = connectionDescriptor.getPassword();
                    }
                    hashtable.put("java.naming.provider.url", string5);
                    if (hashtable.get(PropertyMetadata.HOST_NAME.getName()) == null) {
                        String string7 = JboCMUtils.getHostNameFromUrl(string5);
                        hashtable.put(PropertyMetadata.HOST_NAME.getName(), string7);
                    }
                    if (hashtable.get(PropertyMetadata.CONNECTION_PORT.getName()) == null) {
                        String string8 = Integer.toString(JboCMUtils.getPortFromUrl(string5));
                        hashtable.put(PropertyMetadata.CONNECTION_PORT.getName(), string8);
                    }
                    if (hashtable.get(PropertyMetadata.SECURITY_PRINCIPAL.getName()) == null && string4 != null) {
                        hashtable.put(PropertyMetadata.SECURITY_PRINCIPAL.getName(), string4);
                    }
                    if (hashtable.get(PropertyMetadata.SECURITY_CREDENTIALS.getName()) == null && string3 != null && connectionDescriptor.isDeployPassword()) {
                        String string9 = Configuration.getRestoredChecksumValue(string3);
                        hashtable.put(PropertyMetadata.SECURITY_CREDENTIALS.getName(), string9);
                    }
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Configuration.initializeFromConnectionName() failed");
                        Diagnostic.printStackTrace(exception);
                    }
                    if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                        clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
                    }
                    ConfigException configException = new ConfigException(clazz, "33003", new Object[]{string2});
                    configException.addToDetails(exception);
                    throw configException;
                }
            }
        }
        if (bl) {
            hashtable.put(DB_CONNECTION_PROPERTY, string);
        } else {
            hashtable.remove(DB_CONNECTION_PROPERTY);
        }
    }

    protected void registerConnectionsFromDocument() throws JboException {
        try {
            NodeList nodeList = this.getConnectionDefinitionNodes();
            if (nodeList == null) {
                return;
            }
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                String string = node.getAttributes().getNamedItem(ATTR_CONFIG_NAME).getNodeValue();
                NodeList nodeList2 = node.getChildNodes();
                ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node2 = nodeList2.item(n2);
                    String string2 = node2.getAttributes().getNamedItem(ATTR_CONFIG_NAME).getNodeValue();
                    String string3 = null;
                    string3 = string2.equals(DB_PASSWORD_PROPERTY) || string2.equals(PropertyMetadata.SECURITY_CREDENTIALS.pName) ? this.getPassword(node2) : node2.getAttributes().getNamedItem("value").getNodeValue();
                    if (string3 != null) {
                        connectionDescriptor.put((Object)string2, (Object)string3);
                    }
                    ++n2;
                }
                Configuration.getCM().putConnectionDescriptor(string, connectionDescriptor);
                ++n;
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.registerConnectionsFromDocument() failed");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33000", new Object[]{"registerConnectionsFromDocument"});
            configException.addToDetails(exception);
            throw configException;
        }
    }

    public ConnectionDescriptor getConnectionDescriptor(String string) {
        ConnectionDescriptor connectionDescriptor = null;
        try {
            Node node = this.findConnectionNode(string);
            if (node != null) {
                NodeList nodeList = node.getChildNodes();
                connectionDescriptor = new ConnectionDescriptor();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node2 = nodeList.item(n);
                    String string2 = node2.getAttributes().getNamedItem(ATTR_CONFIG_NAME).getNodeValue();
                    String string3 = null;
                    string3 = string2.equals(DB_PASSWORD_PROPERTY) || string2.equals(PropertyMetadata.SECURITY_CREDENTIALS.pName) ? this.getPassword(node2) : node2.getAttributes().getNamedItem("value").getNodeValue();
                    if (string3 != null) {
                        connectionDescriptor.put((Object)string2, (Object)string3);
                    }
                    ++n;
                }
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.getConnectionDescriptor() failed");
                Diagnostic.printStackTrace(exception);
            }
            throw new JboException(exception);
        }
        return connectionDescriptor;
    }

    public void updateConnectionDefinition(String string, ConnectionDescriptor connectionDescriptor) {
        this.removeConnectionEntry(string);
        this.createNewConnectionEntry(string, (Properties)connectionDescriptor);
    }

    private Node findConnectionNode(String string) {
        try {
            NodeList nodeList = this.getConnectionDefinitionNodes();
            if (nodeList != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    String string2 = node.getAttributes().getNamedItem(ATTR_CONFIG_NAME).getNodeValue();
                    if (string2.equals(string)) {
                        Node node2 = node;
                        return node2;
                    }
                    ++n;
                }
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.findConnectionNode() failed");
                Diagnostic.printStackTrace(exception);
            }
            throw new JboException(exception);
        }
        return null;
    }

    protected void removeConnectionEntry(String string) {
        NodeList nodeList = this.getConnectionDefinitionNodes();
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = node.getAttributes().getNamedItem(ATTR_CONFIG_NAME).getNodeValue();
            if (string2.equalsIgnoreCase(string)) {
                node.getParentNode().removeChild(node);
                return;
            }
            ++n;
        }
    }

    public void createNewConnectionEntry(String string, Properties properties) {
        if (this.configDocument == null) {
            return;
        }
        this.removeConnectionEntry(string);
        Element element = this.configDocument.createElement(CONNECTION_DEF_NAME);
        element.setAttribute(ATTR_CONFIG_NAME, string);
        this.configDocument.getDocumentElement().appendChild(element);
        boolean bl = true;
        if (properties.containsKey("ConnectionType") && properties.getProperty("ConnectionType").equals("OC4J")) {
            bl = properties.containsKey("DeployPassword") ? Boolean.valueOf(properties.getProperty("DeployPassword")) : false;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.get(string2);
            Element element2 = this.configDocument.createElement("ENTRY");
            element2.setAttribute(ATTR_CONFIG_NAME, string2);
            if (string2.equals(DB_PASSWORD_PROPERTY) || string2.equals(PropertyMetadata.SECURITY_CREDENTIALS.pName)) {
                String string4 = Configuration.getChecksumValue(string3);
                if (string4 != null) {
                    CDATASection cDATASection = this.configDocument.createCDATASection(string4);
                    element2.appendChild(cDATASection);
                } else {
                    element2.setAttribute("value", string3);
                }
            } else {
                element2.setAttribute("value", string3);
            }
            element.appendChild(element2);
        }
        if (bl) {
            Element element3 = this.configDocument.createElement("ENTRY");
            element3.setAttribute(ATTR_CONFIG_NAME, "DeployPassword");
            element3.setAttribute("value", "true");
            element.appendChild(element3);
        }
    }

    protected void removeConfigurationProperty(String string, String string2) {
        Node node = this.getConfigurationNode(string);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeName().equals(string2)) {
                    node.removeChild(node2);
                    break;
                }
                ++n;
            }
        } else {
            Class clazz = class$oracle$jbo$common$CommonMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Configuration.class$("oracle.jbo.common.CommonMessageBundle");
            }
            ConfigException configException = new ConfigException(clazz, "33005", new Object[]{string});
            if (Diagnostic.isOn()) {
                Diagnostic.println("Configuration.removeConfigurationProperty() failed");
                Diagnostic.printStackTrace(configException);
            }
            throw configException;
        }
    }

    public static void releaseRootApplicationModule(ApplicationModule applicationModule, boolean bl) {
        SessionCookie sessionCookie = (SessionCookie)applicationModule.getSession().getEnvironment().get(JBO_SESSION_COOKIE);
        if (sessionCookie != null) {
            String string = (String)sessionCookie.getUserData().get(SESSION_POOL_NAME);
            string = string == null ? applicationModule.getDefFullName() : string;
            ApplicationPool applicationPool = (ApplicationPool)PoolMgr.getInstance().getResourcePool(string);
            int n = 1;
            if (bl) {
                n |= 4;
            }
            sessionCookie.releaseApplicationModule(n);
            if (applicationPool != null) {
                applicationPool.removeSessionCookie(sessionCookie);
            }
        }
    }

    public static ApplicationModule createRootApplicationModule(String string, String string2) {
        return Configuration.createRootApplicationModule(string, string2, null);
    }

    public static ApplicationModule createRootApplicationModule(String string, String string2, EnvInfoProvider envInfoProvider) {
        String string3 = null;
        if (string != null) {
            string3 = JboNameUtil.getContainerPartOfName(string);
        }
        ApplicationPool applicationPool = PoolMgr.getInstance().findPool(string3 + "." + string2, string3, string2, null);
        return Configuration.getApplicationModule(applicationPool, envInfoProvider);
    }

    public ApplicationModule createRootApplicationModuleFromConfig(String string, EnvInfoProvider envInfoProvider) {
        ApplicationPool applicationPool = PoolMgr.getInstance().findPool(this.mConfigPackage + "." + string, this, string);
        return Configuration.getApplicationModule(applicationPool, envInfoProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationModule getApplicationModule(ApplicationPool applicationPool, EnvInfoProvider envInfoProvider) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        Object object = mStaticLock;
        synchronized (object) {
            l2 = mCounter++;
        }
        String string = Long.toString(l + l2);
        SessionCookie sessionCookie = applicationPool.createSessionCookie(string, string, null);
        sessionCookie.getUserData().put(SESSION_POOL_NAME, applicationPool.getName());
        sessionCookie.setEnvInfoProvider(envInfoProvider);
        ApplicationModule applicationModule = sessionCookie.useApplicationModule();
        return applicationModule;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if ("-name".equals(string4)) {
                if (n + 1 >= stringArray.length) {
                    bl = true;
                }
                string = stringArray[n + 1];
                ++n;
            } else {
                string2 = string4;
                if (n + 1 < stringArray.length) {
                    string3 = stringArray[n + 1];
                    ++n;
                }
            }
            ++n;
        }
        if (bl || string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) {
            Configuration.printUsage();
            System.exit(0);
        }
        Configuration configuration = new Configuration();
        configuration.updateConfigurationFile(string, string2, string3);
    }

    private void updateAndSaveConfiguration(OutputStream outputStream, String string, String string2, String string3) throws IOException {
        boolean bl = false;
        Node node = this.getConfigurationNode(string);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (string2.equals(node2.getNodeName())) {
                if (string3 != null && string3.length() > 0) {
                    Text text = (Text)node2.getFirstChild();
                    text.setNodeValue(string3);
                } else {
                    node.removeChild(node2);
                }
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl && string3 != null && string3.length() > 0) {
            Element element = this.configDocument.createElement(string2);
            Text text = this.configDocument.createTextNode(string3);
            element.appendChild(text);
            node.appendChild(element);
        }
        this.configDocument.print(outputStream);
    }

    /*
     * Loose catch block
     */
    private void updateConfigurationFile(String string, String string2, String string3) {
        block22: {
            InputStream inputStream;
            OutputStream outputStream;
            File file;
            block21: {
                int n;
                int n2 = string.lastIndexOf(46);
                String string4 = string.substring(0, n2);
                string = string.substring(n2 + 1);
                String string5 = Configuration.buildConfigurationFileNameFromClassPath(string4);
                this.loadFromClassPath(string5);
                String string6 = "/" + string5;
                string6 = string6.replace(File.separatorChar, '/');
                ClassLoader classLoader = JBOClass.getCurrentClassLoader();
                URL uRL = this.findConfigurationURL(classLoader, string6);
                file = null;
                outputStream = null;
                inputStream = null;
                FileInputStream fileInputStream = null;
                boolean bl = false;
                try {
                    fileInputStream = new FileInputStream(uRL.getFile());
                }
                catch (IOException iOException) {
                    bl = true;
                }
                if (bl) {
                    String string7 = uRL.getFile() + string6.substring(1);
                    outputStream = new BufferedOutputStream(new FileOutputStream(string7), 512);
                    this.updateAndSaveConfiguration(outputStream, string, string2, string3);
                    outputStream.flush();
                    break block21;
                }
                file = File.createTempFile("jboconfig", null);
                file.deleteOnExit();
                JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(fileInputStream, 512));
                inputStream = jarInputStream;
                JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file), 512));
                outputStream = jarOutputStream;
                ZipEntry zipEntry = jarInputStream.getNextEntry();
                ZipEntry zipEntry2 = null;
                byte[] byArray = new byte[512];
                while (zipEntry != null) {
                    if (string6.equals(zipEntry.getName()) || string6.substring(1).equals(zipEntry.getName())) {
                        zipEntry2 = new ZipEntry(zipEntry.getName());
                        jarOutputStream.putNextEntry(zipEntry2);
                        this.updateAndSaveConfiguration(jarOutputStream, string, string2, string3);
                    } else {
                        int n3;
                        zipEntry2 = (ZipEntry)zipEntry.clone();
                        jarOutputStream.putNextEntry(zipEntry2);
                        while ((n3 = jarInputStream.read(byArray, 0, byArray.length)) != -1) {
                            jarOutputStream.write(byArray, 0, n3);
                        }
                    }
                    jarOutputStream.flush();
                    jarOutputStream.closeEntry();
                    zipEntry = jarInputStream.getNextEntry();
                }
                jarOutputStream.finish();
                outputStream.close();
                inputStream.close();
                outputStream = new BufferedOutputStream(new FileOutputStream(uRL.getFile()), 512);
                inputStream = new BufferedInputStream(new FileInputStream(file), 512);
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
            }
            Object var27_24 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (file != null) {
                    file.delete();
                }
                break block22;
            }
            catch (IOException iOException) {}
            break block22;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException(iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var27_25 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (file != null) {
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private URL findConfigurationURL(ClassLoader classLoader, String string) {
        URL uRL = null;
        ClassLoader classLoader2 = classLoader.getParent();
        if (classLoader2 != null) {
            uRL = this.findConfigurationURL(classLoader2, string);
        }
        if (uRL == null && classLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            URL[] uRLArray2 = new URL[1];
            int n = 0;
            while (n < uRLArray.length) {
                uRLArray2[0] = uRLArray[n];
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray2, null);
                InputStream inputStream = uRLClassLoader.getResourceAsStream(string.substring(1));
                if (inputStream == null) {
                    inputStream = uRLClassLoader.getResourceAsStream(string);
                }
                if (inputStream != null) {
                    uRL = uRLArray2[0];
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                ++n;
            }
        }
        return uRL;
    }

    private static void printUsage() {
        System.out.println("Usage:  java -cp <classpath> -name <fully qualified configuration name> <property name> <property value>");
        System.out.println("Example:  java -cp <classpath> -name mypackage1.Mypackage1ModuleLocal jbo.doconnectionpooling true");
        System.out.println("Notes:  The classpath must include bc4jct.jar and the bc4j.xcfg in which the target configuration is defined.");
    }

    public String getPassword(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            Node node2 = nodeList.item(0);
            if (node2 != null) {
                string = Configuration.getRestoredChecksumValue(node2.getNodeValue());
            }
        } else {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                string = namedNodeMap.getNamedItem("value").getNodeValue();
            }
        }
        return string;
    }

    public static final String getChecksumValue(String string) {
        String string2;
        block3: {
            string2 = null;
            if (string != null && !string.startsWith(CHECKSUM_904)) {
                try {
                    byte[] byArray = Checksum.MD5((byte[])string.getBytes(), (byte[])checksumKey);
                    StringBuffer stringBuffer = new StringBuffer(CHECKSUM_904);
                    stringBuffer.append(RepConversion.bArray2String(byArray));
                    string2 = stringBuffer.toString();
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block3;
                    exception.printStackTrace();
                }
            }
        }
        return string2;
    }

    public static final String getRestoredChecksumValue(String string) {
        String string2 = string;
        if (string != null && string.startsWith(CHECKSUM_904)) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray = RepConversion.convertHexStringToByte(string.substring(CHECKSUM_904.length()));
                byArray2 = Checksum.SHA((byte[])byArray, (byte[])checksumKey);
                string2 = new String(byArray2);
            }
            catch (Exception exception) {
                if (Diagnostic.isOn()) {
                    exception.printStackTrace();
                }
                Configuration.checkSecurityProviders();
                try {
                    byArray2 = Checksum.SHA((byte[])byArray, (byte[])checksumKey);
                    string2 = new String(byArray2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    static void checkSecurityProviders() {
        block9: {
            Provider[] providerArray = Security.getProviders();
            boolean bl = false;
            int n = 0;
            while (n < providerArray.length) {
                if (providerArray[n].getName().equals("SUN")) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                try {
                    Class clazz;
                    block8: {
                        clazz = null;
                        try {
                            clazz = JBOClass.forName("sun.security.provider.Sun");
                        }
                        catch (Exception exception) {
                            if (!Diagnostic.isOn()) break block8;
                            exception.printStackTrace();
                        }
                    }
                    if (clazz != null) {
                        Security.addProvider((Provider)clazz.newInstance());
                    }
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block9;
                    exception.printStackTrace();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

