/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.reflect.Constructor;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboException;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUPanelStopEditingListener;
import oracle.jbo.uicli.jui.JUTableSortModel;

public class JUTableBinding
extends JUCtrlRangeBinding
implements TableModel,
JUPanelStopEditingListener,
HierarchyListener {
    static /* synthetic */ Class class$java$lang$String;
    private JUTableModel mTableModel;
    private JScrollPane mScrollPane;
    private JUTableScrollBarListener mScrollBarListener;
    private int mScrollUnit;
    private boolean mParentSearched;
    private int mNumVisRows;
    private JboException mError;
    boolean mColumnSort;
    static int DEF_TABLE_ROW_COUNT = 10;
    JUPanelBinding mPanelBinding;
    boolean inStopEditing;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getControlModel(Object object) {
        this.setControl(object);
        JUTableModel jUTableModel = this.getModelImpl((JTable)object);
        if (this.mColumnSort) {
            return JUTableSortModel.enableColumnSorting((JTable)object, this, null);
        }
        return jUTableModel;
    }

    public static TableModel createAttributeListBinding(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray) {
        return JUTableBinding.createAttributeListBinding(jUPanelBinding, jTable, string, string2, string3, stringArray, false, null);
    }

    public static TableModel createAttributeListBinding(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray, boolean bl, JUTableSortModel jUTableSortModel) {
        if (!JUIUtil.inDesignTime()) {
            JUTableBinding jUTableBinding = new JUTableBinding(jTable, jUPanelBinding.getRowIterBinding(string, string2, string3), stringArray);
            jUTableBinding.refreshControl();
            jUTableBinding.mPanelBinding = jUPanelBinding;
            jUTableBinding.findParent();
            JUTableModel jUTableModel = jUTableBinding.getModel();
            if (bl) {
                return JUTableSortModel.enableColumnSorting(jTable, jUTableBinding, jUTableSortModel);
            }
            return jUTableModel;
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJTableBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            int n = 0;
            while (n < constructorArray.length) {
                if (constructorArray[n].getParameterTypes().length == 2) {
                    constructor = constructorArray[n];
                }
                ++n;
            }
            String string4 = "";
            if (stringArray != null && stringArray.length != 0) {
                string4 = stringArray[0];
            }
            int n2 = stringArray == null ? 0 : stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append(",");
                stringBuffer.append(stringArray[n3]);
                ++n3;
            }
            Object[] objectArray = new Object[]{String.valueOf(string) + "." + stringBuffer.toString(), new Boolean(bl)};
            Object obj = constructor.newInstance(objectArray);
            TableModel tableModel = (TableModel)obj;
            return tableModel;
        }
        catch (Exception exception) {
            TableModel tableModel = null;
            return tableModel;
        }
    }

    public static TableModel getInstance(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray) {
        return JUTableBinding.createAttributeListBinding(jUPanelBinding, jTable, string, string2, string3, stringArray);
    }

    public JUTableBinding(JTable jTable, JUIteratorBinding jUIteratorBinding, String[] stringArray) {
        super((Object)jTable, (DCIteratorBinding)jUIteratorBinding, stringArray);
        this.setControl(jTable);
    }

    public void setControl(Object object) {
        JTable jTable = (JTable)object;
        super.setControl((Object)jTable);
        if (jTable != null) {
            if (this.mTableModel != jTable.getModel()) {
                this.mTableModel = this.getModelImpl(jTable);
            }
            jTable.addHierarchyListener(this);
            this.findParent();
        } else if (this.getControl() != null) {
            jTable = (JTable)this.getControl();
            jTable.removeHierarchyListener(this);
            jTable.setModel(new DefaultTableModel());
        }
    }

    public void stopEditing() {
        if (this.inStopEditing) {
            return;
        }
        JTable jTable = (JTable)this.getControl();
        if (jTable == null) {
            return;
        }
        TableCellEditor tableCellEditor = jTable.getCellEditor();
        if (tableCellEditor != null) {
            DCBindingContainer dCBindingContainer = this.getBindingContainer();
            boolean bl = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    this.inStopEditing = true;
                    tableCellEditor.stopCellEditing();
                }
                catch (JboException jboException) {
                    ((JUPanelBinding)this.getFormBinding()).setEditingStopped(false);
                    if (!bl) {
                        throw jboException;
                    }
                    Diagnostic.println((String)("Ignoring handled exception :" + jboException.getMessage()));
                    Object var7_6 = null;
                    this.inStopEditing = false;
                }
                Object var7_5 = null;
                this.inStopEditing = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.inStopEditing = false;
                throw throwable;
            }
        }
    }

    public JUTableModel getModel() {
        return this.mTableModel;
    }

    protected JUTableModel getModelImpl(JTable jTable) {
        JUTableModel jUTableModel = this.mTableModel;
        if (jUTableModel == null) {
            jUTableModel = new JUTableModel(jTable);
            ((JUPanelBinding)this.getFormBinding()).addBindingWithCellEditor(this);
        }
        return jUTableModel;
    }

    protected boolean isControlQueriable() {
        return true;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    public Object getLayoutObject() {
        if (this.mScrollPane == null) {
            return this.getControl();
        }
        return this.mScrollPane;
    }

    void findParent() {
        if (this.mScrollPane == null && !this.mParentSearched) {
            this.mParentSearched = true;
            JTable jTable = (JTable)this.getControl();
            if (jTable != null) {
                Container container = jTable.getParent();
                while (container != null) {
                    if (container instanceof JScrollPane) break;
                    container = container.getParent();
                }
                if (container != null) {
                    this.setLayoutObject((JScrollPane)container);
                }
            }
        }
    }

    public void setLayoutObject(JScrollPane jScrollPane) {
        if (this.mScrollPane != null) {
            this.mScrollPane.getViewport().removeChangeListener(this.mTableModel);
            if (this.mScrollBarListener != null) {
                this.mScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.mScrollBarListener);
                this.mScrollBarListener = null;
            }
        }
        boolean bl = this.mScrollPane != jScrollPane;
        this.mScrollPane = jScrollPane;
        this.mNumVisRows = 0;
        if (this.mScrollPane != null) {
            this.mScrollPane.getViewport().addChangeListener(this.mTableModel);
            this.mScrollBarListener = new JUTableScrollBarListener();
            this.mScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.mScrollBarListener);
            if (bl) {
                this.mTableModel.stateChanged(null);
            }
        }
    }

    int getScrollUnit() {
        return this.mScrollUnit;
    }

    protected int getDefaultVisibleRowCount() {
        return 10;
    }

    public void updateValuesFromRows(Row[] rowArray, boolean bl) {
        if (this.mTableModel != null) {
            this.mError = null;
            this.mTableModel.refresh(bl);
        }
    }

    public void updateRangeScrolled(ScrollEvent scrollEvent) {
        this.mTableModel.updateRangeScrolled(scrollEvent);
    }

    public void updateRowInserted(InsertEvent insertEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        super.updateRowInserted(insertEvent);
        if (this.mTableModel != null) {
            this.mTableModel.refresh(true);
        }
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.removeEditor();
        }
        super.updateRowDeleted(deleteEvent);
        if (jTable != null) {
            jTable.clearSelection();
            if (this.mTableModel != null) {
                this.mTableModel.refresh(true);
            }
        }
    }

    public void updateNavigated(NavigationEvent navigationEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.removeEditor();
        }
        if (this.mTableModel != null) {
            this.mTableModel.updateNavigated(navigationEvent);
        }
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.findParent();
        if (this.mNumVisRows == 0 && this.mTableModel != null) {
            this.mTableModel.stateChanged(null);
        }
    }

    public int getRowCount() {
        return this.mTableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.mTableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.mTableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.mTableModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.mTableModel.isCellEditable(n, n2);
    }

    public Object getValueAt(int n, int n2) {
        return this.mTableModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.mTableModel.setValueAt(object, n, n2);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.mTableModel.addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.mTableModel.removeTableModelListener(tableModelListener);
    }

    JUTableBinding getMyBinding() {
        return this;
    }

    void forceSync() {
        DCDataControl dCDataControl = this.getIteratorBinding().getDataControl();
        if (dCDataControl != null && dCDataControl.syncNeeded()) {
            ((JUPanelBinding)this.getBindingContainer()).requestRefreshControl();
        }
    }

    class JUTableScrollBarListener
    implements ChangeListener {
        private boolean mInScrollBarStateChange;

        JUTableScrollBarListener() {
        }

        boolean isInScrollBarStateChange() {
            return this.mInScrollBarStateChange;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (jUIteratorBinding == null || !jUIteratorBinding.isIteratorMadeVisible()) {
                return;
            }
            if (!jUIteratorBinding.isFindMode() && jUIteratorBinding.getRangeSize() != -1 && jUIteratorBinding.getDataControl() != null && !jUIteratorBinding.getDataControl().syncNeeded()) {
                int n;
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                int n2 = boundedRangeModel.getValue();
                int n3 = boundedRangeModel.getExtent();
                int n4 = n2 / JUTableBinding.this.mScrollUnit;
                RowIterator rowIterator = JUTableBinding.this.getRowIterator();
                if (rowIterator == null) {
                    return;
                }
                int n5 = rowIterator.getRangeStart();
                if (n5 < 0) {
                    n5 = 0;
                }
                if ((n = n4 - n5) == 0) {
                    return;
                }
                if (this.mInScrollBarStateChange) {
                    return;
                }
                this.mInScrollBarStateChange = true;
                try {
                    rowIterator.scrollRange(n);
                    Object var11_10 = null;
                    this.mInScrollBarStateChange = false;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    this.mInScrollBarStateChange = false;
                    throw throwable;
                }
            }
        }
    }

    protected class JUTableModel
    extends AbstractTableModel
    implements ListSelectionListener,
    ChangeListener {
        private boolean mSelRowInProg;
        private boolean mBatchMode;
        private UpdateNavigatedRunnableImpl mRunnableUpdateNavigated;
        private boolean mRunnableRefreshLaterSelectRow;
        private Runnable mRunnableRefeshLater;
        private Runnable mRunnableReportException;

        JUTableModel(JTable jTable) {
            ListSelectionModel listSelectionModel;
            JUTableBinding.this.mScrollUnit = jTable.getScrollableUnitIncrement(null, 1, 0);
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof JUTableBinding) {
                listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.removeListSelectionListener(((JUTableBinding)tableModel).mTableModel);
            }
            if (tableModel instanceof JUTableModel) {
                listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.removeListSelectionListener((JUTableModel)tableModel);
            }
            ((JTable)JUTableBinding.this.getMyBinding().getControl()).setModel(this);
            listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(this);
        }

        void fireTableDataChangedRestoreSelection(boolean bl) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            if (jTable == null) {
                return;
            }
            int n = jTable.getSelectedRow();
            this.mSelRowInProg = true;
            try {
                this.fireTableDataChanged();
                if (bl && n >= 0 && this.getRowCount() > 0 && jTable.getSelectedRow() < 0 && n >= 0) {
                    this.selectRowOfIndex(n);
                }
                Object var5_4 = null;
                this.mSelRowInProg = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mSelRowInProg = false;
                throw throwable;
            }
        }

        void updateRangeScrolled(ScrollEvent scrollEvent) {
            if (JUTableBinding.this.mScrollBarListener != null && !JUTableBinding.this.mScrollBarListener.isInScrollBarStateChange()) {
                JUTableBinding.this.mScrollPane.getVerticalScrollBar().setValue(scrollEvent.getRangeStart() * JUTableBinding.this.mScrollUnit);
            }
            this.fireTableDataChangedRestoreSelection(true);
        }

        void updateNavigated(NavigationEvent navigationEvent) {
            int n = navigationEvent.getRowIndex();
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator != null) {
                int n2 = rowIterator.getRangeStart();
                if (n2 < 0 || this.mBatchMode) {
                    n2 = 0;
                }
                int n3 = n < 0 ? -1 : n + n2;
                JTable jTable = (JTable)JUTableBinding.this.getControl();
                if (jTable != null && n3 >= 0 && jTable.getSelectedRow() != n3 && jTable.getAutoscrolls()) {
                    if (this.mRunnableUpdateNavigated != null) {
                        this.mRunnableUpdateNavigated.setRowIndex(n3);
                    } else {
                        this.mRunnableUpdateNavigated = new UpdateNavigatedRunnableImpl(n3);
                        SwingUtilities.invokeLater(this.mRunnableUpdateNavigated);
                    }
                }
            }
        }

        private void selectRowOfIndex(int n) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            if (jTable == null) {
                return;
            }
            if (n >= 0) {
                jTable.getSelectionModel().setSelectionInterval(n, n);
            } else {
                jTable.getSelectionModel().clearSelection();
            }
        }

        private void refresh(boolean bl) {
            this.mRunnableRefreshLaterSelectRow = bl;
            if (this.mRunnableRefeshLater == null) {
                this.mRunnableRefeshLater = new Runnable(this){
                    final /* synthetic */ JUTableModel this$0;

                    public void run() {
                        JTable jTable = (JTable)this.this$0.JUTableBinding.this.getControl();
                        if (jTable != null && jTable.isEditing()) {
                            jTable.removeEditor();
                        }
                        JUTableModel.access$7000849(this.this$0, null);
                        JUTableModel.access$7000971(this.this$0, JUTableModel.access$7001071(this.this$0));
                    }
                    {
                        this.this$0 = jUTableModel;
                    }
                };
                SwingUtilities.invokeLater(this.mRunnableRefeshLater);
            }
        }

        private void reportExceptionLater() {
            if (this.mRunnableReportException == null) {
                this.mRunnableReportException = new Runnable(this){
                    final /* synthetic */ JUTableModel this$0;

                    public void run() {
                        if (JUTableBinding.access$7001171(this.this$0.JUTableBinding.this) != null) {
                            JUTableModel.access$7001249(this.this$0, null);
                            this.this$0.JUTableBinding.this.reportException((Exception)((Object)JUTableBinding.access$7001171(this.this$0.JUTableBinding.this)));
                        }
                    }
                    {
                        this.this$0 = jUTableModel;
                    }
                };
                SwingUtilities.invokeLater(this.mRunnableReportException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void _refreshLater(boolean bl) {
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator == null) return;
            if (JUTableBinding.this.mError != null) return;
            DCBindingContainer dCBindingContainer = JUTableBinding.this.getBindingContainer();
            boolean bl2 = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    if (bl2) {
                        dCBindingContainer.setErrorHandlerActive(false);
                    }
                    this.fireTableDataChangedRestoreSelection(!bl);
                    if (bl && rowIterator.getCurrentRowSlot() != 1) {
                        int n = -1;
                        int n2 = rowIterator.getCurrentRowIndex();
                        if (n2 >= 0) {
                            int n3 = rowIterator.getRangeStart();
                            if (n3 < 0) {
                                n3 = 0;
                            }
                            if (this.mBatchMode) {
                                n2 -= n3;
                            }
                            n = n2 > 0 ? n2 : n3;
                            this.mSelRowInProg = true;
                            try {
                                this.selectRowOfIndex(n);
                                Object var9_9 = null;
                                this.mSelRowInProg = false;
                            }
                            catch (Throwable throwable) {
                                Object var9_10 = null;
                                this.mSelRowInProg = false;
                                throw throwable;
                            }
                        }
                    }
                    Object var11_12 = null;
                }
                catch (JboException jboException) {
                    dCBindingContainer.setErrorHandlerActive(bl2);
                    if (JUTableBinding.this.mError == null) {
                        JUTableBinding.this.mError = jboException;
                        this.reportExceptionLater();
                    }
                    Object var11_13 = null;
                    dCBindingContainer.setErrorHandlerActive(bl2);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                dCBindingContainer.setErrorHandlerActive(bl2);
                throw throwable;
            }
            dCBindingContainer.setErrorHandlerActive(bl2);
        }

        public String getColumnName(int n) {
            AttributeDef attributeDef = JUTableBinding.this.getAttributeDef(n);
            return attributeDef != null ? JUTableBinding.this.getLabel(attributeDef.getName(), null) : Integer.toString(n);
        }

        public Class getColumnClass(int n) {
            AttributeDef attributeDef;
            if (!JUTableBinding.this.getIteratorBinding().isFindMode() && (attributeDef = JUTableBinding.this.getAttributeDef(n)) != null && !attributeDef.getUIHelper().hasFormatInformation(null)) {
                return attributeDef.getJavaType();
            }
            return class$java$lang$String == null ? (class$java$lang$String = JUTableBinding.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return JUTableBinding.this.getAttributeCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getRowCount() {
            if (JUTableBinding.this.mError != null) {
                return 0;
            }
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (jUIteratorBinding == null) return 0;
            if (!jUIteratorBinding.isIteratorMadeVisible()) {
                if (!jUIteratorBinding.isFindMode()) return 0;
            }
            DCBindingContainer dCBindingContainer = JUTableBinding.this.getBindingContainer();
            boolean bl = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    this.mBatchMode = !jUIteratorBinding.isFindMode() && jUIteratorBinding.getRangeSize() != -1 && jUIteratorBinding.getDataControl() != null && jUIteratorBinding.getDataControl().syncNeeded();
                    if (this.mBatchMode) int n;
                    int n2;
                    return (n2 = jUIteratorBinding.getNavigatableRowIterator().getRangeSize()) > (n = jUIteratorBinding.getNavigatableRowIterator().getRowCountInRange()) ? n : n2;
                    return (int)JUTableBinding.this.getEstimatedRowCount();
                }
                catch (JboException jboException) {
                    if (JUTableBinding.this.mError != null) return 0;
                    JUTableBinding.this.mError = jboException;
                    this.reportExceptionLater();
                    return 0;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                throw throwable;
            }
        }

        private int rowIndexToRangeIndex(int n) {
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator != null && !this.mBatchMode) {
                int n2 = rowIterator.getRangeStart();
                if (n2 <= 0) {
                    return n;
                }
                return n - n2;
            }
            return n;
        }

        public boolean isCellEditable(int n, int n2) {
            if (JUTableBinding.this.mPanelBinding != null) {
                JUTableBinding.this.mPanelBinding.focusGained((DCIteratorBinding)JUTableBinding.this.getIteratorBinding(), (DCControlBinding)JUTableBinding.this.getMyBinding(), -1);
            }
            int n3 = this.rowIndexToRangeIndex(n);
            Object object = JUTableBinding.this.getIteratorBinding().getSyncLock();
            synchronized (object) {
                try {
                    try {
                        Row[] rowArray = JUTableBinding.this.getAllRowsInRange();
                        AttributeDef attributeDef = JUTableBinding.this.getAttributeDef(n2);
                        if (attributeDef != null && n3 >= 0 && n3 < rowArray.length) {
                            boolean bl = rowArray[n3].isAttributeUpdateable(attributeDef.getIndex());
                            Object var9_9 = null;
                            return bl;
                        }
                    }
                    catch (Exception exception) {
                        JUTableBinding.this.reportException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    throw throwable;
                }
                Object var9_10 = null;
                {
                }
            }
            return true;
        }

        public Object getValueAt(int n, int n2) {
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            NavigatableRowIterator navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator();
            if (navigatableRowIterator != null) {
                RowSet rowSet;
                if (!jUIteratorBinding.isFindMode() && (rowSet = ((RowSetIterator)navigatableRowIterator).getRowSet()) != null && !rowSet.isExecuted()) {
                    return null;
                }
                int n3 = this.rowIndexToRangeIndex(n);
                if (n3 >= 0) {
                    return JUTableBinding.this.getAttributeFromRow(n3, n2);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            int n3 = this.rowIndexToRangeIndex(n);
            try {
                JUTableBinding.this.setAttributeInRow(n3, n2, object, false);
            }
            catch (JboException jboException) {
                JUTableBinding.this.reportException((Exception)((Object)jboException), true);
                throw jboException;
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (this.mSelRowInProg || listSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                RowIterator rowIterator = JUTableBinding.this.getRowIterator();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n;
                    if (rowIterator == null) {
                        return;
                    }
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    int n3 = rowIterator.getRangeSize();
                    int n4 = rowIterator.getRangeStart();
                    if (n4 < 0 || this.mBatchMode) {
                        n4 = 0;
                    }
                    int n5 = n2 - n4;
                    if (n3 > 0) {
                        if (n5 >= n3) {
                            n5 = n5 - rowIterator.getRangeSize() + 1;
                            rowIterator.scrollRange(n5);
                            n5 = n2 - n4;
                        } else if (n5 < 0) {
                            rowIterator.scrollRange(n5);
                            n5 = 0;
                        }
                    }
                    if ((n = rowIterator.getRangeIndexOf(rowIterator.getCurrentRow())) != n5 && JUTableBinding.this.getFormBinding() != null) {
                        ((JUPanelBinding)JUTableBinding.this.getFormBinding()).callBeforeRowNavigated((DCIteratorBinding)JUTableBinding.this.getIteratorBinding());
                    }
                    rowIterator.setCurrentRowAtRangeIndex(n5);
                }
            }
            catch (Exception exception) {
                JUTableBinding.this.reportException(exception);
                this.refresh(true);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = -1;
            int n2 = 0;
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (JUTableBinding.this.mScrollPane != null) {
                n2 = JUTableBinding.this.mScrollPane.getViewport().getHeight();
            } else if (jTable != null) {
                n2 = jTable.getHeight();
            }
            if (n2 == 0) {
                n = jUIteratorBinding != null && jUIteratorBinding.getRangeSize() > 1 ? jUIteratorBinding.getRangeSize() : (JUTableBinding.this.mScrollPane == null ? JUTableBinding.this.getDefaultVisibleRowCount() : 0);
            } else {
                int n3 = JUTableBinding.this.mScrollUnit;
                n = n2 / n3;
                if (n2 % n3 != 0) {
                    ++n;
                }
            }
            if (n != 0 && jUIteratorBinding != null) {
                this.resolveRangeSize(n);
            }
        }

        void resolveRangeSize(int n) {
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            int n2 = jUIteratorBinding.getRangeSize();
            if (n2 != n) {
                jUIteratorBinding.resolveRangeSize(n);
                JUTableBinding.this.forceSync();
                JUTableBinding.this.mNumVisRows = jUIteratorBinding.getRangeSize();
            }
        }

        static /* synthetic */ void access$7000971(JUTableModel jUTableModel, boolean bl) {
            jUTableModel._refreshLater(bl);
        }

        static /* synthetic */ Runnable access$7001249(JUTableModel jUTableModel, Runnable runnable) {
            jUTableModel.mRunnableReportException = runnable;
            return jUTableModel.mRunnableReportException;
        }

        static /* synthetic */ Runnable access$7000849(JUTableModel jUTableModel, Runnable runnable) {
            jUTableModel.mRunnableRefeshLater = runnable;
            return jUTableModel.mRunnableRefeshLater;
        }

        static /* synthetic */ boolean access$7001071(JUTableModel jUTableModel) {
            return jUTableModel.mRunnableRefreshLaterSelectRow;
        }

        class UpdateNavigatedRunnableImpl
        implements Runnable {
            int rowIndex;

            UpdateNavigatedRunnableImpl(int n) {
                this.rowIndex = n;
            }

            void setRowIndex(int n) {
                this.rowIndex = n;
            }

            public void run() {
                JTable jTable;
                JUTableModel.this.mRunnableUpdateNavigated = null;
                if (Diagnostic.isOn()) {
                    Diagnostic.println((String)("Navigating to " + this.rowIndex));
                }
                if ((jTable = (JTable)JUTableBinding.this.getControl()) != null) {
                    Rectangle rectangle = jTable.getCellRect(this.rowIndex, 0, false);
                    if (rectangle != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                    JUTableModel.this.mSelRowInProg = true;
                    try {
                        JUTableModel.this.selectRowOfIndex(this.rowIndex);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        JUTableModel.this.mSelRowInProg = false;
                        throw throwable;
                    }
                    JUTableModel.this.mSelRowInProg = false;
                    {
                    }
                }
            }
        }
    }
}

