/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCBindingContainerReference;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.layout.DCLayoutConsDef;
import oracle.jbo.ApplicationModule;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoObjException;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.Transaction;
import oracle.jbo.UpdateEvent;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.uicli.binding.JUApplication;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUIteratorChangedListener;
import oracle.jbo.uicli.jui.JUNavigationBarInterface;
import oracle.jbo.uicli.jui.JUPanelRowSetListener;
import oracle.jbo.uicli.jui.JUPanelStopEditingListener;
import oracle.jbo.uicli.jui.JUSVUpdateableFocusAdapter;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public class JUPanelBinding
extends JUFormBinding {
    static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;
    protected String mAppName = "";
    String mAMName;
    protected ArrayList mNavigationBarList;
    protected ArrayList mIteratorChangedListeners;
    ArrayList mRowSetListeners;
    ArrayList mBindingsWithCellEditor;
    DCControlBinding mBindingInFocus;
    boolean mEditingStopped = true;
    private boolean mNavBarInit;
    boolean mRequestRefreshControl;
    Runnable mRunLater;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JUPanelBinding() {
    }

    public JUPanelBinding setup(BindingContext bindingContext, Object object) {
        JUPanelBinding jUPanelBinding = this;
        Object object2 = bindingContext.get((Object)this.getName());
        if (object2 instanceof DCBindingContainerReference) {
            jUPanelBinding = (JUPanelBinding)((DCBindingContainerReference)object2).getBindingContainer();
        } else if (object2 == null) {
            if (!JUIUtil.inDesignTime()) {
                bindingContext.put((Object)this.getName(), (Object)this);
            } else {
                jUPanelBinding = JUIUtil.createNewDTPanelBinding(this);
                jUPanelBinding.setup(bindingContext, object);
            }
        } else if (object2 != this) {
            jUPanelBinding = (JUPanelBinding)((Object)object2);
        }
        if (jUPanelBinding.getPanel() == null) {
            jUPanelBinding.setPanel(object);
        }
        if (jUPanelBinding.mDataControl == null) {
            jUPanelBinding.useDefaultDataControl(bindingContext);
        }
        return jUPanelBinding;
    }

    public JUPanelBinding(JPanel jPanel) {
        super((Object)jPanel);
    }

    public JUPanelBinding(String string) {
        super(null);
        this.setName(string);
    }

    public JUPanelBinding(String string, JPanel jPanel) {
        this(string, null, jPanel);
    }

    public JUPanelBinding(String string, String string2, JPanel jPanel) {
        super((Object)jPanel);
        this.mAppName = string;
        this.mAMName = string2;
    }

    public void setApplication(JUApplication jUApplication) {
        super.setApplication(jUApplication);
        if (jUApplication != null) {
            jUApplication.setClientApp(BindingContext.CLIENT_TYPE_JCLIENT);
        }
    }

    protected void initializeApplicationModule() {
        if (this.mDataProvider == null) {
            ArrayList arrayList;
            ApplicationModule applicationModule = null;
            if (this.mDataControl == null && (arrayList = this.getIterBindingList()).size() > 0) {
                int n = 0;
                while (n < arrayList.size()) {
                    DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)arrayList.get(n);
                    this.setDataControl(dCIteratorBinding.getDataControl());
                    if (this.mDataControl != null) break;
                    ++n;
                }
            }
            if ((arrayList = this.mDataControl) == null && this.getBindingContext() != null) {
                arrayList = this.getBindingContext().getDefaultDataControl();
            }
            if (arrayList == null) {
                if (JboEnvUtil.isEmptyString((String)this.mAppName)) {
                    throw new InvalidObjNameException(601, this.mAppName);
                }
                arrayList = JUMetaObjectManager.findApplicationObject((String)this.mAppName);
                if (arrayList == null) {
                    throw new NoObjException(601, this.mAppName);
                }
                this.setDataControl((DCDataControl)arrayList);
                if (!arrayList.isJClientApp()) {
                    arrayList.setClientApp(DCDataControl.JCLIENT);
                }
                arrayList.addBindingContainer((DCBindingContainer)this);
            }
            applicationModule = arrayList.getApplicationModule();
            if (!JboEnvUtil.isEmptyString((String)this.mAMName) && (applicationModule = applicationModule.findApplicationModule(this.mAMName)) == null) {
                throw new NoObjException(101, this.mAMName);
            }
            this.setApplicationModule(applicationModule);
        } else if (this.mDataControl == null) {
            this.setDataControl((DCDataControl)new JUApplication(this.mDataProvider));
            this.mDataControl.setClientApp(DCDataControl.JCLIENT);
        }
    }

    public void initializePanel(ArrayList arrayList) {
        JPanel jPanel = (JPanel)this.getPanel();
        if (jPanel != null) {
            LayoutManager layoutManager = (LayoutManager)this.getDef().getLayoutDef().createLayout();
            jPanel.setLayout(layoutManager);
            int n = 0;
            while (n < arrayList.size()) {
                JUControlBinding jUControlBinding = (JUControlBinding)arrayList.get(n);
                Object object = jUControlBinding.getLayoutObject();
                DCLayoutConsDef dCLayoutConsDef = jUControlBinding.getDef().getLayoutCons();
                Object object2 = null;
                if (dCLayoutConsDef != null) {
                    object2 = dCLayoutConsDef.createLayoutCons();
                }
                jUControlBinding.addControlToPanel((Object)jPanel, object, object2);
                ++n;
            }
        }
    }

    public void bindRowSetIterator(String string, String string2) {
        this.bindRowSetIterator(string, (RowSetIterator)this.getApplicationModule().findViewObject(string2));
    }

    public void bindRowSetIterator(String string, RowSetIterator rowSetIterator) {
        JUIteratorBinding jUIteratorBinding = this.findIterBinding(string);
        if (jUIteratorBinding == null) {
            this.reportException(new JboException(class$oracle$jbo$uicli$UIMessageBundle == null ? (class$oracle$jbo$uicli$UIMessageBundle = JUPanelBinding.class$("oracle.jbo.uicli.UIMessageBundle")) : class$oracle$jbo$uicli$UIMessageBundle, "34003", (Object[])new String[]{string}));
        } else {
            jUIteratorBinding.bindRowSetIterator((NavigatableRowIterator)rowSetIterator, true);
            this.notifyIteratorChanged((DCIteratorBinding)jUIteratorBinding, true);
        }
    }

    public final void notifyIteratorChanged(DCIteratorBinding dCIteratorBinding, boolean bl) {
        Object object;
        ArrayList arrayList;
        if (dCIteratorBinding != null) {
            if (bl) {
                dCIteratorBinding.rangeRefreshed(null);
            }
            arrayList = this.mIteratorChangedListeners;
            object = dCIteratorBinding.getNavigatableRowIterator();
            String string = dCIteratorBinding.getName();
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    JUIteratorChangedListener jUIteratorChangedListener = (JUIteratorChangedListener)arrayList.get(n);
                    jUIteratorChangedListener.iteratorChanged(string, (NavigatableRowIterator)object);
                    ++n;
                }
            }
        }
        if ((arrayList = this.mNavigationBarList) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                object = (JUNavigationBarInterface)arrayList.get(n);
                object.iteratorBindingChanged((JUIteratorBinding)dCIteratorBinding);
                ++n;
            }
        }
    }

    public final void addIteratorChangedListener(JUIteratorChangedListener jUIteratorChangedListener) {
        if (this.mIteratorChangedListeners == null) {
            this.mIteratorChangedListeners = new ArrayList(5);
        }
        this.mIteratorChangedListeners.add(jUIteratorChangedListener);
    }

    public final void removeIteratorChangedListener(JUIteratorChangedListener jUIteratorChangedListener) {
        if (this.mIteratorChangedListeners != null) {
            this.mIteratorChangedListeners.remove(jUIteratorChangedListener);
        }
    }

    public final void addNavigationBar(JUNavigationBarInterface jUNavigationBarInterface) {
        if (this.mNavigationBarList == null) {
            this.mNavigationBarList = new ArrayList(5);
        }
        this.mNavigationBarList.add(jUNavigationBarInterface);
        this.mNavBarInit = false;
    }

    public final void removeNavigationBar(JUNavigationBarInterface jUNavigationBarInterface) {
        if (this.mNavigationBarList != null) {
            this.mNavigationBarList.remove(jUNavigationBarInterface);
        }
    }

    public void focusGained(DCIteratorBinding dCIteratorBinding, DCControlBinding dCControlBinding, int n) {
        if (this.mDataControl != null) {
            this.mDataControl.focusGained(dCIteratorBinding, dCControlBinding, n);
        }
        if (this.mNavigationBarList != null) {
            Object var4_4 = null;
            ArrayList arrayList = this.getIterBindingList();
            int n2 = arrayList.size();
            if (n2 > 0 && dCIteratorBinding instanceof JUIteratorBinding) {
                this.mNavBarInit = true;
                arrayList = this.mNavigationBarList;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    ((JUNavigationBarInterface)arrayList.get(n3)).iteratorBindingChanged((JUIteratorBinding)dCIteratorBinding);
                    ++n3;
                }
            }
        }
        this.mBindingInFocus = dCControlBinding;
    }

    public final String getApplicationName() {
        return this.mAppName;
    }

    public final String getAppModuleName() {
        return this.mAMName;
    }

    public final boolean isTransactionDirty() {
        if (this.mDataControl != null) {
            return this.getDataControl().isTransactionDirty();
        }
        try {
            boolean bl = this.getDataControl().isTransactionDirty();
            return bl;
        }
        catch (InvalidObjNameException invalidObjNameException) {
            return false;
        }
    }

    public final void setPanel(Object object) {
        super.setPanelInternal(object);
    }

    public final ArrayList getRowSetListeners() {
        return this.mRowSetListeners != null ? (ArrayList)this.mRowSetListeners.clone() : new ArrayList(0);
    }

    public final void addRowSetListener(JUPanelRowSetListener jUPanelRowSetListener) {
        if (this.mRowSetListeners == null) {
            this.mRowSetListeners = new ArrayList(4);
        }
        if (!this.mRowSetListeners.contains(jUPanelRowSetListener)) {
            this.mRowSetListeners.add(jUPanelRowSetListener);
        }
    }

    public final void removeRowSetListener(JUPanelRowSetListener jUPanelRowSetListener) {
        if (this.mRowSetListeners != null) {
            this.mRowSetListeners.remove(jUPanelRowSetListener);
        }
    }

    public void callBeforeRowNavigated(DCIteratorBinding dCIteratorBinding) {
        this.stopEditing();
        super.callBeforeRowNavigated(dCIteratorBinding);
    }

    public void callBeforeSaveTransaction(DCDataControl dCDataControl) {
        this.stopEditing();
        super.callBeforeSaveTransaction(dCDataControl);
    }

    public void callBeforeSaveTransaction(Transaction transaction) {
    }

    protected void rangeRefreshed(DCIteratorBinding dCIteratorBinding, RangeRefreshEvent rangeRefreshEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).rangeRefreshed((JUIteratorBinding)dCIteratorBinding, rangeRefreshEvent);
                ++n2;
            }
        }
    }

    protected void rangeScrolled(DCIteratorBinding dCIteratorBinding, ScrollEvent scrollEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).rangeScrolled((JUIteratorBinding)dCIteratorBinding, scrollEvent);
                ++n2;
            }
        }
    }

    protected void rowInserted(DCIteratorBinding dCIteratorBinding, InsertEvent insertEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).rowInserted((JUIteratorBinding)dCIteratorBinding, insertEvent);
                ++n2;
            }
        }
    }

    protected void rowDeleted(DCIteratorBinding dCIteratorBinding, DeleteEvent deleteEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).rowDeleted((JUIteratorBinding)dCIteratorBinding, deleteEvent);
                ++n2;
            }
        }
    }

    protected void rowUpdated(DCIteratorBinding dCIteratorBinding, UpdateEvent updateEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).rowUpdated((JUIteratorBinding)dCIteratorBinding, updateEvent);
                ++n2;
            }
        }
    }

    protected void navigated(DCIteratorBinding dCIteratorBinding, NavigationEvent navigationEvent) {
        if (this.mRowSetListeners != null) {
            ArrayList arrayList = (ArrayList)this.mRowSetListeners.clone();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                ((JUPanelRowSetListener)arrayList.get(n2)).navigated((JUIteratorBinding)dCIteratorBinding, navigationEvent);
                ++n2;
            }
        }
    }

    public void setFindMode(boolean bl) {
        this.stopEditing();
        super.setFindMode(bl);
    }

    public void addBindingWithCellEditor(JUPanelStopEditingListener jUPanelStopEditingListener) {
        if (this.mBindingsWithCellEditor == null) {
            this.mBindingsWithCellEditor = new ArrayList(6);
        }
        if (!this.mBindingsWithCellEditor.contains(jUPanelStopEditingListener)) {
            this.mBindingsWithCellEditor.add(jUPanelStopEditingListener);
        }
    }

    public void removeBindingWithCellEditor(JUPanelStopEditingListener jUPanelStopEditingListener) {
        if (this.mBindingsWithCellEditor != null) {
            this.mBindingsWithCellEditor.remove(jUPanelStopEditingListener);
        }
    }

    public void stopEditing() {
        FocusListener[] focusListenerArray;
        Object object;
        int n;
        Serializable serializable;
        this.mEditingStopped = true;
        if (this.mBindingsWithCellEditor != null) {
            serializable = this.mBindingsWithCellEditor;
            int n2 = ((ArrayList)serializable).size();
            n = 0;
            while (n < ((ArrayList)serializable).size()) {
                object = (JUPanelStopEditingListener)((ArrayList)serializable).get(n);
                object.stopEditing();
                ++n;
            }
        }
        if (this.mBindingInFocus != null && this.mBindingInFocus.getControl() != null && (focusListenerArray = ((Component)(serializable = (Component)this.mBindingInFocus.getControl())).getFocusListeners()) != null) {
            n = 0;
            while (n < focusListenerArray.length) {
                if (focusListenerArray[n] instanceof JUSVUpdateableFocusAdapter) {
                    Diagnostic.println((String)"Force tranfer of focus for applying last focused control changes!");
                    object = new FocusEvent((Component)serializable, 1005);
                    ((JUSVUpdateableFocusAdapter)focusListenerArray[n]).focusLost((FocusEvent)object);
                }
                ++n;
            }
        }
    }

    public boolean isEditingStopped() {
        return this.mEditingStopped;
    }

    public void setEditingStopped(boolean bl) {
        this.mEditingStopped = bl;
    }

    public Object bindUIControl(String string, Object object) {
        return this.findCtrlBinding(string).getControlModel(object);
    }

    public void releaseDataControl() {
        if (this.mDataControl != null) {
            this.mDataControl.release();
        }
    }

    public void release(int n) {
        if (n == DCDataControl.REL_ALL_REFS) {
            this.mNavigationBarList = null;
            this.mIteratorChangedListeners = null;
            this.mRowSetListeners = null;
            this.mBindingsWithCellEditor = null;
            this.mBindingInFocus = null;
            this.mNavBarInit = false;
            this.mRequestRefreshControl = false;
            this.mRunLater = null;
        }
        super.release(n);
    }

    protected void useDefaultDataControl(BindingContext bindingContext) {
        ArrayList arrayList = this.getIterBindingList();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)arrayList.get(n);
                if (dCIteratorBinding.getDataControl() != null) {
                    this.setDataControl(dCIteratorBinding.getDataControl());
                    break;
                }
                ++n;
            }
        }
        if (this.mDataControl == null) {
            this.setDataControl(bindingContext.getDefaultDataControl());
        }
    }

    public void requestRefreshControl() {
        if (!this.mRequestRefreshControl) {
            if (this.mRunLater == null) {
                this.mRunLater = new Runnable(){

                    public void run() {
                        JUPanelBinding.this.refreshControl();
                        JUPanelBinding.this.mRequestRefreshControl = false;
                    }
                };
            }
            this.mRequestRefreshControl = true;
            SwingUtilities.invokeLater(this.mRunLater);
        }
    }

    public String getTooltip(String string, String string2, LocaleContext localeContext) {
        if (JUIUtil.inDesignTime()) {
            return string2;
        }
        return super.getTooltip(string, string2, localeContext);
    }

    public String getTooltip(String string, String string2, String string3, LocaleContext localeContext) {
        if (JUIUtil.inDesignTime()) {
            return string3;
        }
        return super.getTooltip(string, string2, string3, localeContext);
    }

    public String getLabel(String string, String string2, LocaleContext localeContext) {
        if (JUIUtil.inDesignTime()) {
            return string2;
        }
        return super.getLabel(string, string2, localeContext);
    }

    public String getLabel(String string, String string2, String string3, LocaleContext localeContext) {
        if (JUIUtil.inDesignTime()) {
            return string3;
        }
        return super.getLabel(string, string2, string3, localeContext);
    }
}

