/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.domain.BlobDomain;
import oracle.jbo.uicli.UIMessageBundle;
import oracle.jbo.uicli.controls.ImageFileFilter;
import oracle.jbo.uicli.jui.JUDefaultControlBinding;
import oracle.jbo.uicli.jui.JUDefaultControlInterface;
import oracle.ord.im.OrdByteArraySource;
import oracle.ord.im.OrdContentSource;
import oracle.ord.im.OrdImageDomain;
import oracle.sql.Datum;

public class JUImageControl
extends JPanel
implements ActionListener,
FocusListener,
JUDefaultControlInterface {
    static /* synthetic */ Class class$oracle$sql$Datum;
    static /* synthetic */ Class class$oracle$jbo$domain$BlobDomain;
    static /* synthetic */ Class class$oracle$ord$im$OrdImageDomain;
    protected BorderLayout _mainPanelLayout = new BorderLayout();
    protected GridBagLayout _buttonPanelLayout = new GridBagLayout();
    protected JScrollPane _imageAggregate;
    protected JLabel _imageDisplay = new JLabel();
    protected JPanel _buttonPanel = new JPanel();
    protected Dimension _buttonPreferredSize = new Dimension(80, 25);
    protected JButton _newButton = new JButton(UIMessageBundle.getResString((String)"02722"));
    protected JButton _clearButton = new JButton(UIMessageBundle.getResString((String)"02723"));
    protected JFileChooser _fileChooser = new JFileChooser();
    private boolean _readOnly;
    private boolean _showUpdateButtons = true;
    private FocusAdapter mFocusAdapter;
    private JUDefaultControlBinding _ctrlBinding;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JUImageControl() {
        this.setLayout(this._mainPanelLayout);
        this._imageAggregate = new JScrollPane(this._imageDisplay);
        this._imageAggregate.setBorder(null);
        this._imageAggregate.setPreferredSize(this._getDefaultPreferredSize());
        this.add((Component)this._imageAggregate, "Center");
        this._buttonPanel = this._createButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this._fileChooser.setFileFilter(new ImageFileFilter());
        this._imageDisplay.addFocusListener(this);
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        if (this.mFocusAdapter != null) {
            // empty if block
        }
        this.mFocusAdapter = focusAdapter;
    }

    public JPanel getButtonsPanel() {
        return this._buttonPanel;
    }

    public JButton getNewButton() {
        return this._newButton;
    }

    public JButton getClearButton() {
        return this._clearButton;
    }

    public JLabel getLabel() {
        return this._imageDisplay;
    }

    public JScrollPane getScrollPane() {
        return this._imageAggregate;
    }

    public void setShowUpdateButtons(boolean bl) {
        this._showUpdateButtons = bl;
        if (this._showUpdateButtons) {
            this.add((Component)this._buttonPanel, "East");
        } else {
            this.remove(this._buttonPanel);
        }
    }

    public boolean getShowUpdateButtons() {
        return this._showUpdateButtons;
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
        this._enableButtons(!this._readOnly);
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && this.mFocusAdapter != null) {
            this.mFocusAdapter.focusGained(focusEvent);
        }
    }

    public void enabledChanged(boolean bl) {
        super.setEnabled(bl);
        this.setReadOnly(this._readOnly);
    }

    public void releaseResources() {
        this._imageDisplay.removeFocusListener(this);
        this._newButton.removeActionListener(this);
        this._clearButton.removeActionListener(this);
        this._newButton.removeFocusListener(this);
        this._clearButton.removeFocusListener(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setReadOnly(this._readOnly);
    }

    public void setModel(JUDefaultControlBinding jUDefaultControlBinding) {
        this._ctrlBinding = jUDefaultControlBinding;
    }

    public JUDefaultControlBinding getModel() {
        return this._ctrlBinding;
    }

    public final Component getComponent() {
        return this;
    }

    public void doClearButtonAction() {
        this._setImage(null);
        DCDataControl dCDataControl = this._ctrlBinding.getIteratorBinding().getDataControl();
        if (dCDataControl.syncNeeded()) {
            dCDataControl.sync("JUImageControl.doClearButtonAction");
        }
    }

    public void doNewButtonAction() {
        int n = this._fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this._fileChooser.getSelectedFile();
            byte[] byArray = this._readImageData(file.getAbsolutePath());
            this._setImage(byArray);
            this._refreshImage(byArray);
        }
    }

    protected void _refreshImage(byte[] byArray) {
        ApplicationModule applicationModule;
        if (this._ctrlBinding != null && (applicationModule = this._ctrlBinding.getApplicationModule()).getSyncMode() != 1) {
            this._displayImage(byArray);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._clearButton) {
            this.doClearButtonAction();
        } else {
            this.doNewButtonAction();
        }
    }

    protected Dimension _getDefaultPreferredSize() {
        return new Dimension(400, 200);
    }

    public void dataChanged(final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this._updateImage(object);
            }
        });
    }

    private void _updateImage(Object object) {
        if (this._ctrlBinding != null && this._ctrlBinding.getIteratorBinding() != null) {
            Class clazz = this._ctrlBinding.getAttributeDef(0).getJavaType();
            if (!this.isAllowedDataType(clazz)) {
                this.setReadOnly(true);
                this._newButton.setEnabled(false);
                return;
            }
            this.setReadOnly(this._ctrlBinding != null ? !this._ctrlBinding.isAttributeUpdateable(0) : true);
            Object object2 = this._ctrlBinding.getValueAt(0);
            if (object2 instanceof BlobDomain) {
                object2 = ((BlobDomain)object2).toByteArray();
            } else if (object2 instanceof OrdImageDomain) {
                try {
                    OrdContentSource ordContentSource = ((OrdImageDomain)object2).getContentSource();
                    if (ordContentSource instanceof OrdByteArraySource) {
                        object2 = ((OrdByteArraySource)ordContentSource).getByteArray();
                    }
                    object2 = ((OrdImageDomain)object2).getDataInByteArray();
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)exception);
                }
            } else if (object2 instanceof Datum) {
                object2 = ((Datum)object2).getBytes();
            }
            if (object2 instanceof byte[]) {
                this._displayImage((byte[])object2);
                return;
            }
        } else {
            this.setReadOnly(true);
        }
        this._imageDisplay.setIcon(null);
    }

    private boolean isAllowedDataType(Class clazz) {
        if ((class$oracle$ord$im$OrdImageDomain == null ? (class$oracle$ord$im$OrdImageDomain = JUImageControl.class$("oracle.ord.im.OrdImageDomain")) : class$oracle$ord$im$OrdImageDomain).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$oracle$jbo$domain$BlobDomain == null ? (class$oracle$jbo$domain$BlobDomain = JUImageControl.class$("oracle.jbo.domain.BlobDomain")) : class$oracle$jbo$domain$BlobDomain).isAssignableFrom(clazz)) {
            return true;
        }
        return (class$oracle$sql$Datum == null ? (class$oracle$sql$Datum = JUImageControl.class$("oracle.sql.Datum")) : class$oracle$sql$Datum).isAssignableFrom(clazz);
    }

    private void _displayImage(byte[] byArray) {
        this._imageDisplay.setIcon(new ImageIcon(byArray));
    }

    protected JPanel _createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this._buttonPanelLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this._newButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._clearButton, gridBagConstraints);
        this._newButton.setPreferredSize(this._buttonPreferredSize);
        this._clearButton.setPreferredSize(this._buttonPreferredSize);
        this._newButton.addActionListener(this);
        this._clearButton.addActionListener(this);
        this._newButton.addFocusListener(this);
        this._clearButton.addFocusListener(this);
        this._enableButtons(false);
        return jPanel;
    }

    protected void _enableButtons(boolean bl) {
        this._newButton.setEnabled(bl);
        this._clearButton.setEnabled(bl);
    }

    private byte[] _readImageData(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray, 0, byArray.length);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    private void _setImage(byte[] byArray) {
        if (this._ctrlBinding != null) {
            Class clazz;
            Class clazz2 = clazz = class$oracle$ord$im$OrdImageDomain == null ? (class$oracle$ord$im$OrdImageDomain = JUImageControl.class$("oracle.ord.im.OrdImageDomain")) : class$oracle$ord$im$OrdImageDomain;
            if (byArray != null && clazz.isAssignableFrom(this._ctrlBinding.getAttributeDef(0).getJavaType())) {
                try {
                    OrdImageDomain ordImageDomain = (OrdImageDomain)clazz.newInstance();
                    ordImageDomain.setContentSource((OrdContentSource)new OrdByteArraySource(byArray));
                    this._ctrlBinding.setDataValueAt(ordImageDomain, 0);
                    return;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._ctrlBinding.setDataValueAt(byArray, 0);
        }
    }
}

