/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.jazn;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.authentication.ADFRolePrincipal;
import oracle.adf.share.security.authentication.ADFUserPrincipal;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.identitymanagement.AttributeFilter;
import oracle.adf.share.security.identitymanagement.Role;
import oracle.adf.share.security.identitymanagement.User;
import oracle.adf.share.security.identitymanagement.spi.IdentityManagement;
import oracle.adf.share.security.providers.jazn.JAZNContextHelper;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.JAZNException;
import oracle.security.jazn.JAZNRuntimeException;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmPrincipal;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RealmUser;
import oracle.security.jazn.realm.RoleManager;
import oracle.security.jazn.spi.xml.XMLPrincipal;

public class JAZNIdentityManagementProvider
implements IdentityManagement {
    public static String PASSWORD_ATTRIBUTE = "orclpasswordattribute";
    private JAZNContextHelper _contextHelper;
    private JAZNConfig _config;
    private RealmManager _realmMgr;
    private boolean _isSimpleName;
    private static boolean _addADFRole = false;
    private static Principal _adfRolePrincipal = null;

    private /* synthetic */ void $init$() {
        this._isSimpleName = true;
    }

    public JAZNIdentityManagementProvider() {
        this(JAZNContextHelper.getInstance());
        JAZNContextHelper.getInstance().setIdentityManagementProvider(this);
    }

    public JAZNIdentityManagementProvider(JAZNContextHelper jAZNContextHelper) {
        this.$init$();
        this._contextHelper = jAZNContextHelper;
        this.init();
    }

    public void init() {
        this._config = this._contextHelper.getEmbeddedJAZNConfig();
        if (this._config == null) {
            this._config = this._contextHelper.getJAZNConfig();
            _addADFRole = false;
        } else if (ADFContext.getCurrent().getSecurityContext().isAnyoneEnabled()) {
            _addADFRole = true;
        }
        this._realmMgr = this._config.getRealmManager();
        ArrayList arrayList = this.getRealms();
        if (arrayList.size() > 1) {
            try {
                String string = System.getProperty("jaas.username.simple");
                if (string != null && string.equals("false")) {
                    this._isSimpleName = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Realm getJAZNRealm(String string) {
        Realm realm = null;
        try {
            realm = this._realmMgr.getRealm(string);
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
        return realm;
    }

    public ArrayList getRealms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = null;
        try {
            set = this._realmMgr.getRealms();
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Realm realm = (Realm)iterator.next();
                arrayList.add(realm.getName());
            }
        }
        return arrayList;
    }

    public RealmUser getRealmUser(Realm realm, String string) {
        if (realm == null) {
            return null;
        }
        RealmUser realmUser = null;
        try {
            realmUser = realm.getUserManager().getUser(string);
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return realmUser;
    }

    public User createUser() {
        return new User();
    }

    public Principal addUser(User user, Credential credential) {
        String string = this._config.getDefaultRealm();
        RealmUser realmUser = null;
        try {
            Realm realm = this._realmMgr.getRealm(string);
            realmUser = realm.getUserManager().createUser(user.getUsername(), credential.getProperty(PASSWORD_ATTRIBUTE));
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return (Principal)realmUser;
    }

    public User getUser(Principal principal) {
        String string = principal.getName();
        if (!this._isSimpleName) {
            if (principal instanceof RealmPrincipal) {
                string = this.getFullName(string, ((RealmPrincipal)principal).getRealm().getName());
            } else if (principal instanceof XMLPrincipal) {
                string = this.getFullName(string, ((XMLPrincipal)principal).getPrincipalRealmName());
            }
        }
        return new User(string);
    }

    public void modifyUser(Principal principal, User user) {
    }

    public void deleteUser(Principal principal) {
    }

    public Principal getUserPrincipal(String string) {
        RealmUser realmUser = null;
        int n = string.indexOf(47);
        String string2 = null;
        string2 = n == -1 ? this._config.getDefaultRealm() : string.substring(0, n);
        Realm realm = this.getJAZNRealm(string2);
        if (realm != null) {
            realmUser = this.getRealmUser(realm, string);
        }
        return (Principal)realmUser;
    }

    public boolean isAddUserSupported() {
        return true;
    }

    public boolean isModifyUserSupported() {
        return true;
    }

    public boolean isDeleteUserSupported() {
        return true;
    }

    public ArrayList getUserList(int n, AttributeFilter[] attributeFilterArray) {
        Set set = null;
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = this._config.getDefaultRealm();
        try {
            Realm realm = this._realmMgr.getRealm(string);
            set = realm.getUserManager().getUsers();
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RealmUser realmUser = (RealmUser)iterator.next();
                arrayList.add(new User(realmUser.getName()));
            }
        }
        return arrayList;
    }

    public ArrayList getUserList(int n, AttributeFilter[] attributeFilterArray, Principal principal) {
        return null;
    }

    public Role createRole() {
        return null;
    }

    public Principal addRole(Role role) {
        return null;
    }

    public void modifyRole(Principal principal, Role role) {
    }

    public void deleteRole(Principal principal) {
    }

    public Role getRole(Principal principal) {
        Principal principal2 = this.getRolePrincipal(principal.getName());
        if (principal2 == null) {
            return null;
        }
        Role role = null;
        if (principal2 instanceof RealmRole) {
            role = this.newRole((RealmRole)principal2);
            this.initRoleMembers(role, (RealmRole)principal2);
        } else if (principal2 instanceof ADFRolePrincipal) {
            role = new Role(principal2.getName());
        }
        return role;
    }

    public Principal getRolePrincipal(String string) {
        RealmRole realmRole = this._contextHelper.getRealmRole(string);
        String string2 = JAZNContextHelper.getRealmName(string, this._config);
        Principal principal = null;
        try {
            Realm realm = this._realmMgr.getRealm(string2);
            RoleManager roleManager = realm.getRoleManager();
            principal = (Principal)roleManager.getRole(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (principal == null && string.equals("anyone")) {
            principal = JAZNIdentityManagementProvider.getADFRolePrincipal();
        }
        return principal;
    }

    public void addToRole(Principal principal, Principal principal2) {
    }

    public void deleteFromRole(Principal principal, Principal principal2) {
    }

    public ArrayList getRoleList(int n, AttributeFilter[] attributeFilterArray) {
        ArrayList<Role> arrayList = new ArrayList<Role>();
        try {
            Role role;
            Set set = this._realmMgr.getRealms();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Realm realm = (Realm)iterator.next();
                RoleManager roleManager = realm.getRoleManager();
                try {
                    Set set2 = roleManager.getRoles();
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        RealmRole realmRole = (RealmRole)iterator2.next();
                        Role role2 = this.newRole(realmRole);
                        this.initRoleMembers(role2, realmRole);
                        arrayList.add(role2);
                    }
                }
                catch (JAZNRuntimeException jAZNRuntimeException) {
                    this._contextHelper.getADFSecurityLogger().log(Level.FINE, "Role unavailable for reaml " + realm.getName());
                }
            }
            if (attributeFilterArray.length == 0 && (role = this.getADFRole()) != null) {
                arrayList.add(role);
            }
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return arrayList;
    }

    public boolean isAddRoleSupported() {
        return true;
    }

    public boolean isModifyRoleSupported() {
        return true;
    }

    public boolean isDeleteRoleSupported() {
        return true;
    }

    void initRoleMembers(Role role, RealmRole realmRole) {
        Realm realm = realmRole.getRealm();
        try {
            RoleManager roleManager = realm.getRoleManager();
            Set set = roleManager.getGrantees(realmRole, true);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                role.addMember((Principal)iterator.next());
            }
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
    }

    Role newRole(RealmRole realmRole) {
        String string = realmRole.getName();
        if (!this._isSimpleName) {
            string = this.getFullName(realmRole.getName(), ((RealmPrincipal)realmRole).getRealm().getName());
        }
        Role role = new Role(string);
        return role;
    }

    String getFullName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(47) == -1) {
            stringBuffer.append(string2).append("/");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    Role getADFRole() {
        Role role = null;
        if (_addADFRole) {
            Principal principal = JAZNIdentityManagementProvider.getADFRolePrincipal();
            role = new Role(principal.getName());
            Iterator iterator = ((ADFRolePrincipal)principal).getUserGrantees().iterator();
            while (iterator.hasNext()) {
                role.addMember((Principal)iterator.next());
            }
        }
        return role;
    }

    static Principal getADFRolePrincipal() {
        if (_addADFRole && _adfRolePrincipal == null) {
            ADFUserPrincipal aDFUserPrincipal = new ADFUserPrincipal("anonymous");
            ADFRolePrincipal aDFRolePrincipal = new ADFRolePrincipal("anyone");
            aDFRolePrincipal.addUserGrantee(aDFUserPrincipal);
            _adfRolePrincipal = aDFRolePrincipal;
        }
        return _adfRolePrincipal;
    }
}

