/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authorization;

import java.security.Permission;
import java.util.Vector;
import oracle.adf.share.security.authorization.ADFPermission;
import oracle.adf.share.security.authorization.PermissionActionDescriptor;

public class DataControlPermission
extends ADFPermission {
    public static final String GRANT_ACTION = "Grant";
    public static final String CREATE_ACTION = "Create";
    public static final String EDIT_ACTION = "Edit";
    public static final String VIEW_ACTION = "View";
    static final PermissionActionDescriptor[] mActionDescriptors = new PermissionActionDescriptor[]{new PermissionActionDescriptor("GRANT", "Grant"), new PermissionActionDescriptor("CREATE", "Create"), new PermissionActionDescriptor("EDIT", "Edit"), new PermissionActionDescriptor("VIEW", "View")};

    public DataControlPermission(String string, String string2) {
        super(string, string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataControlPermission)) {
            return false;
        }
        DataControlPermission dataControlPermission = (DataControlPermission)object;
        System.out.println("equals: " + dataControlPermission.getName());
        if (!this.getName().equalsIgnoreCase(dataControlPermission.getName())) {
            return false;
        }
        return this._actions.equals(dataControlPermission.getActions());
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DataControlPermission)) {
            return false;
        }
        boolean bl = false;
        DataControlPermission dataControlPermission = (DataControlPermission)permission;
        System.out.println("DataControlPermission.implies( " + dataControlPermission.getName() + ", " + dataControlPermission.getActions() + ")");
        bl = !this.getName().equals("*") ? this.getName().equalsIgnoreCase(dataControlPermission.getName()) : true;
        if (!bl) {
            System.out.println("Permission name different");
            return false;
        }
        Vector vector = DataControlPermission.parseActions(permission.getActions());
        int n = 0;
        while (n < vector.size()) {
            if (!this._actionsVector.contains(vector.elementAt(n))) {
                System.out.println("Compared to permission " + dataControlPermission.toString());
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String string = new String("(DataControlPermission ");
        string = string + this.getName() + "/" + this._actions;
        return string;
    }

    public static PermissionActionDescriptor[] getPermissionActionDescriptors() {
        return mActionDescriptors;
    }
}

