/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;

class TimerResult
extends SensorResult {
    int mMax;
    int mMin;

    private /* synthetic */ void $init$() {
        this.mMax = Integer.MIN_VALUE;
        this.mMin = Integer.MAX_VALUE;
    }

    TimerResult(int n) {
        this.$init$();
        this.mNameIndex = n;
    }

    void setValue(String string) {
        ++this.mHit;
        this.mValue = string;
        int n = Integer.parseInt(string);
        this.mElapseTime += (long)n;
        if (n > this.mMax) {
            this.mMax = n;
        }
        if (n < this.mMin) {
            this.mMin = n;
        }
    }

    void print(PrintStream printStream, boolean bl, String string) {
        String string2 = (String)Analyzer.sSensorNames.get(this.mNameIndex);
        if (Analyzer.sFormatXml) {
            int n = string2.lastIndexOf(47);
            String string3 = string2.substring(n + 1);
            String string4 = string2.substring(0, n);
            printStream.print("Timer: (");
            if (bl) {
                printStream.print(" gap=" + TimerResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            printStream.print(" hit=" + TimerResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            printStream.print(" | avg=" + TimerResult.prependSpace(SensorResult.sDblFmt.format((double)this.mElapseTime / (double)this.mHit), 6));
            printStream.print(" | min=" + TimerResult.prependSpace(SensorResult.sDblFmt.format(this.mMin), 6));
            printStream.print(" | max=" + TimerResult.prependSpace(SensorResult.sIntFmt.format(this.mMax), 6));
            printStream.print(" )");
            printStream.println(" " + string3 + " [" + string4 + "]");
        } else {
            printStream.println(string + "Timer:" + string2 + " [id=" + this.mNameIndex + "]");
            printStream.print(string + "(");
            if (bl) {
                printStream.print(" gap=" + TimerResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            printStream.print(" hit=" + TimerResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            printStream.print(" | avg=" + TimerResult.prependSpace(SensorResult.sDblFmt.format((double)this.mElapseTime / (double)this.mHit), 6));
            printStream.print(" | min=" + TimerResult.prependSpace(SensorResult.sDblFmt.format(this.mMin), 6));
            printStream.print(" | max=" + TimerResult.prependSpace(SensorResult.sIntFmt.format(this.mMax), 6));
            if (Analyzer.sDebug) {
                printStream.print(" | ts=" + TimerResult.prependSpace(SensorResult.sIntFmt.format(this.mTimeStamp), 6));
            }
            printStream.println(" )");
            printStream.println("");
        }
    }
}

