/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.CounterResult;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTable;
import oracle.adf.share.perf.analysis.SensorTree;
import oracle.adf.share.perf.analysis.StateResult;
import oracle.adf.share.perf.analysis.TimerResult;

class RequestAnalyzer
extends Analyzer {
    private static final int MAX_NUM_REQUESTS = 1000;
    private static int sIdCount = 0;
    private LinkedHashMap mRequests;
    private Hashtable mMasterSensorTables;

    private /* synthetic */ void $init$() {
        this.mRequests = new LinkedHashMap();
        this.mMasterSensorTables = new Hashtable();
    }

    void analyseLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " [");
        String string2 = this.removeSeqNum(stringTokenizer.nextToken());
        SensorTable sensorTable = (SensorTable)this.mRequests.get(string2);
        if (sensorTable == null) {
            sensorTable = new SensorTable(string2);
            this.mRequests.put(string2, sensorTable);
        }
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken(" []"));
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            long l = Long.parseLong(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken("]").substring(1);
            SensorResult sensorResult = null;
            if (Analyzer.sSensorTypes.get(n).equals("t")) {
                sensorResult = new TimerResult(n);
            } else if (Analyzer.sSensorTypes.get(n).equals("c")) {
                sensorResult = new CounterResult(n);
            } else if (Analyzer.sSensorTypes.get(n).equals("s")) {
                sensorResult = new StateResult(n);
            }
            if (sensorResult == null) continue;
            sensorResult.mThreadId = n2;
            sensorResult.mTimeStamp = l;
            sensorResult.setValue(string3);
            sensorTable.add(sensorResult);
        }
        if (this.mRequests.size() >= 1000) {
            Iterator iterator = this.mRequests.keySet().iterator();
            int n = 0;
            while (iterator.hasNext() && n < 500) {
                ++n;
                this.addToMasterTable(iterator);
            }
        }
    }

    private void addToMasterTable(Iterator iterator) {
        Object v;
        Object e = iterator.next();
        SensorTable sensorTable = (SensorTable)this.mRequests.get(e);
        String string = sensorTable.getURL();
        if (string == null) {
            return;
        }
        sensorTable.reBaseTimeStamp();
        if (Analyzer.sDebug) {
            Analyzer.sOut.println("DEBUG: ecid=" + e + " url=" + string);
            Analyzer.sOut.println("=====================================================");
            sensorTable.print(Analyzer.sOut);
        }
        if ((v = this.mMasterSensorTables.get(string)) == null) {
            if (Analyzer.sExcludeCount > 0) {
                this.mMasterSensorTables.put(string, new Integer(1));
                if (Analyzer.sDebug) {
                    Analyzer.sOut.println("Excluded it from aggregation.");
                }
            } else {
                this.mMasterSensorTables.put(string, sensorTable);
            }
        } else if (v instanceof Integer) {
            int n = (Integer)v;
            if (Analyzer.sExcludeCount < ++n) {
                this.mMasterSensorTables.put(string, sensorTable);
            } else {
                this.mMasterSensorTables.put(string, new Integer(n));
                if (Analyzer.sDebug) {
                    Analyzer.sOut.println("Excluded it from aggregation.");
                }
            }
        } else {
            SensorTable sensorTable2 = (SensorTable)v;
            sensorTable2.aggregate(sensorTable);
            if (Analyzer.sDebug) {
                Analyzer.sOut.println("DEBUG: after aggregate");
                Analyzer.sOut.println("=====================================================");
                sensorTable2.print(Analyzer.sOut);
            }
        }
        iterator.remove();
    }

    void print() {
        Iterator iterator = this.mRequests.keySet().iterator();
        while (iterator.hasNext()) {
            this.addToMasterTable(iterator);
        }
        Hashtable hashtable = RequestAnalyzer.convertToTreeTables(this.mMasterSensorTables);
        if (Analyzer.sFormatXml) {
            Analyzer.sOut.println("<?xml version=\"1.0\" ?>");
            Analyzer.sOut.println("<?xml-stylesheet type=\"text/xsl\" href=\"xmlTree.xsl\"?>");
            Analyzer.sOut.println("<!DOCTYPE tree SYSTEM 'tree.dtd'>");
            Analyzer.sOut.println("<tree>");
        } else {
            Analyzer.sOut.println("===================SUMMARY REPORT====================");
            Analyzer.sOut.println();
        }
        iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashtable.get(string);
            if (!(v instanceof SensorTree)) continue;
            SensorTree sensorTree = (SensorTree)v;
            sensorTree.setThreadGap();
            if (Analyzer.sFormatXml) {
                Analyzer.sOut.println("  <branch id=\"url" + sIdCount++ + "\">");
                Analyzer.sOut.println("    <branchText>(" + sensorTree.getSummary() + ") " + RequestAnalyzer.htmlEncode(string) + "</branchText>");
            } else {
                Analyzer.sOut.println("[" + sensorTree.getSummary() + "] " + string);
                Analyzer.sOut.println("=====================================================");
            }
            sensorTree.print(Analyzer.sOut);
            if (Analyzer.sFormatXml) {
                Analyzer.sOut.println("  </branch>");
                continue;
            }
            Analyzer.sOut.println("=====================================================");
            Analyzer.sOut.println();
        }
        if (Analyzer.sFormatXml) {
            Analyzer.sOut.println("</tree>");
        }
    }

    private static Hashtable convertToTreeTables(Hashtable hashtable) {
        Hashtable<String, SensorTree> hashtable2 = new Hashtable<String, SensorTree>();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashtable.get(string);
            if (!(v instanceof SensorTable)) continue;
            SensorTable sensorTable = (SensorTable)v;
            SensorTree sensorTree = sensorTable.convertToTree();
            hashtable2.put(string, sensorTree);
        }
        return hashtable2;
    }

    private String removeSeqNum(String string) {
        int n = string.lastIndexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    RequestAnalyzer() {
        this.$init$();
    }
}

