/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.adf.share.perf.analysis.RequestAnalyzer;
import oracle.adf.share.perf.analysis.SensorAnalyzer;

public class Analyzer {
    private static final String SENSOR = "sensor";
    private static final String REQUEST = "request";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int PROGRESS_UPDATE_GAP = 100;
    protected static Vector sSensorTypes = new Vector();
    protected static Vector sSensorNames = new Vector();
    protected static int sExcludeCount = 0;
    protected static PrintStream sOut = null;
    protected static final int TYPE_SENSOR = 1;
    protected static final int TYPE_REQUEST = 2;
    protected static int sAnalysisType = 1;
    private static final String AGGTYPE_ALL = "all";
    protected static boolean sTimerOnly = true;
    private static final String FORMAT_XML = "xml";
    protected static boolean sFormatXml = false;
    protected static boolean sAllPattern = false;
    protected static boolean sDebug = false;
    private static /* synthetic */ Class class$oracle$adf$share$perf$analysis$Analyzer;

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Usage: java -cp <classpath> oracle.adf.share.perf.analysis.Analyser [-t sensor|request] [-x <exclude_warmup_counter>] [-a all|timer] [-f text|xml] [-p] [-d] <perflog_path> <output_file_name>");
            System.out.println("Option -t: choose processing type:");
            System.out.println("    sensor - aggregate the performance statistics based on sensor name");
            System.out.println("    request - aggregate the performance statistics based on request");
            System.out.println("    default is 'sensor'");
            System.out.println("Option -x: exclude specified number of warmup encounters to sensors");
            System.out.println("    default is to exclude nothing");
            System.out.println("Option -a: aggregate what type of sensors:");
            System.out.println("    all - aggregate all types of sensors");
            System.out.println("    timers - aggregate timers only");
            System.out.println("    default is to aggregate timers only");
            System.out.println("Option -f: format of the output file (applicable for request type only):");
            System.out.println("    text - pure text format");
            System.out.println("    xml - xml format which can be transformed to tree control html document");
            System.out.println("    default is to use text");
            System.out.println("Option -p: aggregate and report all thread patterns");
            System.out.println("    default is to aggregate and report only top 95% thread patterns and ignore rare (<5%) thread patterns");
            System.out.println("Option -d: debug analysis processing (applicable for request type and text format only)");
            System.out.print("For example: to analyze the performance log file ");
            System.out.print("in /tmp/log directory based on requests, ");
            System.out.print("and exclude the first 5 requests from statistics. ");
            System.out.println("Send result report to result.txt in current working directory.");
            System.out.println(">java oracle.adf.share.perf.analysis.Analyser -t request -x 5 /tmp/log result.txt");
            return;
        }
        try {
            String string = SENSOR;
            int n = 0;
            String string2 = stringArray[n++];
            while (true) {
                if (string2.equalsIgnoreCase("-t")) {
                    string = stringArray[n++];
                    string2 = stringArray[n++];
                    continue;
                }
                if (string2.equalsIgnoreCase("-x")) {
                    sExcludeCount = Integer.parseInt(stringArray[n++]);
                    string2 = stringArray[n++];
                    continue;
                }
                if (string2.equalsIgnoreCase("-a")) {
                    String string3;
                    if ((string3 = stringArray[n++]).equalsIgnoreCase(AGGTYPE_ALL)) {
                        sTimerOnly = false;
                    }
                    string2 = stringArray[n++];
                    continue;
                }
                if (string2.equalsIgnoreCase("-f")) {
                    String string4;
                    if ((string4 = stringArray[n++]).equalsIgnoreCase(FORMAT_XML)) {
                        sFormatXml = true;
                    }
                    string2 = stringArray[n++];
                    continue;
                }
                if (string2.equalsIgnoreCase("-p")) {
                    sAllPattern = true;
                    string2 = stringArray[n++];
                    continue;
                }
                if (!string2.equalsIgnoreCase("-d")) break;
                sDebug = true;
                string2 = stringArray[n++];
            }
            String string5 = string2 + FILE_SEPARATOR;
            String string6 = stringArray[n++];
            if (!string.equalsIgnoreCase(REQUEST)) {
                sFormatXml = false;
            }
            if (sDebug) {
                sFormatXml = false;
                string = REQUEST;
            }
            if (sFormatXml) {
                int n2 = string6.lastIndexOf(46);
                string6 = n2 != -1 ? string6.substring(0, n2) + ".xml" : string6 + ".xml";
                File file = new File(string6);
                String string7 = file.getParent();
                String[] stringArray2 = new String[]{"closed.gif", "doc.gif", "open.gif", "tree.dtd", "xmlTree.css", "xmlTree.js", "xmlTree.xsl"};
                try {
                    byte[] byArray = new byte[1024];
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        int n4;
                        Class clazz = class$oracle$adf$share$perf$analysis$Analyzer;
                        if (clazz == null) {
                            clazz = Analyzer.class$("oracle.adf.share.perf.analysis.Analyzer");
                        }
                        URL uRL = clazz.getResource("resources/" + stringArray2[n3]);
                        InputStream inputStream = uRL.openStream();
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string7, stringArray2[n3]));
                        while ((n4 = inputStream.read(byArray)) > 0) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n4);
                        }
                        inputStream.close();
                        ((OutputStream)fileOutputStream).close();
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.exit(-1);
                }
            }
            sOut = new PrintStream(new FileOutputStream(string6));
            Analyzer analyzer = Analyzer.getAnalyzer(string);
            analyzer.analyse(string5);
            analyzer.print();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static Analyzer getAnalyzer(String string) {
        if (string.equalsIgnoreCase(SENSOR)) {
            sAnalysisType = 1;
            return new SensorAnalyzer();
        }
        if (string.equalsIgnoreCase(REQUEST)) {
            sAnalysisType = 2;
            return new RequestAnalyzer();
        }
        sAnalysisType = 1;
        return new Analyzer();
    }

    void analyse(String string) {
        String string2 = string + "adfperf" + ".log";
        this.process(string2);
        int n = this.getNumberOfLogFile(string);
        while (n >= 0) {
            string2 = string + "adfperf" + n + ".log";
            this.process(string2);
            --n;
        }
    }

    void process(String string) {
        System.out.println("Processing " + string + "...");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            System.out.print("  Processing line# 1");
            while ((string2 = bufferedReader.readLine()) != null) {
                if (++n % 100 == 0) {
                    System.out.print(" " + n);
                }
                if (string2.startsWith("# ")) continue;
                if (string2.startsWith("I ")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    this.addSensor(n2, string3, string4);
                    continue;
                }
                if (string2.startsWith("T ")) continue;
                this.analyseLine(string2);
            }
            System.out.println("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void analyseLine(String string) {
    }

    void addSensor(int n, String string, String string2) {
        if (n + 1 > sSensorNames.size()) {
            sSensorNames.setSize(n + 1);
        }
        if (n + 1 > sSensorTypes.size()) {
            sSensorTypes.setSize(n + 1);
        }
        sSensorNames.set(n, string);
        sSensorTypes.set(n, string2);
    }

    void print() {
    }

    private int getNumberOfLogFile(String string) {
        String string2;
        File file;
        int n = 0;
        while ((file = new File(string2 = string + "adfperf" + n + ".log")).exists()) {
            ++n;
        }
        return --n;
    }

    static String htmlEncode(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

