/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.logging.Level;
import oracle.adf.share.perf.ADFPerfLog;
import oracle.adf.share.perf.ADFPerfSensor;
import oracle.adf.share.perf.PerfUtil;
import oracle.adf.share.perf.TimerProvider;
import oracle.adf.share.perf.TimerToken;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;

public class Timer
extends ADFPerfSensor {
    private PhaseEvent mPEvent;
    private TimerProvider mProvider;
    private ThreadLocal mToken;

    private /* synthetic */ void $init$() {
        this.mPEvent = null;
        this.mProvider = null;
        this.mToken = new 1();
    }

    private Timer(Level level, String string, PhaseEvent phaseEvent) {
        super(level, string);
        this.$init$();
        this.mPEvent = phaseEvent;
    }

    public static Timer createTimer(Level level, String string, String string2, String string3) {
        String string4 = PerfUtil.getNounType(string);
        return Timer.createTimer(level, string, string2, string4, string3);
    }

    public static Timer createTimer(Level level, String string, String string2, String string3, TimerProvider timerProvider) {
        String string4 = PerfUtil.getNounType(string);
        return Timer.createTimer(level, string, string2, string4, string3, timerProvider);
    }

    public static Timer createTimer(Level level, String string, String string2, String string3, String string4) {
        string = PerfUtil.standardizeGroupName(string);
        string2 = PerfUtil.standardizeSensorName(string2);
        String string5 = string + '/' + string2 + " " + "t";
        ADFPerfSensor aDFPerfSensor = PerfUtil.getSensor(string5);
        if (aDFPerfSensor != null && aDFPerfSensor instanceof Timer) {
            return (Timer)aDFPerfSensor;
        }
        PhaseEvent phaseEvent = null;
        if (ADFPerfLog.getLevel().intValue() <= level.intValue() || PerfUtil.getDMSSensorLevel().intValue() <= level.intValue()) {
            Noun noun = Noun.create((String)string);
            if (string3 != null) {
                noun.setType(string3);
            }
            phaseEvent = PhaseEvent.create((Noun)noun, (String)string2, (String)string4);
            phaseEvent.deriveMetric(511);
        }
        Timer timer = new Timer(level, string5, phaseEvent);
        timer = (Timer)PerfUtil.putSensor(string5, timer);
        return timer;
    }

    public static Timer createTimer(Level level, String string, String string2, String string3, String string4, TimerProvider timerProvider) {
        if (timerProvider != null) {
            timerProvider.createTimers(level, string, string2, string3, string4);
            if (!timerProvider.isParentLoggable()) {
                string3 = null;
            }
        }
        Timer timer = Timer.createTimer(level, string, string2, string3, string4);
        timer.mProvider = timerProvider;
        return timer;
    }

    public void start() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerToken timerToken = (TimerToken)this.mToken.get();
        if (!timerToken.mStarted) {
            timerToken.mDMSToken = this.mPEvent.start();
            timerToken.mStarted = true;
        }
    }

    public TimerToken startWithToken() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return null;
        }
        return new TimerToken(true, this.mPEvent.start(), false);
    }

    public void stop() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerToken timerToken = (TimerToken)this.mToken.get();
        if (timerToken.mStarted) {
            long l = this.mPEvent.stop2(timerToken.mDMSToken) - timerToken.mDMSToken;
            if (this.mEnablePerfLog) {
                this.log(timerToken.mDMSToken, Long.toString(l), timerToken.mEcid);
            }
            timerToken.mStarted = false;
        }
    }

    public void stopWithToken(TimerToken timerToken) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (timerToken.mStarted) {
            long l = this.mPEvent.stop2(timerToken.mDMSToken) - timerToken.mDMSToken;
            if (this.mEnablePerfLog) {
                this.log(timerToken.mDMSToken, Long.toString(l), timerToken.mEcid);
            }
            timerToken.mStarted = false;
        }
    }

    public void stop(int n) {
        this.stopComposite(null, n, null);
    }

    public void stopWithToken(TimerToken timerToken, int n) {
        this.stopComposite(timerToken, n, null);
    }

    public void stop(Object object) {
        this.stopComposite(null, 0, object);
    }

    public void stopWithToken(TimerToken timerToken, Object object) {
        this.stopComposite(timerToken, 0, object);
    }

    private void stopComposite(TimerToken timerToken, int n, Object object) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (timerToken == null) {
            timerToken = (TimerToken)this.mToken.get();
        }
        if (timerToken.mStarted) {
            Timer[] timerArray;
            long l = this.mPEvent.stop2(timerToken.mDMSToken);
            long l2 = l - timerToken.mDMSToken;
            if (this.mProvider != null && (timerArray = object != null ? this.mProvider.getTimers(object) : this.mProvider.getTimers(n)) != null) {
                int n2 = 0;
                while (n2 < timerArray.length) {
                    PhaseEvent phaseEvent = timerArray[n2].mPEvent;
                    if (phaseEvent != null) {
                        phaseEvent.start(timerToken.mDMSToken);
                        phaseEvent.stop(timerToken.mDMSToken, l);
                        if (this.mEnablePerfLog) {
                            timerArray[n2].log(timerToken.mDMSToken, Long.toString(l2), timerToken.mEcid);
                        }
                    }
                    ++n2;
                }
            }
            if (this.mEnablePerfLog && (this.mProvider != null && this.mProvider.isParentLoggable() || this.mProvider == null)) {
                this.log(timerToken.mDMSToken, Long.toString(l2), timerToken.mEcid);
            }
            timerToken.mStarted = false;
        }
    }

    public void cleanup() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerToken timerToken = (TimerToken)this.mToken.get();
        if (timerToken.mStarted) {
            this.mPEvent.abort(timerToken.mDMSToken);
            timerToken.mStarted = false;
        }
    }

    public void cleanupWithToken(TimerToken timerToken) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (timerToken.mStarted) {
            this.mPEvent.abort(timerToken.mDMSToken);
            timerToken.mStarted = false;
        }
    }

    public final class 1
    extends ThreadLocal {
        protected synchronized Object initialValue() {
            return new TimerToken(false, 0L, true);
        }
    }
}

