/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.adf.share.perf.PerfLogLine;
import oracle.adf.share.perf.PerfLogRecord;

class PerfFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final long STARTTIME = System.currentTimeMillis();
    static final String LOG_LINE_FORMAT = "# Time stamp line format: T long format of date time (timestamp)" + LINE_SEPARATOR + "# " + "Sensor index line format: " + "I " + "<sensorIndex> <sensorFullName> <type>" + LINE_SEPARATOR + "# " + "Performance entry line format: " + "<ecid> [<sensorIndex> <threadId> <timeStamp> <value>]*" + LINE_SEPARATOR + "# " + "where <type> can be: " + "t - timer, s - state, c - counter" + LINE_SEPARATOR;

    public String formatMessage(LogRecord logRecord) {
        if (!(logRecord instanceof PerfLogLine)) {
            return super.formatMessage(logRecord);
        }
        PerfLogLine perfLogLine = (PerfLogLine)logRecord;
        LinkedList linkedList = perfLogLine.getRecordList();
        if (linkedList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(perfLogLine.getMessage());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" ");
                stringBuffer.append("[");
                PerfLogRecord perfLogRecord = (PerfLogRecord)iterator.next();
                stringBuffer.append(perfLogRecord.getIndex());
                stringBuffer.append(" ");
                stringBuffer.append(perfLogRecord.getThreadID());
                stringBuffer.append(" ");
                stringBuffer.append(perfLogRecord.getMillis() - STARTTIME);
                stringBuffer.append(" ");
                stringBuffer.append(perfLogRecord.getMessage());
                stringBuffer.append("]");
            }
            stringBuffer.append(LINE_SEPARATOR);
            return stringBuffer.toString();
        }
        return null;
    }

    public String format(LogRecord logRecord) {
        return this.formatMessage(logRecord);
    }

    PerfFormatter() {
    }
}

