/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.logging.Level;
import oracle.adf.share.perf.ADFPerfLog;
import oracle.adf.share.perf.ADFPerfSensor;
import oracle.adf.share.perf.PerfUtil;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;

public class Counter
extends ADFPerfSensor {
    private Event mEvent;

    private Counter(Level level, String string, Event event) {
        super(level, string);
        this.mEvent = event;
    }

    public void increase() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mEvent.occurred();
        Object object = this.mEvent.getValue(2);
        if (this.mEnablePerfLog) {
            this.log(System.currentTimeMillis(), object.toString(), null);
        }
    }

    public void reset() {
        this.mEvent.reset();
    }

    public static Counter createCounter(Level level, String string, String string2, String string3) {
        String string4 = PerfUtil.getNounType(string);
        return Counter.createCounter(level, string, string2, string4, string3);
    }

    public static Counter createCounter(Level level, String string, String string2, String string3, String string4) {
        string = PerfUtil.standardizeGroupName(string);
        string2 = PerfUtil.standardizeSensorName(string2);
        String string5 = string + '/' + string2 + " " + "c";
        ADFPerfSensor aDFPerfSensor = PerfUtil.getSensor(string5);
        if (aDFPerfSensor != null && aDFPerfSensor instanceof Counter) {
            return (Counter)aDFPerfSensor;
        }
        Event event = null;
        if (ADFPerfLog.getLevel().intValue() <= level.intValue() || PerfUtil.getDMSSensorLevel().intValue() <= level.intValue()) {
            Noun noun = Noun.create((String)string);
            noun.setType(string3);
            event = Event.create((Noun)noun, (String)string2, (String)string4);
            event.deriveMetric(511);
        }
        Counter counter = new Counter(level, string5, event);
        counter = (Counter)PerfUtil.putSensor(string2, counter);
        return counter;
    }
}

