/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Hashtable;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class FileSystemBackingStore
extends DocumentBackingStore {
    public void initialize(Hashtable hashtable, String string) throws Exception {
        super.initialize(hashtable, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document readDocument(String string) throws Exception {
        XMLDocument xMLDocument;
        BufferedInputStream bufferedInputStream;
        block3: {
            File file = this.getFile(string);
            if (!file.exists()) return null;
            bufferedInputStream = null;
            FileInputStream fileInputStream = null;
            try {
                DOMParser dOMParser = new DOMParser();
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                dOMParser.parse((InputStream)bufferedInputStream);
                xMLDocument = dOMParser.getDocument();
                Object var8_7 = null;
                if (fileInputStream == null) break block3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
        }
        if (bufferedInputStream == null) return xMLDocument;
        bufferedInputStream.close();
        return xMLDocument;
    }

    public void writeDocument(Document document, String string) throws Exception {
        block13: {
            FileOutputStream fileOutputStream;
            block12: {
                ((XMLDocument)document).setEncoding("UTF-8");
                FilterOutputStream filterOutputStream = null;
                fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.getFile(string));
                    filterOutputStream = new BufferedOutputStream(fileOutputStream);
                    ((XMLDocument)document).print((OutputStream)filterOutputStream, "UTF-8");
                    Object var8_5 = null;
                    if (filterOutputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (fileOutputStream != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block13;
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public Document createDocument(String string) throws Exception {
        return new XMLDocument();
    }

    public boolean documentExists(String string) throws Exception {
        return this.getFile(string).exists();
    }

    private File getFile(String string) throws Exception {
        if (string.startsWith("file:")) {
            return new File(new URI(string));
        }
        return new File(string);
    }
}

