/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.adf.share.ADFContext;
import oracle.adf.share.http.HttpSessionScopeAdapter;
import oracle.adf.share.statemanager.StateManagerScopeAdapter;
import oracle.adf.share.statemanager.UUID;

public class HttpStateManagerScopeAdapter
extends StateManagerScopeAdapter {
    private static final String COOKIE_PREFIX = "ORA_adf_";

    public HttpStateManagerScopeAdapter(String string, Hashtable hashtable) {
        super(string, hashtable);
    }

    protected Object generateStateManagerId(Map map) {
        Object object;
        Object var2_2 = null;
        String string = this.generateBrowserCookieName();
        String string2 = null;
        Object object2 = null;
        ADFContext aDFContext = ADFContext.getCurrent();
        if (map instanceof HttpSessionScopeAdapter) {
            string2 = (String)map.get(string);
        } else if (aDFContext.hasEnvironment() && (object = aDFContext.getEnvironment().getRequest()) instanceof HttpServletRequest) {
            string2 = this.readCookieValue((HttpServletRequest)object, string);
        }
        if (string2 != null) {
            object2 = UUID.generateUUID(string2);
        }
        if (object2 == null) {
            Object object3;
            object2 = super.generateStateManagerId(map);
            if (map instanceof HttpSessionScopeAdapter) {
                map.put(string, object2.toString());
            } else if (aDFContext.hasEnvironment() && (object3 = aDFContext.getEnvironment().getResponse()) instanceof HttpServletResponse) {
                this.writeCookieValue((HttpServletResponse)object3, string, object2.toString());
            }
        }
        return object2;
    }

    private String generateBrowserCookieName() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(COOKIE_PREFIX);
        stringBuffer.append(this.getScopeName());
        return stringBuffer.toString();
    }

    private void writeCookieValue(HttpServletResponse httpServletResponse, String string, String string2) {
        if (httpServletResponse.isCommitted()) {
            return;
        }
        String string3 = null;
        try {
            string3 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Cookie cookie = new Cookie(string3, string2);
        httpServletResponse.addCookie(cookie);
    }

    private String readCookieValue(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Cookie cookie = null;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equals(string2)) {
                    cookie = cookieArray[n];
                    break;
                }
                ++n;
            }
        }
        String string3 = null;
        if (cookie != null) {
            string3 = cookie.getValue();
        } else if (httpServletRequest != null) {
            string3 = httpServletRequest.getParameter(string2);
        }
        return string3;
    }
}

