/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContext;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFConfigImpl
implements ADFConfig {
    static final String ADFCONFIG_FILENAME = "META-INF/adf-config.xml";
    static final String CALLBACK_FILE = "META-INF/services/adf-config.properties";
    public static final String ADF_CONFIG_CHILD = "adf-config-child";
    private Hashtable storedResults;
    public static final String nameSpaceURI = "http://xmlns.oracle.com/adf/config";
    private static final ADFLogger mLogger;
    private static Map callbackMap;
    private String mApplicationName;
    private static int appCounter;
    private static /* synthetic */ Class class$org$w3c$dom$Element;
    private static /* synthetic */ Class class$java$util$Map;
    private static /* synthetic */ Class class$oracle$adf$share$config$ADFConfigParsingContext;
    private static /* synthetic */ Class class$oracle$adf$share$config$ADFConfigImpl;

    private /* synthetic */ void $init$() {
        this.storedResults = new Hashtable(10);
    }

    ADFConfigImpl() {
        this.$init$();
        this.init();
    }

    ADFConfigImpl(InputStream inputStream, String string) {
        this.$init$();
        this.init();
        this.readConfig(inputStream, string);
    }

    public Object getId() {
        return this;
    }

    public void init() {
        this.generateApplicationName();
    }

    /*
     * Loose catch block
     */
    static {
        block13: {
            Class clazz = class$oracle$adf$share$config$ADFConfigImpl;
            if (clazz == null) {
                clazz = class$oracle$adf$share$config$ADFConfigImpl = ADFConfigImpl.class$("oracle.adf.share.config.ADFConfigImpl");
            }
            mLogger = ADFLogger.createADFLogger(clazz.getName());
            callbackMap = new HashMap(10);
            appCounter = 0;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> enumeration = classLoader.getResources(CALLBACK_FILE);
                if (enumeration == null) break block13;
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = null;
                    inputStream = uRL.openStream();
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    callbackMap.putAll(properties);
                    Object var9_7 = null;
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        exception.toString();
                    }
                    continue;
                    {
                        catch (IOException iOException) {
                            var9_7 = null;
                            if (inputStream == null) continue;
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                exception.toString();
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_7 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                exception.toString();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readConfig(InputStream inputStream, String string) {
        block19: {
            block20: {
                try {
                    try {
                        Set set;
                        XMLElement xMLElement;
                        block22: {
                            block21: {
                                if (inputStream == null) {
                                    throw new IllegalArgumentException();
                                }
                                DOMParser dOMParser = new DOMParser();
                                dOMParser.setPreserveWhitespace(true);
                                dOMParser.parse(inputStream);
                                xMLElement = (XMLElement)dOMParser.getDocument().getDocumentElement();
                                if (xMLElement == null) break block19;
                                set = callbackMap.keySet();
                                if (set == null) break block21;
                                if (!set.isEmpty()) break block22;
                            }
                            Object var20_6 = null;
                            break block20;
                        }
                        NodeList nodeList = xMLElement.getChildNodes();
                        Object object = null;
                        try {
                            object = ADFContext.getCurrent().getEnvironment().getContext();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n = 0;
                        while (nodeList != null && n < nodeList.getLength()) {
                            Map map;
                            Node node = nodeList.item(n);
                            String string2 = node.getNamespaceURI();
                            if (set.contains(string2) && (map = this.getResultFromComponent(node, (Map)this.storedResults.get(string2), object, string)) != null) {
                                this.storedResults.put(string2, map);
                            }
                            ++n;
                        }
                        break block19;
                    }
                    catch (XMLParseException xMLParseException) {
                        StringBuffer stringBuffer = new StringBuffer(xMLParseException.getMessage());
                        stringBuffer.append(" Error at Col number: " + xMLParseException.getColumnNumber());
                        stringBuffer.append("Line number : " + xMLParseException.getLineNumber());
                        mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + stringBuffer);
                        throw new RuntimeException(xMLParseException);
                    }
                    catch (Exception exception) {
                        String string3 = exception.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + string3, exception);
                        throw new RuntimeException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var20_8 = null;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        String string4 = exception.getMessage();
                        if (string4 == null) {
                            string4 = "";
                        }
                        mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + string4, exception);
                        throw new RuntimeException(exception);
                    }
                }
            }
            try {}
            catch (Exception exception) {
                String string5 = exception.getMessage();
                if (string5 == null) {
                    string5 = "";
                }
                mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + string5, exception);
                throw new RuntimeException(exception);
            }
            inputStream.close();
            return;
        }
        Object var20_7 = null;
        try {}
        catch (Exception exception) {
            String string6 = exception.getMessage();
            if (string6 == null) {
                string6 = "";
            }
            mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + string6, exception);
            throw new RuntimeException(exception);
        }
        inputStream.close();
    }

    private Map getResultFromComponent(Node node, Map map, Object object, String string) {
        String string2 = (String)callbackMap.get(node.getNamespaceURI());
        Map map2 = null;
        try {
            Class clazz;
            Class clazz2;
            Class<?> clazz3 = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
            Object obj = clazz3.newInstance();
            Class[] classArray = new Class[3];
            Class clazz4 = class$org$w3c$dom$Element;
            if (clazz4 == null) {
                clazz4 = classArray[0] = (class$org$w3c$dom$Element = ADFConfigImpl.class$("org.w3c.dom.Element"));
            }
            if ((clazz2 = class$java$util$Map) == null) {
                clazz2 = classArray[1] = (class$java$util$Map = ADFConfigImpl.class$("java.util.Map"));
            }
            if ((clazz = class$oracle$adf$share$config$ADFConfigParsingContext) == null) {
                clazz = class$oracle$adf$share$config$ADFConfigParsingContext = ADFConfigImpl.class$("oracle.adf.share.config.ADFConfigParsingContext");
            }
            classArray[2] = clazz;
            Method method = clazz3.getMethod("parseADFConfiguration", classArray);
            ADFConfigParsingContext aDFConfigParsingContext = new ADFConfigParsingContext(this.mApplicationName, object, string);
            map2 = (Map)method.invoke(obj, node, map, aDFConfigParsingContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + classNotFoundException.getMessage(), classNotFoundException.getCause());
        }
        catch (Exception exception) {
            mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  " + exception.getMessage(), exception.getCause());
        }
        return map2;
    }

    public Map getConfigObject(String string) {
        return (Map)this.storedResults.get(string);
    }

    public Object getMDSInstance() {
        Map map = (Map)this.storedResults.get("http://xmlns.oracle.com/adf/mds/config");
        if (map == null) {
            throw new RuntimeException("Unable to find MDS configuration");
        }
        return map.get("MDSInstance");
    }

    public Context getConnectionsContext() throws NamingException {
        Hashtable hashtable = (Hashtable)this.storedResults.get("http://xmlns.oracle.com/adf/jndi/config");
        if (hashtable == null) {
            return FallbackConfigImpl.getDefaultConnectionsContext();
        }
        return new InitialContext(hashtable);
    }

    private synchronized void generateApplicationName() {
        this.mApplicationName = "ADFApplication" + ++appCounter;
    }

    public Context getSecurityContext() throws NamingException {
        Hashtable hashtable = (Hashtable)this.storedResults.get("http://xmlns.oracle.com/adf/security/config");
        if (hashtable == null) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        JAASInitialContextFactory jAASInitialContextFactory = new JAASInitialContextFactory();
        return jAASInitialContextFactory.getInitialContext(hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

